/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.XmlUnit;
import java.io.File;
import org.w3c.dom.Node;

public class Directory
extends XmlUnit {
    @XmlUnit.Serial
    public String folder;
    @XmlUnit.Serial
    boolean resource;
    @XmlUnit.Serial
    String extension;
    String[] _paths;

    public Directory() {
    }

    public Directory(String id, String folder, boolean res) {
        this.setId(id);
        this.resource = res;
        this.folder = folder;
        this.xmlPostLoadCallback(null, null);
        this.markStructured();
    }

    public Directory(String id, String folder, boolean res, Enum[] files, Common.Ext ext) {
        this(id, folder, res, files, ext.name());
    }

    public Directory(String id, String folder, boolean res, Enum[] files, String ext) {
        this.setId(id);
        this.resource = res;
        this.folder = folder;
        this.extension = ext;
        this.xmlPostLoadCallback(null, null);
        if (files != null) {
            this._paths = new String[files.length];
            int i = 0;
            for (Enum enm : files) {
                this._paths[i++] = this.folder + enm.name() + this.extension;
            }
        }
        this.markStructured();
    }

    @Override
    protected void xmlPostLoadCallback(Node unit, XmlUnit.State state) {
        if (!this.resource) {
            File path = new File(this.folder);
            path.mkdirs();
            this.folder = path.getAbsolutePath();
        }
        this.folder = this.formatFolder(this.folder);
        this.extension = this.formatExt(this.extension);
    }

    public boolean isResource() {
        return this.resource;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getExtension() {
        return this.extension;
    }

    private String formatFolder(String folder) {
        if (folder == null || folder.equals("")) {
            folder = "";
        } else if (folder.charAt(folder.length() - 1) != '/') {
            folder = folder + "/";
        }
        if (this.isResource() && (folder.equals("") || folder.charAt(0) != '/')) {
            folder = "/" + folder;
        }
        return folder;
    }

    private String formatExt(String ext) {
        if (ext == null || ext.equals("")) {
            ext = "";
        } else if (ext.charAt(0) != '.') {
            ext = "." + ext;
        }
        return ext;
    }

    public void setExtension(Enum file, String ext) {
        this._paths[file.ordinal()] = this.folder + file.name() + this.formatExt(ext);
    }

    public void setExtension(Enum file, Common.Ext ext) {
        this.setExtension(file, ext.name());
    }

    public void setBaseName(Enum file, String baseName) {
        this._paths[file.ordinal()] = this.folder + baseName;
    }

    public void setPath(Enum file, String path) {
        this._paths[file.ordinal()] = path;
    }

    public String getPath(Enum file) {
        return this._paths[file.ordinal()];
    }

    public String getPath(String baseName) {
        return this.folder + baseName;
    }
}

