/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.IconGroup;
import com.edgytech.swingfast.IntFieldInterface;
import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import org.w3c.dom.Node;

public class ComboBox
extends XmlUnitField<XmlUnit, JComboBox>
implements ActionListener,
StringFieldInterface,
IntFieldInterface {
    public static final String ITEM_SEPARATOR = ";";
    @XmlUnit.Serial
    public String[] items;
    @XmlUnit.Serial
    public String iconGroup;
    @XmlUnit.Serial
    public int maximumRowCount = 0;
    @XmlUnit.SerialStar
    public int value = 0;
    @XmlUnit.SerialStar
    public String stringValue;
    @XmlUnit.Serial
    public boolean editable = false;
    private boolean _restructuring = false;

    public ComboBox() {
    }

    public ComboBox(String id, String label, String[] items) {
        this();
        this.setId(id);
        this.setLabel(label);
        this.items = items;
        this.markStructured();
    }

    @Override
    protected JComboBox createComponent() {
        JComboBox box = new JComboBox();
        box.addActionListener(this);
        return box;
    }

    @Override
    protected void structureComponentCustom(JComboBox old) {
        String longest = null;
        int maxLen = 0;
        FontMetrics fm = old.getFontMetrics(old.getFont());
        if (this.items != null) {
            this._restructuring = true;
            old.removeAllItems();
            for (String item : this.items) {
                ImageIcon ic = null;
                if (this.iconGroup != null) {
                    IconGroup group = IconGroup.getGroup(this.iconGroup);
                    if (group == null) {
                        this.logErrorLine("Could not find IconGroup " + this.iconGroup);
                    } else {
                        ic = group.getIcon(item);
                    }
                }
                if (ic != null) {
                    old.addItem(ic);
                    continue;
                }
                old.addItem(item);
                int len = fm.stringWidth(item);
                if (longest != null && maxLen >= len) continue;
                longest = item;
                maxLen = len;
            }
            this._restructuring = false;
        }
        if (this.maximumRowCount > 0) {
            old.setMaximumRowCount(this.maximumRowCount);
        }
        old.setEditable(this.editable);
        if (this.editable && longest != null) {
            old.setPrototypeDisplayValue(longest);
            old.setPreferredSize(new Dimension(maxLen + 50, fm.getHeight() + 10));
        }
    }

    @Override
    protected void updateComponentCustom(JComboBox old) {
        if (this.value >= 0 && old.getSelectedIndex() != this.value) {
            old.setSelectedIndex(this.value);
        } else if (this.editable && this.stringValue != null && !this.stringValue.equals((String)old.getSelectedItem())) {
            old.setSelectedItem(this.stringValue);
        }
    }

    @Override
    protected boolean checkComponentCustom(JComboBox comp) {
        return true;
    }

    @Override
    protected void commitComponentCustom(JComboBox comp) {
        this.value = comp.getSelectedIndex();
        this.stringValue = this.value == -1 ? (String)comp.getSelectedItem() : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox box = (JComboBox)this.getComponent();
        if (!this._restructuring && this.hasListener()) {
            this.notifyListener(box);
        }
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
    }

    @Override
    public String getStringValue() {
        if (this.value < 0) {
            return this.stringValue;
        }
        return this.items[this.value];
    }

    @Override
    public void setStringValue(String value) {
        int i = 0;
        for (String item : this.items) {
            if (item.equals(value)) {
                this.value = i;
                return;
            }
            ++i;
        }
        this.value = -1;
        this.stringValue = value;
    }

    @Override
    public String getComponentStringValue() {
        return (String)((JComboBox)this.getComponent()).getSelectedItem();
    }

    @Override
    public void setComponentStringValue(String value) {
        ((JComboBox)this.getComponent()).setSelectedItem(value);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setIntValue(int value) {
        this.value = value;
    }

    @Override
    public int getComponentIntValue() {
        return ((JComboBox)this.getComponent()).getSelectedIndex();
    }

    @Override
    public void setComponentIntValue(int value) {
        ((JComboBox)this.getComponent()).setSelectedIndex(value);
    }
}

