/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.ColorChooserDialog;
import com.edgytech.swingfast.Cursor;
import com.edgytech.swingfast.IntFieldInterface;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import org.w3c.dom.Element;

public class ColorField
extends XmlUnitField<XmlUnit, JLabel>
implements MouseListener,
IntFieldInterface {
    @XmlUnit.SerialStar
    Color value;
    @XmlUnit.Serial
    public String dialogId;
    ColorChooserDialog _chooserDialog;

    public ColorField() {
        this.fixedSize = new Dimension(40, 20);
        this.value = Color.WHITE;
        this.borderColor = Color.BLACK;
        this.cursor = Cursor.HAND_CURSOR;
        this.opaque = true;
    }

    public Color getColor() {
        return this.value;
    }

    public void setColor(Color color) {
        this.value = color;
    }

    @Override
    protected void structure(Element elmt) {
        super.structure(elmt);
        this._chooserDialog = this.getFirstChildOfClass(ColorChooserDialog.class, this.dialogId);
        if (this._chooserDialog == null) {
            this._chooserDialog = new ColorChooserDialog(this.dialogId);
        }
    }

    @Override
    protected JLabel createComponent() {
        JLabel panel = new JLabel();
        panel.setOpaque(true);
        panel.addMouseListener(this);
        return panel;
    }

    @Override
    protected void structureComponentCustom(JLabel old) {
    }

    @Override
    protected void updateComponentCustom(JLabel old) {
        old.setBackground(this.value);
    }

    @Override
    protected boolean checkComponentCustom(JLabel comp) {
        return true;
    }

    @Override
    protected void commitComponentCustom(JLabel comp) {
        this.value = comp.getBackground();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this._chooserDialog.getColorChooser().setIntValue(this.getComponentIntValue());
        if (this._chooserDialog.show()) {
            this.setComponentIntValue(this._chooserDialog.getColorChooser().getIntValue());
            this.notifyListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public int getIntValue() {
        return this.value.getRGB();
    }

    @Override
    public void setIntValue(int value) {
        this.value = new Color(value, true);
    }

    @Override
    public int getComponentIntValue() {
        return ((JLabel)this.getComponent()).getBackground().getRGB();
    }

    public Color getComponentColor() {
        return new Color(((JLabel)this.getComponent()).getBackground().getRGB());
    }

    @Override
    public void setComponentIntValue(int value) {
        ((JLabel)this.getComponent()).setBackground(new Color(value, true));
    }
}

