/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.CollectionPane;
import com.edgytech.swingfast.CollectionPaneThumbnail;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.ThumbnailProvider;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CollectionPane2D
extends CollectionPane {
    @XmlUnit.Serial
    int numColumns = 0;
    @XmlUnit.Serial
    int numRows = 0;
    @XmlUnit.Serial
    Common.Align hAlign = Common.Align.CENTER;
    @XmlUnit.Serial
    Common.Align vAlign = Common.Align.CENTER;

    @Override
    protected JComponent createComponent() {
        BoxPanel comp = new BoxPanel(Common.Axis.Y, Common.Align.LEADING, false);
        return comp;
    }

    @Override
    protected void structureComponentCustom(JComponent comp) {
        GroupLayout.ParallelGroup group;
        int i;
        comp.removeAll();
        if (this.selectionMode == CollectionPane.Mode.AGGREGATE) {
            if (this.selectAll == null) {
                this.selectAll = new JButton("Select All");
                this.selectAll.addActionListener(this);
                this.selectNone = new JButton("Select None");
                this.selectNone.addActionListener(this);
            }
            BoxPanel buttons = new BoxPanel(Common.Axis.X, true);
            buttons.add(this.selectAll);
            buttons.add(this.selectNone);
            buttons.setOpaque(false);
            comp.add(buttons);
        }
        JPanel grid = new JPanel();
        grid.setOpaque(false);
        comp.add(grid);
        int numElmts = this._providerList.size();
        int columns = this.numColumns;
        int rows = this.numRows;
        if (columns <= 0 && rows <= 0) {
            columns = 1;
        }
        if (columns > 0) {
            rows = numElmts / columns;
            rows = numElmts % columns > 0 ? rows + 1 : rows;
        } else if (rows > 0) {
            columns = numElmts / rows;
            columns = numElmts % rows > 0 ? columns + 1 : columns;
        }
        Dimension size = null;
        size = this.thumbnailSize != null ? this.thumbnailSize : grid.getPreferredSize();
        int maxWidth = size.width;
        int maxHeight = size.height;
        GroupLayout layout = new GroupLayout(grid);
        grid.setLayout(layout);
        layout.setAutoCreateGaps(this.gap);
        layout.setAutoCreateContainerGaps(this.gap);
        GroupLayout.SequentialGroup hgroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vgroup = layout.createSequentialGroup();
        ArrayList<GroupLayout.ParallelGroup> columnGroups = new ArrayList<GroupLayout.ParallelGroup>();
        ArrayList<GroupLayout.ParallelGroup> rowGroups = new ArrayList<GroupLayout.ParallelGroup>();
        for (i = 0; i < columns; ++i) {
            group = layout.createParallelGroup(this.align2Alignment(this.vAlign));
            hgroup.addGroup(group);
            columnGroups.add(group);
        }
        for (i = 0; i < rows; ++i) {
            group = layout.createParallelGroup(this.align2Alignment(this.hAlign));
            vgroup.addGroup(group);
            rowGroups.add(group);
        }
        i = 0;
        for (ThumbnailProvider prov : this._providerList) {
            Component img = prov.getThumbnailComponent(maxWidth, maxHeight);
            CollectionPaneThumbnail mouse = new CollectionPaneThumbnail(prov, img, this.selected.contains(i), this);
            mouse.setToolTipText(prov.getThumbnailComponentTooltip());
            int col = i % columns;
            ((GroupLayout.ParallelGroup)columnGroups.get(col)).addComponent(mouse);
            int row = i / columns;
            ((GroupLayout.ParallelGroup)rowGroups.get(row)).addComponent(mouse);
            ++i;
        }
        layout.setHorizontalGroup(hgroup);
        layout.setVerticalGroup(vgroup);
    }

    private GroupLayout.Alignment align2Alignment(Common.Align align) {
        switch (align) {
            case BASELINE: {
                return GroupLayout.Alignment.BASELINE;
            }
            case LEADING: {
                return GroupLayout.Alignment.LEADING;
            }
            case CENTER: {
                return GroupLayout.Alignment.CENTER;
            }
            case TRAILING: {
                return GroupLayout.Alignment.TRAILING;
            }
        }
        return GroupLayout.Alignment.CENTER;
    }
}

