/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.CollectionPaneThumbnail;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.ThumbnailProvider;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public class CollectionPane
extends XmlJComponentUnit<XmlUnit, JComponent>
implements ActionListener {
    @XmlUnit.Serial
    public Dimension thumbnailSize;
    @XmlUnit.Serial
    public Common.Axis axis = Common.Axis.Y;
    @XmlUnit.Serial
    public Common.Align align = Common.Align.CENTER;
    @XmlUnit.Serial
    public boolean gap = true;
    @XmlUnit.Serial
    public int gapSize = -1;
    @XmlUnit.Serial
    public int borderSize = 2;
    @XmlUnit.Serial
    public Color defaultBorderColor = Color.WHITE;
    @XmlUnit.Serial
    public Color selectBorderColor = Color.YELLOW;
    @XmlUnit.Serial
    public Mode selectionMode;
    HashMap<String, ThumbnailProvider> _providerMap = new HashMap();
    List<ThumbnailProvider> _providerList = new ArrayList<ThumbnailProvider>();
    List<CollectionPaneThumbnail> _thumbList = new ArrayList<CollectionPaneThumbnail>();
    ArrayList<Integer> selected = new ArrayList();
    private List<AbstractButton> prevButtons;
    private List<AbstractButton> nextButtons;
    JButton selectAll;
    JButton selectNone;

    public CollectionPane() {
        this.selectionMode = Mode.SINGLE;
        this.prevButtons = new ArrayList<AbstractButton>();
        this.nextButtons = new ArrayList<AbstractButton>();
    }

    public ThumbnailProvider getSelectedElement() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this._providerList.get(index);
    }

    public CollectionPaneThumbnail getSelectedThumbnail() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this._thumbList.size()) {
            return null;
        }
        return this._thumbList.get(index);
    }

    public List<ThumbnailProvider> getSelectedElements() {
        ArrayList<ThumbnailProvider> list = new ArrayList<ThumbnailProvider>();
        for (int index : this.selected) {
            list.add(this._providerList.get(index));
        }
        return list;
    }

    public List<CollectionPaneThumbnail> getSelectedThumbnails() {
        ArrayList<CollectionPaneThumbnail> list = new ArrayList<CollectionPaneThumbnail>();
        for (int index : this.selected) {
            list.add(this._thumbList.get(index));
        }
        return list;
    }

    public int getSelectedIndex() {
        if (this.selected.size() > 0) {
            return this.selected.get(0);
        }
        return -1;
    }

    public List<ThumbnailProvider> getElements() {
        return this._providerList;
    }

    public int getSize() {
        return this._providerList.size();
    }

    public ThumbnailProvider add(String id, ThumbnailProvider thumbnail, boolean select) {
        return this.add(id, thumbnail, select, -1);
    }

    public ThumbnailProvider addAfter(String id, ThumbnailProvider thumbnail, boolean select, ThumbnailProvider other) {
        int index = this._providerList.indexOf(other);
        return this.add(id, thumbnail, select, index >= 0 ? index + 1 : -1);
    }

    public ThumbnailProvider addBefore(String id, ThumbnailProvider thumbnail, boolean select, ThumbnailProvider other) {
        int index = this._providerList.indexOf(other);
        return this.add(id, thumbnail, select, index >= 0 ? index : -1);
    }

    public ThumbnailProvider add(String id, ThumbnailProvider thumbnail, boolean select, int index) {
        ThumbnailProvider old = this._providerMap.get(id);
        if (old != null) {
            return old;
        }
        this._providerMap.put(id, thumbnail);
        if (index >= 0) {
            this._providerList.add(index, thumbnail);
        } else {
            this._providerList.add(thumbnail);
            index = this._providerList.size() - 1;
        }
        thumbnail.thumbnailAdded();
        if (select) {
            this.select(index);
        } else {
            this.structureComponent();
        }
        this.updateButtons();
        return null;
    }

    public ThumbnailProvider remove(String id) {
        ThumbnailProvider thumb = this._providerMap.get(id);
        if (thumb == null) {
            return null;
        }
        int toremove = this._providerList.indexOf(thumb);
        if (this.selected.contains(toremove)) {
            if (this.selectionMode == Mode.SMART) {
                if (!this.selectNext() && !this.selectPrevious()) {
                    this.selectNone();
                }
            } else if (this.selectionMode == Mode.SINGLE) {
                this.selectNone();
            } else if (this.selectionMode == Mode.MULTIPLE || this.selectionMode == Mode.AGGREGATE) {
                thumb.thumbnailDeselected();
                this.selected.remove((Object)toremove);
            }
        }
        this._providerMap.remove(id);
        int where = this._providerList.indexOf(thumb);
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (Integer index : this.selected) {
            if (index >= where) {
                newList.add(index - 1);
                continue;
            }
            newList.add(index);
        }
        this.selected = newList;
        this._providerList.remove(where);
        thumb.thumbnailRemoved();
        this.structureComponent();
        this.updateButtons();
        return thumb;
    }

    public void clear() {
        this.selectNone();
        for (ThumbnailProvider prov : this._providerList) {
            prov.thumbnailRemoved();
        }
        this._providerList.clear();
        this._providerMap.clear();
        this.structureComponent();
        this.updateButtons();
    }

    public boolean contains(String id) {
        return this._providerMap.containsKey(id);
    }

    public boolean select(String id) {
        if (id == null) {
            return false;
        }
        ThumbnailProvider prov = this._providerMap.get(id);
        if (prov == null) {
            return false;
        }
        this.select(prov, false, false);
        return true;
    }

    private void select(int newIndex) {
        this.select(newIndex, false, false);
    }

    private void select(int newIndex, boolean ctrl, boolean shift) {
        if (newIndex < 0 || this.selectionMode == Mode.NONE) {
            return;
        }
        if (this.selectionMode == Mode.SINGLE || this.selectionMode == Mode.SMART) {
            int index = this.getSelectedIndex();
            if (index == newIndex) {
                return;
            }
            if (index >= 0) {
                this._providerList.get(index).thumbnailDeselected();
                this.selected.clear();
            }
            this.selected.add(newIndex);
            this._providerList.get(newIndex).thumbnailSelected();
        } else if (this.selectionMode == Mode.MULTIPLE || this.selectionMode == Mode.AGGREGATE) {
            if (this.selectionMode == Mode.AGGREGATE) {
                ctrl = true;
            }
            boolean wasSelected = this.selected.contains(newIndex);
            if (!ctrl) {
                int from = -1;
                if (shift) {
                    from = this.getClosestPreviousSelected(newIndex);
                }
                for (int index : this.selected) {
                    this._providerList.get(index).thumbnailDeselected();
                }
                this.selected.clear();
                if (from < 0 || from > newIndex) {
                    from = newIndex;
                }
                for (int i = from; i <= newIndex; ++i) {
                    this._providerList.get(i).thumbnailSelected();
                    this.selected.add(i);
                }
            } else if (!shift) {
                if (wasSelected) {
                    this._providerList.get(newIndex).thumbnailDeselected();
                    this.selected.remove((Object)newIndex);
                } else {
                    this._providerList.get(newIndex).thumbnailSelected();
                    this.selected.add(newIndex);
                }
            } else {
                int from = this.getClosestPreviousSelected(newIndex);
                if (from < 0 || from > newIndex) {
                    from = newIndex;
                }
                for (int i = from; i <= newIndex; ++i) {
                    if (this.selected.contains(i)) continue;
                    this._providerList.get(i).thumbnailSelected();
                    this.selected.add(i);
                }
            }
        }
        this.structureComponent();
        this.updateButtons();
    }

    public void selectAll() {
        if (this.selectionMode == Mode.SINGLE || this.selectionMode == Mode.SMART) {
            return;
        }
        for (int i = 0; i < this._providerList.size(); ++i) {
            if (this.selected.contains(i)) continue;
            this._providerList.get(i).thumbnailSelected();
            this.selected.add(i);
        }
        this.structureComponent();
        this.updateButtons();
    }

    public void selectNone() {
        for (int index : this.selected) {
            this._providerList.get(index).thumbnailDeselected();
        }
        this.selected.clear();
        this.structureComponent();
        this.updateButtons();
    }

    boolean select(ThumbnailProvider prov, boolean ctrl, boolean shift) {
        int index = this._providerList.indexOf(prov);
        if (index >= 0) {
            this.select(index, ctrl, shift);
            return true;
        }
        return false;
    }

    public ThumbnailProvider getPrevious() {
        int index = this.getSelectedIndex();
        if (index > 0) {
            return this._providerList.get(index - 1);
        }
        return null;
    }

    public boolean selectPrevious() {
        int index = this.getSelectedIndex();
        if (index > 0) {
            this.select(index - 1);
            return true;
        }
        return false;
    }

    public int size() {
        return this._providerList.size();
    }

    public ThumbnailProvider get(int index) {
        if (index >= 0 && index < this._providerList.size()) {
            return this._providerList.get(index);
        }
        return null;
    }

    public CollectionPaneThumbnail getThumbnail(int index) {
        if (index >= 0 && index < this._thumbList.size()) {
            return this._thumbList.get(index);
        }
        return null;
    }

    public ThumbnailProvider getNext() {
        int index = this.getSelectedIndex();
        if (index < this._providerList.size() - 1) {
            return this._providerList.get(index + 1);
        }
        return null;
    }

    public boolean selectNext() {
        int index = this.getSelectedIndex();
        if (index < this._providerList.size() - 1) {
            this.select(index + 1);
            return true;
        }
        return false;
    }

    @Override
    protected JComponent createComponent() {
        BoxPanel collection = new BoxPanel(this.axis, this.align, this.gap, this.gapSize);
        return collection;
    }

    @Override
    protected void structureComponentCustom(JComponent comp) {
        Dimension size = null;
        size = this.thumbnailSize != null ? this.thumbnailSize : comp.getPreferredSize();
        int maxWidth = size.width;
        int maxHeight = size.height;
        comp.removeAll();
        if (this.selectionMode == Mode.AGGREGATE) {
            if (this.selectAll == null) {
                this.selectAll = new JButton("Select All");
                this.selectAll.addActionListener(this);
                this.selectNone = new JButton("Select None");
                this.selectNone.addActionListener(this);
            }
            comp.add(this.selectAll);
            comp.add(this.selectNone);
        }
        int i = 0;
        this._thumbList.clear();
        for (ThumbnailProvider prov : this._providerList) {
            Component img = prov.getThumbnailComponent(maxWidth, maxHeight);
            CollectionPaneThumbnail mouse = new CollectionPaneThumbnail(prov, img, this.selected.contains(i), this);
            mouse.setToolTipText(prov.getThumbnailComponentTooltip());
            this._thumbList.add(mouse);
            comp.add(mouse);
            ++i;
        }
    }

    @Override
    protected void updateComponentCustom(JComponent comp) {
    }

    @Override
    protected void commitComponentCustom(JComponent comp) {
    }

    public void addPreviousButton(AbstractButton prev) {
        if (prev != null) {
            this.prevButtons.add(prev);
            prev.addActionListener(this);
        }
    }

    public void addNextButton(AbstractButton next) {
        if (next != null) {
            this.nextButtons.add(next);
            next.addActionListener(this);
        }
    }

    public void removePreviousButton(AbstractButton prev) {
        if (prev != null) {
            this.prevButtons.remove(prev);
            prev.removeActionListener(this);
        }
    }

    public void removeNextButton(AbstractButton next) {
        if (next != null) {
            this.nextButtons.remove(next);
            next.removeActionListener(this);
        }
    }

    public void clearButtons() {
        this.prevButtons.clear();
        this.nextButtons.clear();
    }

    public void updateButtons() {
        int index = this.getSelectedIndex();
        for (AbstractButton prev : this.prevButtons) {
            prev.setEnabled(index > 0);
        }
        for (AbstractButton next : this.nextButtons) {
            next.setEnabled(index < this._providerList.size() - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.prevButtons.contains(e.getSource())) {
            this.selectPrevious();
        } else if (this.nextButtons.contains(e.getSource())) {
            this.selectNext();
        } else if (this.selectAll == e.getSource()) {
            this.selectAll();
        } else if (this.selectNone == e.getSource()) {
            this.selectNone();
        }
    }

    private int getClosestPreviousSelected(int index) {
        if (index < 0 || this.selected.size() <= 0) {
            return -1;
        }
        Object[] ints = this.selected.toArray(new Integer[this.selected.size()]);
        Arrays.sort(ints);
        int closest = -1;
        for (int i = 0; i < ints.length && (Integer)ints[i] < index; ++i) {
            closest = (Integer)ints[i];
        }
        return closest;
    }

    public static enum Mode {
        NONE,
        SINGLE,
        MULTIPLE,
        AGGREGATE,
        SMART;

    }
}

