/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.w3c.dom.Node;

public abstract class ButtonBase<U extends XmlUnit, C extends AbstractButton>
extends XmlJComponentUnit<U, C>
implements ActionListener {
    @XmlUnit.Serial
    String dialogId;
    @XmlUnit.Serial
    boolean showDialog = true;
    @XmlUnit.Serial
    public String icon;
    @XmlUnit.Serial
    public String iconGroup;
    @XmlUnit.Serial
    Key alt;
    @XmlUnit.Serial
    Key key;
    @XmlUnit.Serial
    String keyMod;
    @XmlUnit.Serial
    String bind;
    @XmlUnit.Serial
    String call;
    String keyLabel;
    int keyModCode;
    Showable _dialog;

    public Showable getDialog() {
        return this._dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component comp;
        XmlUnit unit;
        if (this._dialog != null && this.showDialog && !this._dialog.show()) {
            return;
        }
        if (this.hasListener()) {
            if (this.call != null) {
                EnumListener lis = this.getListener();
                Class<?> c = lis.getClass();
                try {
                    Method m = c.getMethod(this.call, ButtonBase.class);
                    m.invoke((Object)lis, this);
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.SEVERE, null, ex);
                }
            } else {
                this.notifyListener(this.getComponent());
            }
        }
        if (this.bind != null && (unit = SwingFast.findUnit(this.bind)) != null && (comp = ((ButtonBase)unit).getComponent()) != null) {
            ((AbstractButton)comp).doClick();
        }
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
        super.xmlPostLoadComponentCallback(unit, state);
        if (state == XmlUnit.State.STRUCTURE) {
            XmlUnit dialog;
            this._dialog = this.getFirstChildOfClass(Showable.class, this.dialogId);
            if (this._dialog != null && XmlUnit.class.isInstance(this._dialog) && "".equals((dialog = (XmlUnit)((Object)this._dialog)).getLabelToDisplay())) {
                dialog.setLabel(this.getLabelToDisplay());
            }
        }
    }

    protected abstract C createButtonComponent(String var1, Icon var2, String var3);

    @Override
    protected C createComponent() {
        if (this.key != null) {
            this.keyLabel = "";
            if (this.keyMod != null) {
                String[] tokens;
                this.keyModCode = 0;
                for (String token : tokens = this.keyMod.split("\\+")) {
                    try {
                        KeyModifier mod = KeyModifier.valueOf(token.toLowerCase());
                        this.keyModCode |= mod.val;
                    }
                    catch (Exception e) {
                        this.logWarnLine("Unknown key modifier " + token);
                    }
                }
            }
            if (this.keyModCode != 0) {
                this.keyLabel = this.keyLabel + KeyEvent.getKeyModifiersText(this.keyModCode) + "+";
            }
            this.keyLabel = this.keyLabel + KeyEvent.getKeyText(this.key.val);
            if (this.toolTipText != null) {
                this.toolTipText = this.toolTipText + "    \"" + this.keyLabel + "\"";
            }
        }
        ImageIcon ic = SwingFast.createIcon(this.icon, this.iconGroup);
        String text = this.label;
        if (text == null && ic == null) {
            text = this.getLabelToDisplay();
        }
        C button = this.createButtonComponent(text, ic, this.keyLabel);
        ((AbstractButton)button).addActionListener(this);
        if (this.alt != null) {
            ((AbstractButton)button).setMnemonic(this.alt.val);
        }
        if (this.key != null) {
            this.setAccelerator(button);
        }
        ((JComponent)button).getInputMap(0).put(KeyStroke.getKeyStroke(Key.ENTER.val, 0), "action");
        ((JComponent)button).getActionMap().put("action", new AbstractAction(this.getLabelToDisplay()){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractButton)ButtonBase.this.getComponent()).doClick();
            }
        });
        return button;
    }

    protected void setAccelerator(C button) {
        ((JComponent)button).getInputMap(2).put(KeyStroke.getKeyStroke(this.key.val, this.keyModCode), "action");
    }

    public AbstractButton getButton() {
        return (AbstractButton)this.getComponent();
    }

    static enum KeyModifier {
        shift(1, "Shift"),
        alt(8, "Alt"),
        meta(4, "\u2318"),
        ctrl(2, "Ctrl"),
        cmd(Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), "Cmd"),
        altGr(32, "AltGr");

        public final int val;
        String symbol;

        private KeyModifier(int val, String symbol) {
            this.val = val;
            this.symbol = symbol;
        }
    }

    static enum Key {
        ENTER(10, "Enter"),
        BACK_SPACE(8, "Backspace"),
        TAB(9, "Tab"),
        CANCEL(3, null),
        CLEAR(12, null),
        SHIFT(16, "Shift"),
        CONTROL(17, "Ctrl"),
        ALT(18, "Alt"),
        PAUSE(19, "Pause"),
        CAPS_LOCK(20, "CapsLock"),
        ESCAPE(27, "Esc"),
        SPACE(32, "Space"),
        PAGE_UP(33, "PgUp"),
        PAGE_DOWN(34, "PgDn"),
        END(35, "End"),
        HOME(36, "Home"),
        LEFT(37, null),
        UP(38, null),
        RIGHT(39, null),
        DOWN(40, null),
        COMMA(44, ","),
        MINUS(45, "-"),
        PERIOD(46, "."),
        SLASH(47, "/"),
        N0(48, "0"),
        N1(49, "1"),
        N2(50, "2"),
        N3(51, "3"),
        N4(52, "4"),
        N5(53, "5"),
        N6(54, "6"),
        N7(55, "7"),
        N8(56, "8"),
        N9(57, "9"),
        SEMICOLON(59, ";"),
        EQUALS(61, "="),
        A(65, "a"),
        B(66, "b"),
        C(67, "c"),
        D(68, "d"),
        E(69, "e"),
        F(70, "f"),
        G(71, "g"),
        H(72, "h"),
        I(73, "i"),
        J(74, "j"),
        K(75, "k"),
        L(76, "l"),
        M(77, "m"),
        N(78, "n"),
        O(79, "o"),
        P(80, "p"),
        Q(81, "q"),
        R(82, "r"),
        S(83, "s"),
        T(84, "t"),
        U(85, "u"),
        V(86, "v"),
        W(87, "w"),
        X(88, "x"),
        Y(89, "y"),
        Z(90, "z"),
        OPEN_BRACKET(91, "["),
        BACK_SLASH(92, "\\"),
        CLOSE_BRACKET(93, "]"),
        NUMPAD0(96, "0"),
        NUMPAD1(97, "1"),
        NUMPAD2(98, "2"),
        NUMPAD3(99, "3"),
        NUMPAD4(100, "4"),
        NUMPAD5(101, "5"),
        NUMPAD6(102, "6"),
        NUMPAD7(103, "7"),
        NUMPAD8(104, "8"),
        NUMPAD9(105, "9"),
        MULTIPLY(106, "*"),
        ADD(107, "+"),
        SEPARATER(108, null),
        SEPARATOR(108, null),
        SUBTRACT(109, null),
        DECIMAL(110, null),
        DIVIDE(111, "/"),
        DELETE(127, null),
        NUM_LOCK(144, "NumLock"),
        SCROLL_LOCK(145, "ScrollLock"),
        F1(112, "F1"),
        F2(113, "F2"),
        F3(114, "F3"),
        F4(115, "F4"),
        F5(116, "F5"),
        F6(117, "F6"),
        F7(118, "F7"),
        F8(119, "F8"),
        F9(120, "F9"),
        F10(121, "F10"),
        F11(122, "F11"),
        F12(123, "F12"),
        F13(61440, "F13"),
        F14(61441, "F14"),
        F15(61442, "F15"),
        F16(61443, "F16"),
        F17(61444, "F17"),
        F18(61445, "F18"),
        F19(61446, "F19"),
        F20(61447, "F20"),
        F21(61448, "F21"),
        F22(61449, "F22"),
        F23(61450, "F23"),
        F24(61451, "F24"),
        PRINTSCREEN(154, null),
        INSERT(155, "Ins"),
        HELP(156, null),
        META(157, null),
        BACK_QUOTE(192, "`"),
        QUOTE(222, "'"),
        KP_UP(224, null),
        KP_DOWN(225, null),
        KP_LEFT(226, null),
        KP_RIGHT(227, null),
        DEAD_GRAVE(128, null),
        DEAD_ACUTE(129, null),
        DEAD_CIRCUMFLEX(130, null),
        DEAD_TILDE(131, null),
        DEAD_MACRON(132, null),
        DEAD_BREVE(133, null),
        DEAD_ABOVEDOT(134, null),
        DEAD_DIAERESIS(135, null),
        DEAD_ABOVERING(136, null),
        DEAD_DOUBLEACUTE(137, null),
        DEAD_CARON(138, null),
        DEAD_CEDILLA(139, null),
        DEAD_OGONEK(140, null),
        DEAD_IOTA(141, null),
        DEAD_VOICED_SOUND(142, null),
        DEAD_SEMIVOICED_SOUND(143, null),
        AMPERSAND(150, "&"),
        ASTERISK(151, "*"),
        QUOTEDBL(152, "\""),
        LESS(153, "<"),
        GREATER(160, ">"),
        BRACELEFT(161, "{"),
        BRACERIGHT(162, "}"),
        AT(512, "@"),
        COLON(513, ":"),
        CIRCUMFLEX(514, "^"),
        DOLLAR(515, "$"),
        EURO_SIGN(516, null),
        EXCLAMATION_MARK(517, "!"),
        INVERTED_EXCLAMATION_MARK(518, null),
        LEFT_PARENTHESIS(519, "("),
        NUMBER_SIGN(520, "#"),
        PLUS(521, "+"),
        RIGHT_PARENTHESIS(522, ")"),
        UNDERSCORE(523, "_"),
        WINDOWS(524, null),
        CONTEXT_MENU(525, null),
        FINAL(24, null),
        CONVERT(28, null),
        NONCONVERT(29, null),
        ACCEPT(30, null),
        MODECHANGE(31, null),
        KANA(21, null),
        KANJI(25, null),
        ALPHANUMERIC(240, null),
        KATAKANA(241, null),
        HIRAGANA(242, null),
        FULL_WIDTH(243, null),
        HALF_WIDTH(244, null),
        ROMAN_CHARACTERS(245, null),
        ALL_CANDIDATES(256, null),
        PREVIOUS_CANDIDATE(257, null),
        CODE_INPUT(258, null),
        JAPANESE_KATAKANA(259, null),
        JAPANESE_HIRAGANA(260, null),
        JAPANESE_ROMAN(261, null),
        KANA_LOCK(262, null),
        INPUT_METHOD_ON_OFF(263, null),
        CUT(65489, null),
        COPY(65485, null),
        PASTE(65487, null),
        UNDO(65483, null),
        AGAIN(65481, null),
        FIND(65488, null),
        PROPS(65482, null),
        STOP(65480, null),
        COMPOSE(65312, null),
        ALT_GRAPH(65406, "AltGr"),
        BEGIN(65368, null);

        int val;
        String symbol;

        private Key(int val, String symbol) {
            this.val = val;
            this.symbol = symbol;
        }
    }
}

