/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.SwingFast;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public class BoxPanel
extends JPanel {
    Common.Axis _axis;
    Common.Align _align;
    boolean _gap;
    Dimension _gapDimension;
    public static final int GAP_SIZE = 7;

    public BoxPanel() {
        this(Common.Axis.X, Common.Align.CENTER, false);
    }

    public BoxPanel(Common.Axis axis, boolean gap) {
        this(axis, Common.Align.CENTER, gap);
    }

    public BoxPanel(Common.Axis axis, Common.Align align, boolean gap) {
        this(axis, align, gap, 7);
    }

    public BoxPanel(Common.Axis axis, Common.Align align, boolean gap, int gapSize) {
        this._axis = axis;
        this._align = align;
        this._gap = gap;
        if (gapSize < 0) {
            gapSize = 7;
        }
        this._gapDimension = new Dimension(gapSize, gapSize);
        BoxLayout layout = new BoxLayout(this, axis.ordinal());
        this.setLayout(layout);
        if (this._gap) {
            this.setBorder(BorderFactory.createEmptyBorder(gapSize, gapSize, gapSize, gapSize));
        }
        if (SwingFast.isDebugOn()) {
            this.setBorderLine(Color.RED);
        }
    }

    public void setBorderTitle(String title) {
        CompoundBorder compound = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), this.getBorder());
        this.setBorder(compound);
    }

    public void setBorderLine(Color color) {
        CompoundBorder compound = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), this.getBorder());
        this.setBorder(compound);
    }

    @Override
    public Component add(Component comp) {
        if (this.getComponents() != null && this.getComponents().length > 0 && this._gap) {
            this.addRigidArea(this._gapDimension);
        }
        if (JComponent.class.isInstance(comp)) {
            JComponent comp2 = (JComponent)comp;
            float alignX = 0.5f;
            float alignY = 0.5f;
            if (this._align == Common.Align.LEADING) {
                if (this._axis == Common.Axis.X) {
                    alignY = 0.0f;
                } else {
                    alignX = 0.0f;
                }
            } else if (this._align == Common.Align.TRAILING) {
                if (this._axis == Common.Axis.X) {
                    alignY = 1.0f;
                } else {
                    alignX = 1.0f;
                }
            }
            comp2.setAlignmentX(alignX);
            comp2.setAlignmentY(alignY);
        }
        super.add(comp);
        return comp;
    }

    public Component addXGlue() {
        return super.add(Box.createHorizontalGlue());
    }

    public Component addYGlue() {
        return super.add(Box.createVerticalGlue());
    }

    public Component addGlue() {
        return super.add(Box.createGlue());
    }

    public Component addFiller(Dimension min, Dimension pref, Dimension max) {
        return super.add(new Box.Filler(min, pref, max));
    }

    public Component addRigidArea(Dimension d) {
        return super.add(Box.createRigidArea(d));
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }
}

