/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Frame;
import com.edgytech.swingfast.MacApplication;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;

public abstract class Application
extends XmlUnit<XmlUnit>
implements WindowListener {
    @XmlUnit.Serial
    String windowId;
    private Frame mainWindow;
    protected static OSType detectedOS;

    public Application(boolean systemLookAndFeel) {
        SwingFast.configure(systemLookAndFeel);
        SwingFast.setApplication(this);
    }

    public Frame getMainWindow() {
        return this.mainWindow;
    }

    public void setMainWindow(Frame mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    protected void xmlPostLoadCallback(Node unit, XmlUnit.State state) {
        if (state == XmlUnit.State.STRUCTURE) {
            this.mainWindow = this.getFirstChildOfClass(Frame.class, this.windowId);
            if (this.mainWindow != null && "".equals(this.mainWindow.getLabelToDisplay())) {
                this.mainWindow.setLabel(this.getLabelToDisplay());
            }
        }
        super.xmlPostLoadCallback(unit, state);
    }

    public void launch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.initialize();
                Application.this.start(true);
                ((JFrame)Application.this.mainWindow.getComponent()).addWindowListener(Application.this);
                Application.this.mainWindow.show();
                if (Application.getOperatingSystemType().equals((Object)OSType.MacOS)) {
                    MacApplication macApplication = new MacApplication(Application.this);
                }
            }
        });
    }

    public abstract void initialize();

    public abstract void wrapUp();

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.stop(true);
        this.wrapUp();
        List<Window> windows = SwingFast.getTopLevelWindows();
        for (Window window : windows) {
            window.dispose();
        }
        SwingFast.stopThreadPool();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static OSType getOperatingSystemType() {
        if (detectedOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase();
            detectedOS = OS.indexOf("win") >= 0 ? OSType.Windows : (OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0 ? OSType.MacOS : (OS.indexOf("nux") >= 0 ? OSType.Linux : OSType.Other));
        }
        return detectedOS;
    }

    public void handleMacQuit() {
        this.wrapUp();
    }

    public void handleMacAbout() {
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }
}

