/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class AppUtils {
    private AppUtils() {
    }

    public static Enum matchEnum(Enum[] m_enms, String name) {
        if (name == null || m_enms == null) {
            return null;
        }
        for (Enum enm : m_enms) {
            if (!name.equals(enm.name())) continue;
            return enm;
        }
        return null;
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String convertIdToLabel(String id) {
        if (id == null) {
            return null;
        }
        String str = AppUtils.capitalize(id);
        if (str.length() <= 1) {
            return str;
        }
        int wstart = 0;
        String newStr = "";
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('A' > c || c > 'Z') continue;
            newStr = newStr + str.substring(wstart, i);
            newStr = newStr + " ";
            wstart = i;
        }
        newStr = newStr + str.substring(wstart);
        return newStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

