import requests
from bs4 import BeautifulSoup


# fmt = http://www.ndbc.noaa.gov/glider_graphs.php?file=T_SOVD83_C_KWNB_20140707103444_01518.txt&glider_id=01518&type=historical
URL = 'http://www.ndbc.noaa.gov/station_history.php?station=01518'
URL_TEMPLATE = 'http://www.ndbc.noaa.gov/glider_graphs.php?file=T_SOVD83_C_KWNB_{}_01518.txt&glider_id=01518&type=historical'

res = requests.get(URL).text

soup = BeautifulSoup(res, 'html.parser')

select = soup.select('select')[0]

urls = []

for option in select.select('option'):
    urls.append(URL_TEMPLATE.format(option['value']))

print('urls are')
print(urls)

with open('buoy.txt', 'wb') as f:
    for url in urls:
        f.write(url + '\n')
