/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.sharedMemory;

import com.remco.software.ncrunch.sharedMemory.Kernel32;
import com.remco.software.ncrunch.sharedMemory.Win32API;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/remco/software/ncrunch/sharedMemory/SharedMemory;", "", "name", "", "size", "", "<init>", "(Ljava/lang/String;I)V", "hMapFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "pBuffer", "Lcom/sun/jna/Pointer;", "readData", "", "offset", "", "byteBuffer", "readDataIntArray", "", "intBuffer", "readInt", "writeInt", "", "intToWrite", "close", "ncrunchforrider"})
public final class SharedMemory {
    @Nullable
    private WinNT.HANDLE hMapFile;
    @Nullable
    private Pointer pBuffer;

    public SharedMemory(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.hMapFile = Win32API.INSTANCE.getInstance().CreateFileMapping(new WinNT.HANDLE(Pointer.NULL), null, new WinDef.DWORD(Kernel32.Companion.getPAGE_READWRITE()), new WinDef.DWORD(0L), new WinDef.DWORD((long)size), name);
        int fileMapAllocationError = Win32API.INSTANCE.getInstance().GetLastError();
        if (Intrinsics.areEqual((Object)this.hMapFile, (Object)new WinNT.HANDLE(Pointer.createConstant((int)-1))) && fileMapAllocationError != 0) {
            throw new Exception("Failed to create file mapping. Error code: " + fileMapAllocationError);
        }
        if (Intrinsics.areEqual((Object)this.hMapFile, (Object)new WinNT.HANDLE(Pointer.createConstant((int)-1)))) {
            this.hMapFile = Win32API.INSTANCE.getInstance().OpenFileMapping(Kernel32.Companion.getFILE_MAP_ALL_ACCESS(), false, name);
            if (Win32API.INSTANCE.getInstance().GetLastError() != 0) {
                throw new Exception("Failed to open file mapping. Error code: " + Win32API.INSTANCE.getInstance().GetLastError());
            }
        }
        Kernel32 kernel32 = Win32API.INSTANCE.getInstance();
        WinNT.HANDLE hANDLE = this.hMapFile;
        Intrinsics.checkNotNull((Object)hANDLE);
        this.pBuffer = kernel32.MapViewOfFile(hANDLE, Kernel32.Companion.getFILE_MAP_ALL_ACCESS(), new WinDef.DWORD(0L), new WinDef.DWORD(0L), new WinDef.DWORD((long)size));
    }

    @NotNull
    public final byte[] readData(int size, long offset, @NotNull byte[] byteBuffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            Pointer pointer = this.pBuffer;
            if (pointer == null) break block0;
            pointer.read(offset, byteBuffer, 0, size);
        }
        return byteBuffer;
    }

    @NotNull
    public final int[] readDataIntArray(int size, long offset, @NotNull int[] intBuffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)intBuffer, (String)"intBuffer");
            Pointer pointer = this.pBuffer;
            if (pointer == null) break block0;
            pointer.read(offset, intBuffer, 0, size / 4);
        }
        return intBuffer;
    }

    public final int readInt(long offset) {
        Pointer pointer = this.pBuffer;
        return pointer != null ? pointer.getInt(offset) : 0;
    }

    public final void writeInt(int intToWrite, long offset) {
        block0: {
            Pointer pointer = this.pBuffer;
            if (pointer == null) break block0;
            pointer.setInt(offset, intToWrite);
        }
    }

    public final void close() {
        if (this.pBuffer != null) {
            Kernel32 kernel32 = Win32API.INSTANCE.getInstance();
            Pointer pointer = this.pBuffer;
            Intrinsics.checkNotNull((Object)pointer);
            kernel32.UnmapViewOfFile(pointer);
            this.pBuffer = null;
        }
        if (this.hMapFile != null) {
            Kernel32 kernel32 = Win32API.INSTANCE.getInstance();
            WinNT.HANDLE hANDLE = this.hMapFile;
            Intrinsics.checkNotNull((Object)hANDLE);
            kernel32.CloseHandle(hANDLE);
            this.hMapFile = null;
        }
    }
}

