/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor.rdi;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.remco.software.ncrunch.editor.EditorReference;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/remco/software/ncrunch/editor/rdi/RdiHighlightRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "editorReference", "Lcom/remco/software/ncrunch/editor/EditorReference;", "<init>", "(Lcom/remco/software/ncrunch/editor/EditorReference;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "ncrunchforrider"})
public final class RdiHighlightRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final EditorReference editorReference;

    public RdiHighlightRenderer(@NotNull EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        this.editorReference = editorReference;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this.editorReference.getRdiOverlayActive() || this.editorReference.getRdiOverlayImage() == null) break block6;
            Graphics graphics = g.create();
            Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
            double reverseScalingFactor = 1.0 / this.editorReference.getScaleFactor();
            Graphics2D graphics2D2 = graphics2D;
            if (graphics2D2 != null) {
                graphics2D2.scale(reverseScalingFactor, reverseScalingFactor);
            }
            if (this.editorReference.getRdiSplitRendering()) {
                Graphics2D graphics2D3 = graphics2D;
                if (graphics2D3 != null) {
                    graphics2D3.drawImage((Image)this.editorReference.getRdiOverlayImage(), 0, (int)this.editorReference.getRdiSplitRenderingStart(), null);
                }
            } else {
                Graphics2D graphics2D4 = graphics2D;
                if (graphics2D4 != null) {
                    graphics2D4.drawImage((Image)this.editorReference.getRdiOverlayImage(), 0, 0, null);
                }
            }
            Graphics2D graphics2D5 = graphics2D;
            if (graphics2D5 != null) {
                graphics2D5.dispose();
            }
        }
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.AFTER_TEXT;
    }
}

