/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video;

import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.enums.RecordingMode;
import com.automation.remarks.video.enums.VideoSaveMode;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecordingUtils {
    private static final Logger logger = Logger.getLogger(RecordingUtils.class);

    private RecordingUtils() {
    }

    public static String doVideoProcessing(boolean successfulTest, File video) {
        String filePath = RecordingUtils.formatVideoFilePath(video);
        if (!successfulTest || RecordingUtils.isSaveAllModeEnable()) {
            logger.info((Object)("Video recording: " + filePath));
            return filePath;
        }
        if (video != null && video.isFile()) {
            if (!video.delete()) {
                logger.info((Object)"Video didn't deleted");
                return "Video didn't deleted";
            }
            logger.info((Object)"No video on success test");
        }
        return "";
    }

    private static boolean isSaveAllModeEnable() {
        return VideoRecorder.conf().saveMode().equals((Object)VideoSaveMode.ALL);
    }

    public static boolean videoEnabled(Video video) {
        return VideoRecorder.conf().videoEnabled() != false && (RecordingUtils.isRecordingAllModeEnable() || video != null);
    }

    private static boolean isRecordingAllModeEnable() {
        return VideoRecorder.conf().mode().equals((Object)RecordingMode.ALL);
    }

    public static String getVideoFileName(Video annotation, String methodName) {
        if (RecordingUtils.useNameFromVideoAnnotation(annotation) && VideoRecorder.conf().fileName() != null) {
            return VideoRecorder.conf().fileName();
        }
        if (annotation == null) {
            return methodName;
        }
        String name = annotation.name();
        return name.length() > 1 ? name : methodName;
    }

    private static boolean useNameFromVideoAnnotation(Video annotation) {
        return annotation == null || annotation.name().isEmpty();
    }

    private static String formatVideoFilePath(File video) {
        if (video == null) {
            return "";
        }
        String jenkinsReportsUrl = RecordingUtils.getJenkinsReportsUrl();
        if (!StringUtils.isBlank((CharSequence)jenkinsReportsUrl)) {
            return jenkinsReportsUrl + video.getName();
        }
        return video.getAbsolutePath();
    }

    private static String getJenkinsReportsUrl() {
        String jenkinsUrl = System.getProperty("jenkinsUrl");
        if (!StringUtils.isBlank((CharSequence)jenkinsUrl)) {
            return jenkinsUrl;
        }
        logger.info((Object)"No jenkinsUrl variable found.");
        return "";
    }
}

