/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.toolwindows;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.wormhole.SystemEnvironmentProvider;
import com.jetbrains.wormhole.awt.Wormhole;
import com.jetbrains.wormhole.events.WormholeEvent;
import com.jetbrains.wormhole.events.WormholeEventArgument;
import com.jetbrains.wormhole.interop.PlatformProvider;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.windows.WindowsPlatformProvider;
import com.jetbrains.wormhole.interop.windows.WindowsWindowId;
import com.remco.software.ncrunch.ComponentScalingMonitor;
import com.remco.software.ncrunch.model.BindToolWindow;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.model.ToolWindowFocus;
import com.remco.software.ncrunch.toolwindows.BaseToolWindowFactory;
import com.remco.software.ncrunch.toolwindows.ToolWindowStateChangeListener;
import com.remco.software.ncrunch.toolwindows.WindowsEnvironmentProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/remco/software/ncrunch/toolwindows/BaseToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "windowName", "", "<init>", "(Ljava/lang/String;)V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "previousToolWindowType", "Lcom/intellij/openapi/wm/ToolWindowType;", "releaseAndEmbedToolWindow", "wormholeWindow", "Lcom/remco/software/ncrunch/toolwindows/BaseToolWindowFactory$WormholeWindow;", "WormholeWindow", "ncrunchforrider"})
public class BaseToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final String windowName;
    @Nullable
    private ToolWindowType previousToolWindowType;

    public BaseToolWindowFactory(@NotNull String windowName) {
        Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
        this.windowName = windowName;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        WormholeWindow wormholeWindow = new WormholeWindow(project, this.windowName);
        toolWindow.getContentManager().addContent(ContentFactory.getInstance().createContent((JComponent)wormholeWindow, "", true));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowStateChangeListener(toolWindow, wormholeWindow, (Function4<? super WormholeWindow, ? super Boolean, ? super Boolean, ? super ToolWindowType, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> BaseToolWindowFactory.createToolWindowContent$lambda$0(this, arg_0, arg_1, arg_2, arg_3))));
    }

    private final void releaseAndEmbedToolWindow(WormholeWindow wormholeWindow) {
        SwingUtilities.invokeLater(() -> BaseToolWindowFactory.releaseAndEmbedToolWindow$lambda$2(wormholeWindow));
    }

    private static final Unit createToolWindowContent$lambda$0(BaseToolWindowFactory this$0, WormholeWindow wormholeWindow, boolean visibilityChanged, boolean visible, ToolWindowType type) {
        boolean isFloatingNow;
        boolean bl = isFloatingNow = type == ToolWindowType.FLOATING || type == ToolWindowType.WINDOWED;
        if (isFloatingNow != wormholeWindow.isToolWindowPanelFloating() || this$0.previousToolWindowType != null && this$0.previousToolWindowType != type) {
            wormholeWindow.setToolWindowPanelFloating(isFloatingNow);
            this$0.releaseAndEmbedToolWindow(wormholeWindow);
            this$0.previousToolWindowType = type;
        }
        if (!visible && isFloatingNow) {
            wormholeWindow.setToolWindowPanelFloating(false);
        }
        return Unit.INSTANCE;
    }

    private static final void releaseAndEmbedToolWindow$lambda$2(WormholeWindow $wormholeWindow) {
        block1: {
            WindowsWindowId windowsWindowId = $wormholeWindow.getWinformsToolwindowHandle();
            if (windowsWindowId == null) break block1;
            WindowsWindowId it = windowsWindowId;
            boolean bl = false;
            $wormholeWindow.getWormhole().release();
            if ($wormholeWindow.getWormhole().canEmbedWindow((WindowId)it)) {
                $wormholeWindow.getWormhole().embed((WindowId)it);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u001d\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010#\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bH\u0002J\b\u0010'\u001a\u00020%H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lcom/remco/software/ncrunch/toolwindows/BaseToolWindowFactory$WormholeWindow;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "windowName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "loadingLabel", "Ljavax/swing/JLabel;", "winformsToolwindowHandle", "Lcom/jetbrains/wormhole/interop/windows/WindowsWindowId;", "getWinformsToolwindowHandle", "()Lcom/jetbrains/wormhole/interop/windows/WindowsWindowId;", "setWinformsToolwindowHandle", "(Lcom/jetbrains/wormhole/interop/windows/WindowsWindowId;)V", "hostPanelFocussedSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getHostPanelFocussedSignal", "()Lcom/jetbrains/rd/util/reactive/Signal;", "isToolWindowPanelFloating", "()Z", "setToolWindowPanelFloating", "(Z)V", "ideWindowHandle", "Lcom/jetbrains/rd/util/reactive/Property;", "", "focusListener", "com/remco/software/ncrunch/toolwindows/BaseToolWindowFactory$WormholeWindow$focusListener$1", "Lcom/remco/software/ncrunch/toolwindows/BaseToolWindowFactory$WormholeWindow$focusListener$1;", "wormhole", "Lcom/jetbrains/wormhole/awt/Wormhole;", "getWormhole", "()Lcom/jetbrains/wormhole/awt/Wormhole;", "createWormholeComponent", "addAmdEmbedWormhole", "", "windowHandleOfToolWindow", "setWormholeSize", "ncrunchforrider"})
    public static final class WormholeWindow
    extends JPanel {
        @NotNull
        private final JLabel loadingLabel;
        @Nullable
        private WindowsWindowId winformsToolwindowHandle;
        @NotNull
        private final Signal<Boolean> hostPanelFocussedSignal;
        private boolean isToolWindowPanelFloating;
        @NotNull
        private final Property<Long> ideWindowHandle;
        @NotNull
        private final focusListener.1 focusListener;
        @NotNull
        private final Wormhole wormhole;

        public WormholeWindow(@NotNull Project project, @NotNull String windowName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            super(new BorderLayout());
            this.loadingLabel = new JLabel("NCrunch is loading");
            this.hostPanelFocussedSignal = new Signal();
            this.ideWindowHandle = new Property((Object)0L);
            this.focusListener = new FocusListener(this){
                final /* synthetic */ WormholeWindow this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusLost(FocusEvent p0) {
                    this.this$0.getHostPanelFocussedSignal().fire((Object)false);
                }

                public void focusGained(FocusEvent p0) {
                    this.this$0.getHostPanelFocussedSignal().fire((Object)true);
                }
            };
            this.wormhole = this.createWormholeComponent();
            this.setFocusable(true);
            this.addFocusListener(this.focusListener);
            ((ComponentScalingMonitor)project.getService(ComponentScalingMonitor.class)).addComponentToCheck(this, windowName, (Function0<Unit>)((Function0)() -> WormholeWindow._init_$lambda$2(this)));
            this.hostPanelFocussedSignal.advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> WormholeWindow._init_$lambda$3(this, project, windowName, arg_0));
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getToolWindowFocussedFromNCrunch().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> WormholeWindow._init_$lambda$4(windowName, this, arg_0));
            this.loadingLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)this.loadingLabel, "North");
            Timer loadingAnimationTimer2 = new Timer(1000, new ActionListener(this){
                private int counter;
                final /* synthetic */ WormholeWindow this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> loadingAnimationTimer.1.actionPerformed$lambda$0(this, this.this$0));
                }

                private static final void actionPerformed$lambda$0(loadingAnimationTimer.1 this$0, WormholeWindow this$1) {
                    this$0.counter = this$0.counter % 4 + 1;
                    WormholeWindow.access$getLoadingLabel$p(this$1).setText("NCrunch is loading" + StringsKt.repeat((CharSequence)".", (int)this$0.counter));
                }
            });
            loadingAnimationTimer2.start();
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getBindToolWindow().advise(Lifetime.Companion.getEternal(), arg_0 -> WormholeWindow._init_$lambda$5(windowName, loadingAnimationTimer2, this, arg_0));
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getToolWindowOpened().fire((Object)windowName);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.setWormholeSize();
                }
            });
        }

        @Nullable
        public final WindowsWindowId getWinformsToolwindowHandle() {
            return this.winformsToolwindowHandle;
        }

        public final void setWinformsToolwindowHandle(@Nullable WindowsWindowId windowsWindowId) {
            this.winformsToolwindowHandle = windowsWindowId;
        }

        @NotNull
        public final Signal<Boolean> getHostPanelFocussedSignal() {
            return this.hostPanelFocussedSignal;
        }

        public final boolean isToolWindowPanelFloating() {
            return this.isToolWindowPanelFloating;
        }

        public final void setToolWindowPanelFloating(boolean bl) {
            this.isToolWindowPanelFloating = bl;
        }

        @NotNull
        public final Wormhole getWormhole() {
            return this.wormhole;
        }

        private final Wormhole createWormholeComponent() {
            Wormhole wormhole;
            Wormhole it = wormhole = new Wormhole((PlatformProvider)new WindowsPlatformProvider((SystemEnvironmentProvider)new WindowsEnvironmentProvider(), null, 2, null), null, 2, null);
            boolean bl = false;
            it.addEventListener(WormholeEvent.Companion.getAttachedToRoot(), arg_0 -> WormholeWindow.createWormholeComponent$lambda$1$lambda$0(it, this, arg_0));
            return wormhole;
        }

        private final void addAmdEmbedWormhole(WindowsWindowId windowHandleOfToolWindow) {
            this.removeAll();
            this.setLayout(null);
            this.setWormholeSize();
            this.add((Component)this.wormhole);
            WindowsWindowId windowsWindowId = this.winformsToolwindowHandle = windowHandleOfToolWindow;
            Intrinsics.checkNotNull((Object)windowsWindowId);
            this.wormhole.embed((WindowId)windowsWindowId);
        }

        private final void setWormholeSize() {
            int wormholeWidth = this.getWidth();
            int wormholeHeight = this.getHeight();
            this.wormhole.setBounds(0, 0, wormholeWidth, wormholeHeight);
        }

        private static final Unit createWormholeComponent$lambda$1$lambda$0(Wormhole $it, WormholeWindow this$0, WormholeEventArgument.WindowId windowId) {
            Intrinsics.checkNotNullParameter((Object)windowId, (String)"<unused var>");
            Container container = this$0.getRootPane().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
            WindowId closestWindowHandle = $it.calculateClosestWindowsId((Component)container);
            if (!(closestWindowHandle instanceof WindowsWindowId)) {
                return Unit.INSTANCE;
            }
            this$0.ideWindowHandle.set((Object)((WindowsWindowId)closestWindowHandle).getPointer());
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2(WormholeWindow this$0) {
            this$0.setWormholeSize();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$3(WormholeWindow this$0, Project $project, String $windowName, boolean isFocused) {
            if (isFocused) {
                this$0.requestFocus();
            } else {
                NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)$project)).getToolWindowFocusChangeFromRider().fire((Object)new ToolWindowFocus($windowName, isFocused, ((Number)this$0.ideWindowHandle.getValue()).longValue(), this$0.isToolWindowPanelFloating));
            }
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$4(String $windowName, WormholeWindow this$0, String toolWindowFocus) {
            Intrinsics.checkNotNullParameter((Object)toolWindowFocus, (String)"toolWindowFocus");
            if (Intrinsics.areEqual((Object)toolWindowFocus, (Object)$windowName)) {
                this$0.requestFocus();
            }
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$5(String $windowName, Timer $loadingAnimationTimer, WormholeWindow this$0, BindToolWindow s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (Intrinsics.areEqual((Object)s.getWindowName(), (Object)$windowName)) {
                $loadingAnimationTimer.stop();
                this$0.addAmdEmbedWormhole(new WindowsWindowId((Number)s.getPointer()));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ JLabel access$getLoadingLabel$p(WormholeWindow $this) {
            return $this.loadingLabel;
        }
    }
}

