/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.remco.software.ncrunch.editor.CoverageMarkerIcon;
import com.remco.software.ncrunch.editor.coveragemarkerevent.AbstractCoverageMarkerMouseEvent;
import com.remco.software.ncrunch.editor.coveragemarkerevent.CoverageMarkerActionEvent;
import com.remco.software.ncrunch.editor.coveragemarkerevent.CoverageMarkerMouseEvent;
import com.remco.software.ncrunch.model.MarkerMouseEvent;
import com.remco.software.ncrunch.model.MarkerMouseEventPoint;
import com.remco.software.ncrunch.model.MarkerMouseLeaveEvent;
import com.remco.software.ncrunch.model.NCrunchForRiderModel;
import com.remco.software.ncrunch.win32.Win32PointerHelper;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/remco/software/ncrunch/editor/CoverageMarkerMouseEventHandler;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/actionSystem/AnAction;", "nCrunchForRiderModel", "Lcom/remco/software/ncrunch/model/NCrunchForRiderModel;", "<init>", "(Lcom/remco/software/ncrunch/model/NCrunchForRiderModel;)V", "getNCrunchForRiderModel", "()Lcom/remco/software/ncrunch/model/NCrunchForRiderModel;", "currentMarker", "Lcom/remco/software/ncrunch/editor/CoverageMarkerIcon;", "locationOnScreen", "Ljava/awt/Point;", "checkIfMarkerNeedsToStayOpen", "Ljava/awt/event/ActionListener;", "timer", "Ljavax/swing/Timer;", "handCursor", "Ljava/awt/Cursor;", "defaultCursor", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "sendMouseLeaveForCurrentMarker", "currentLinePath", "", "currentLineNumber", "", "beforeActionPerformed", "currentIcon", "afterActionPerformed", "actionPerformed", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nCoverageMarkerMouseEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageMarkerMouseEventHandler.kt\ncom/remco/software/ncrunch/editor/CoverageMarkerMouseEventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class CoverageMarkerMouseEventHandler
extends AnAction
implements EditorMouseMotionListener {
    @NotNull
    private final NCrunchForRiderModel nCrunchForRiderModel;
    @Nullable
    private CoverageMarkerIcon currentMarker;
    @Nullable
    private Point locationOnScreen;
    @NotNull
    private final ActionListener checkIfMarkerNeedsToStayOpen;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Cursor handCursor;
    @NotNull
    private final Cursor defaultCursor;
    @Nullable
    private CoverageMarkerIcon currentIcon;

    public CoverageMarkerMouseEventHandler(@NotNull NCrunchForRiderModel nCrunchForRiderModel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)nCrunchForRiderModel2), (String)"nCrunchForRiderModel");
        this.nCrunchForRiderModel = nCrunchForRiderModel2;
        this.checkIfMarkerNeedsToStayOpen = arg_0 -> CoverageMarkerMouseEventHandler.checkIfMarkerNeedsToStayOpen$lambda$0(this, arg_0);
        this.timer = new Timer(500, this.checkIfMarkerNeedsToStayOpen);
        this.timer.setRepeats(true);
        this.handCursor = new Cursor(12);
        this.defaultCursor = new Cursor(0);
    }

    @NotNull
    public final NCrunchForRiderModel getNCrunchForRiderModel() {
        return this.nCrunchForRiderModel;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CoverageMarkerMouseEvent event = new CoverageMarkerMouseEvent(e);
        if (event.isOnMarkerIcon() && event.getMarkerIsSet() && event.isOnGutter()) {
            boolean isOnDifferentMarker;
            e.getMouseEvent().getComponent().setCursor(this.handCursor);
            boolean bl = isOnDifferentMarker = event.getMarkerLine() != this.currentLineNumber();
            if (isOnDifferentMarker && this.currentMarker != null) {
                this.sendMouseLeaveForCurrentMarker();
            }
            this.currentMarker = event.getMarkerIcon();
            this.locationOnScreen = event.getMarkerLocationOnScreen();
            this.nCrunchForRiderModel.getSendMouseEvent().fire((Object)new MarkerMouseEvent(event.getMarkerPath(), event.getMarkerLine(), Win32PointerHelper.Companion.getMainWindowPointer(e.getMouseEvent().getComponent()), new MarkerMouseEventPoint(event.getMarkerLocationOnScreen().x, event.getMarkerLocationOnScreen().y), new MarkerMouseEventPoint(event.getLocationOnMarker().x, event.getLocationOnMarker().y), 0));
            this.timer.start();
        } else if (this.currentMarker != null) {
            e.getMouseEvent().getComponent().setCursor(this.defaultCursor);
            this.sendMouseLeaveForCurrentMarker();
        }
    }

    private final void sendMouseLeaveForCurrentMarker() {
        this.nCrunchForRiderModel.getSendMouseLeaveEvent().fire((Object)new MarkerMouseLeaveEvent(this.currentLinePath(), this.currentLineNumber()));
        this.currentMarker = null;
        this.timer.stop();
    }

    private final String currentLinePath() {
        CoverageMarkerIcon coverageMarkerIcon = this.currentMarker;
        Intrinsics.checkNotNull((Object)((Object)coverageMarkerIcon));
        return coverageMarkerIcon.getPath();
    }

    private final int currentLineNumber() {
        CoverageMarkerIcon coverageMarkerIcon = this.currentMarker;
        return coverageMarkerIcon != null ? coverageMarkerIcon.getLine() : -1;
    }

    public final void beforeActionPerformed(@NotNull CoverageMarkerIcon currentIcon) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentIcon), (String)"currentIcon");
        this.currentIcon = currentIcon;
    }

    private final void afterActionPerformed() {
        this.currentIcon = null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getInputEvent() instanceof MouseEvent && this.currentIcon != null) {
            Editor editor;
            Editor editor2 = editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 != null) {
                Object it = editor2;
                boolean bl = false;
                CoverageMarkerIcon coverageMarkerIcon = this.currentIcon;
                Intrinsics.checkNotNull((Object)((Object)coverageMarkerIcon));
                it = new CoverageMarkerActionEvent(e, (Editor)it, coverageMarkerIcon);
                boolean bl2 = false;
                IAsyncSignal<MarkerMouseEvent> iAsyncSignal = this.nCrunchForRiderModel.getSendMouseEvent();
                String string = ((CoverageMarkerActionEvent)it).getMarkerPath();
                int n = ((CoverageMarkerActionEvent)it).getMarkerLine();
                InputEvent inputEvent = e.getInputEvent();
                Intrinsics.checkNotNull((Object)inputEvent, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
                iAsyncSignal.fire((Object)new MarkerMouseEvent(string, n, Win32PointerHelper.Companion.getMainWindowPointer(((MouseEvent)inputEvent).getComponent()), new MarkerMouseEventPoint(((AbstractCoverageMarkerMouseEvent)it).getMarkerLocationOnScreen().x, ((AbstractCoverageMarkerMouseEvent)it).getMarkerLocationOnScreen().y), new MarkerMouseEventPoint(((AbstractCoverageMarkerMouseEvent)it).getLocationOnMarker().x, ((AbstractCoverageMarkerMouseEvent)it).getLocationOnMarker().y), ((AbstractCoverageMarkerMouseEvent)it).isLeftClick() ? 1 : 3));
            }
        }
        this.afterActionPerformed();
    }

    private static final void checkIfMarkerNeedsToStayOpen$lambda$0(CoverageMarkerMouseEventHandler this$0, ActionEvent it) {
        if (this$0.locationOnScreen != null && this$0.currentMarker != null) {
            Point currentMouseLocation = MouseInfo.getPointerInfo().getLocation();
            double distance = currentMouseLocation.distance(this$0.locationOnScreen);
            CoverageMarkerIcon coverageMarkerIcon = this$0.currentMarker;
            Intrinsics.checkNotNull((Object)((Object)coverageMarkerIcon));
            if (distance > coverageMarkerIcon.getLineHeight()) {
                this$0.sendMouseLeaveForCurrentMarker();
            }
        }
    }
}

