/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.model.ToolWindowScalingChanged;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\b\u0010\u0013\u001a\u00020\fH\u0016J&\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J.\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "entries", "", "Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentEntry;", "addComponentToCheck", "", "componentToMonitor", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "dispose", "handleComponentStateChanged", "component", "applyNewScaling", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "ComponentEntry", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nComponentScalingMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n13#2:195\n1#3:196\n1869#4,2:197\n295#4,2:199\n*S KotlinDebug\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n*L\n21#1:195\n100#1:197,2\n123#1:199,2\n*E\n"})
public final class ComponentScalingMonitor
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<ComponentEntry> entries;

    public ComponentScalingMonitor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentScalingMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.entries = new ArrayList();
    }

    public final void addComponentToCheck(@NotNull Component componentToMonitor, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange) {
        double d;
        GraphicsConfiguration initialGraphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)componentToMonitor, (String)"componentToMonitor");
        Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
        Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
        PropertyChangeListener graphicsConfigurationListener = arg_0 -> ComponentScalingMonitor.addComponentToCheck$lambda$0(this, componentToMonitor, windowName, postScalingChange, arg_0);
        ComponentListener sizeListener2 = new ComponentAdapter(this, componentToMonitor, windowName, postScalingChange){
            final /* synthetic */ ComponentScalingMonitor this$0;
            final /* synthetic */ Component $componentToMonitor;
            final /* synthetic */ String $windowName;
            final /* synthetic */ Function0<Unit> $postScalingChange;
            {
                this.this$0 = $receiver;
                this.$componentToMonitor = $componentToMonitor;
                this.$windowName = $windowName;
                this.$postScalingChange = $postScalingChange;
            }

            public void componentResized(ComponentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComponentScalingMonitor.access$handleComponentStateChanged(this.this$0, this.$componentToMonitor, this.$windowName, this.$postScalingChange);
            }
        };
        componentToMonitor.addPropertyChangeListener("graphicsConfiguration", graphicsConfigurationListener);
        componentToMonitor.addComponentListener(sizeListener2);
        GraphicsConfiguration graphicsConfiguration = initialGraphicsConfiguration = componentToMonitor.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            GraphicsConfiguration it = graphicsConfiguration;
            boolean bl = false;
            d = JBUIScale.pixScale((GraphicsConfiguration)it);
        } else {
            d = Double.NaN;
        }
        double initialScale = d;
        GraphicsConfiguration graphicsConfiguration2 = initialGraphicsConfiguration;
        GraphicsDevice initialDevice = graphicsConfiguration2 != null ? graphicsConfiguration2.getDevice() : null;
        int initialWidth = componentToMonitor.getWidth();
        int initialHeight = componentToMonitor.getHeight();
        ComponentEntry entry = new ComponentEntry(componentToMonitor, windowName, postScalingChange, initialDevice, initialScale, initialWidth, initialHeight, graphicsConfigurationListener, sizeListener2);
        ((Collection)this.entries).add(entry);
        if (initialGraphicsConfiguration != null && !Double.isNaN(initialScale)) {
            this.applyNewScaling(windowName, initialGraphicsConfiguration, componentToMonitor, postScalingChange);
            GraphicsDevice graphicsDevice = initialDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") initial scaling applied: " + initialScale + " on " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + " with size " + initialWidth + "x" + initialHeight);
        }
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object $i$a$-runCatching-ComponentScalingMonitor$dispose$1$32;
            ComponentEntry entry = (ComponentEntry)element$iv;
            boolean bl = false;
            try {
                boolean $i$a$-runCatching-ComponentScalingMonitor$dispose$1$32 = false;
                entry.getComponent().removePropertyChangeListener("graphicsConfiguration", entry.getGraphicsConfigurationListener());
                $i$a$-runCatching-ComponentScalingMonitor$dispose$1$32 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-ComponentScalingMonitor$dispose$1$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            try {
                boolean bl2 = false;
                entry.getComponent().removeComponentListener(entry.getSizeListener());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this.entries.clear();
    }

    private final void handleComponentStateChanged(Component component, String windowName, Function0<Unit> postScalingChange) {
        boolean heightChanged;
        Object v0;
        block11: {
            Iterable $this$firstOrNull$iv = this.entries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ComponentEntry it = (ComponentEntry)element$iv;
                boolean bl = false;
                if (!(it.getComponent() == component)) continue;
                v0 = element$iv;
                break block11;
            }
            v0 = null;
        }
        ComponentEntry componentEntry = v0;
        if (componentEntry == null) {
            return;
        }
        ComponentEntry entry = componentEntry;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration2 = graphicsConfiguration;
        GraphicsDevice currentDevice = graphicsConfiguration2.getDevice();
        double currentScale = JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration2);
        int currentWidth = component.getWidth();
        int currentHeight = component.getHeight();
        boolean deviceChanged = entry.getLastDevice() != currentDevice;
        boolean scaleChanged = !(currentScale == entry.getLastScale());
        boolean widthChanged = currentWidth != entry.getLastWidth();
        boolean bl = heightChanged = currentHeight != entry.getLastHeight();
        if (!(deviceChanged || scaleChanged || widthChanged || heightChanged)) {
            return;
        }
        entry.setLastDevice(currentDevice);
        entry.setLastScale(currentScale);
        entry.setLastWidth(currentWidth);
        entry.setLastHeight(currentHeight);
        this.applyNewScaling(windowName, graphicsConfiguration2, component, postScalingChange);
        if (deviceChanged && scaleChanged) {
            GraphicsDevice graphicsDevice = currentDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") moved to " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + " and scaling changed to " + currentScale + "; size " + currentWidth + "x" + currentHeight);
        } else if (deviceChanged) {
            GraphicsDevice graphicsDevice = currentDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") moved to " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + " (scale " + currentScale + ", size " + currentWidth + "x" + currentHeight + ")");
        } else if (scaleChanged) {
            this.logger.info("NCrunch tool window (" + windowName + ") scaling changed to " + currentScale + "; size " + currentWidth + "x" + currentHeight);
        } else if (widthChanged || heightChanged) {
            GraphicsDevice graphicsDevice = currentDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") size changed to " + currentWidth + "x" + currentHeight + " (scale " + currentScale + " on " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + ")");
        }
    }

    private final void applyNewScaling(String windowName, GraphicsConfiguration graphicsConfiguration, Component component, Function0<Unit> postScalingChange) {
        double scale = JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration);
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getScalingChangedForToolWindow().fire((Object)new ToolWindowScalingChanged(windowName, scale, component.getWidth(), component.getHeight()));
        postScalingChange.invoke();
    }

    private static final void addComponentToCheck$lambda$0(ComponentScalingMonitor this$0, Component $componentToMonitor, String $windowName, Function0 $postScalingChange, PropertyChangeEvent event) {
        if (!Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"graphicsConfiguration")) {
            return;
        }
        this$0.handleComponentStateChanged($componentToMonitor, $windowName, (Function0<Unit>)$postScalingChange);
    }

    public static final /* synthetic */ void access$handleComponentStateChanged(ComponentScalingMonitor $this, Component component, String windowName, Function0 postScalingChange) {
        $this.handleComponentStateChanged(component, windowName, (Function0<Unit>)postScalingChange);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u00102\u001a\u00020\fH\u00c6\u0003J\t\u00103\u001a\u00020\u000eH\u00c6\u0003J\t\u00104\u001a\u00020\u000eH\u00c6\u0003J\t\u00105\u001a\u00020\u0011H\u00c6\u0003J\t\u00106\u001a\u00020\u0013H\u00c6\u0003Jk\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010;\u001a\u00020\u000eH\u00d6\u0001J\t\u0010<\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006="}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentEntry;", "", "component", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "", "lastDevice", "Ljava/awt/GraphicsDevice;", "lastScale", "", "lastWidth", "", "lastHeight", "graphicsConfigurationListener", "Ljava/beans/PropertyChangeListener;", "sizeListener", "Ljava/awt/event/ComponentListener;", "<init>", "(Ljava/awt/Component;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/awt/GraphicsDevice;DIILjava/beans/PropertyChangeListener;Ljava/awt/event/ComponentListener;)V", "getComponent", "()Ljava/awt/Component;", "getWindowName", "()Ljava/lang/String;", "getPostScalingChange", "()Lkotlin/jvm/functions/Function0;", "getLastDevice", "()Ljava/awt/GraphicsDevice;", "setLastDevice", "(Ljava/awt/GraphicsDevice;)V", "getLastScale", "()D", "setLastScale", "(D)V", "getLastWidth", "()I", "setLastWidth", "(I)V", "getLastHeight", "setLastHeight", "getGraphicsConfigurationListener", "()Ljava/beans/PropertyChangeListener;", "getSizeListener", "()Ljava/awt/event/ComponentListener;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "ncrunchforrider"})
    private static final class ComponentEntry {
        @NotNull
        private final Component component;
        @NotNull
        private final String windowName;
        @NotNull
        private final Function0<Unit> postScalingChange;
        @Nullable
        private GraphicsDevice lastDevice;
        private double lastScale;
        private int lastWidth;
        private int lastHeight;
        @NotNull
        private final PropertyChangeListener graphicsConfigurationListener;
        @NotNull
        private final ComponentListener sizeListener;

        public ComponentEntry(@NotNull Component component, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice lastDevice, double lastScale, int lastWidth, int lastHeight, @NotNull PropertyChangeListener graphicsConfigurationListener, @NotNull ComponentListener sizeListener2) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            Intrinsics.checkNotNullParameter((Object)graphicsConfigurationListener, (String)"graphicsConfigurationListener");
            Intrinsics.checkNotNullParameter((Object)sizeListener2, (String)"sizeListener");
            this.component = component;
            this.windowName = windowName;
            this.postScalingChange = postScalingChange;
            this.lastDevice = lastDevice;
            this.lastScale = lastScale;
            this.lastWidth = lastWidth;
            this.lastHeight = lastHeight;
            this.graphicsConfigurationListener = graphicsConfigurationListener;
            this.sizeListener = sizeListener2;
        }

        public /* synthetic */ ComponentEntry(Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, int n, int n2, PropertyChangeListener propertyChangeListener, ComponentListener componentListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                graphicsDevice = null;
            }
            if ((n3 & 0x10) != 0) {
                d = Double.NaN;
            }
            if ((n3 & 0x20) != 0) {
                n = -1;
            }
            if ((n3 & 0x40) != 0) {
                n2 = -1;
            }
            this(component, string, (Function0<Unit>)function0, graphicsDevice, d, n, n2, propertyChangeListener, componentListener);
        }

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @NotNull
        public final String getWindowName() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> getPostScalingChange() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice getLastDevice() {
            return this.lastDevice;
        }

        public final void setLastDevice(@Nullable GraphicsDevice graphicsDevice) {
            this.lastDevice = graphicsDevice;
        }

        public final double getLastScale() {
            return this.lastScale;
        }

        public final void setLastScale(double d) {
            this.lastScale = d;
        }

        public final int getLastWidth() {
            return this.lastWidth;
        }

        public final void setLastWidth(int n) {
            this.lastWidth = n;
        }

        public final int getLastHeight() {
            return this.lastHeight;
        }

        public final void setLastHeight(int n) {
            this.lastHeight = n;
        }

        @NotNull
        public final PropertyChangeListener getGraphicsConfigurationListener() {
            return this.graphicsConfigurationListener;
        }

        @NotNull
        public final ComponentListener getSizeListener() {
            return this.sizeListener;
        }

        @NotNull
        public final Component component1() {
            return this.component;
        }

        @NotNull
        public final String component2() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> component3() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice component4() {
            return this.lastDevice;
        }

        public final double component5() {
            return this.lastScale;
        }

        public final int component6() {
            return this.lastWidth;
        }

        public final int component7() {
            return this.lastHeight;
        }

        @NotNull
        public final PropertyChangeListener component8() {
            return this.graphicsConfigurationListener;
        }

        @NotNull
        public final ComponentListener component9() {
            return this.sizeListener;
        }

        @NotNull
        public final ComponentEntry copy(@NotNull Component component, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice lastDevice, double lastScale, int lastWidth, int lastHeight, @NotNull PropertyChangeListener graphicsConfigurationListener, @NotNull ComponentListener sizeListener2) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            Intrinsics.checkNotNullParameter((Object)graphicsConfigurationListener, (String)"graphicsConfigurationListener");
            Intrinsics.checkNotNullParameter((Object)sizeListener2, (String)"sizeListener");
            return new ComponentEntry(component, windowName, postScalingChange, lastDevice, lastScale, lastWidth, lastHeight, graphicsConfigurationListener, sizeListener2);
        }

        public static /* synthetic */ ComponentEntry copy$default(ComponentEntry componentEntry, Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, int n, int n2, PropertyChangeListener propertyChangeListener, ComponentListener componentListener, int n3, Object object) {
            if ((n3 & 1) != 0) {
                component = componentEntry.component;
            }
            if ((n3 & 2) != 0) {
                string = componentEntry.windowName;
            }
            if ((n3 & 4) != 0) {
                function0 = componentEntry.postScalingChange;
            }
            if ((n3 & 8) != 0) {
                graphicsDevice = componentEntry.lastDevice;
            }
            if ((n3 & 0x10) != 0) {
                d = componentEntry.lastScale;
            }
            if ((n3 & 0x20) != 0) {
                n = componentEntry.lastWidth;
            }
            if ((n3 & 0x40) != 0) {
                n2 = componentEntry.lastHeight;
            }
            if ((n3 & 0x80) != 0) {
                propertyChangeListener = componentEntry.graphicsConfigurationListener;
            }
            if ((n3 & 0x100) != 0) {
                componentListener = componentEntry.sizeListener;
            }
            return componentEntry.copy(component, string, function0, graphicsDevice, d, n, n2, propertyChangeListener, componentListener);
        }

        @NotNull
        public String toString() {
            return "ComponentEntry(component=" + this.component + ", windowName=" + this.windowName + ", postScalingChange=" + this.postScalingChange + ", lastDevice=" + this.lastDevice + ", lastScale=" + this.lastScale + ", lastWidth=" + this.lastWidth + ", lastHeight=" + this.lastHeight + ", graphicsConfigurationListener=" + this.graphicsConfigurationListener + ", sizeListener=" + this.sizeListener + ")";
        }

        public int hashCode() {
            int result = this.component.hashCode();
            result = result * 31 + this.windowName.hashCode();
            result = result * 31 + this.postScalingChange.hashCode();
            result = result * 31 + (this.lastDevice == null ? 0 : this.lastDevice.hashCode());
            result = result * 31 + Double.hashCode(this.lastScale);
            result = result * 31 + Integer.hashCode(this.lastWidth);
            result = result * 31 + Integer.hashCode(this.lastHeight);
            result = result * 31 + this.graphicsConfigurationListener.hashCode();
            result = result * 31 + this.sizeListener.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentEntry)) {
                return false;
            }
            ComponentEntry componentEntry = (ComponentEntry)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)componentEntry.component)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.windowName, (Object)componentEntry.windowName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.postScalingChange, componentEntry.postScalingChange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastDevice, (Object)componentEntry.lastDevice)) {
                return false;
            }
            if (Double.compare(this.lastScale, componentEntry.lastScale) != 0) {
                return false;
            }
            if (this.lastWidth != componentEntry.lastWidth) {
                return false;
            }
            if (this.lastHeight != componentEntry.lastHeight) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.graphicsConfigurationListener, (Object)componentEntry.graphicsConfigurationListener)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sizeListener, (Object)componentEntry.sizeListener);
        }
    }
}

