/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.Consumer;
import org.awaitility.core.EvaluationCleanup;
import org.awaitility.core.Supplier;

public class ExecutorLifecycle {
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final EvaluationCleanup evaluationCleanup;

    private ExecutorLifecycle(Supplier<ExecutorService> executorServiceSupplier, EvaluationCleanup evaluationCleanup) {
        this.executorServiceSupplier = executorServiceSupplier;
        this.evaluationCleanup = evaluationCleanup;
    }

    public static ExecutorLifecycle withoutCleanup(final ExecutorService executorService) {
        return ExecutorLifecycle.withoutCleanup(new Supplier<ExecutorService>(){

            @Override
            public ExecutorService get() {
                return executorService;
            }
        });
    }

    public static ExecutorLifecycle withoutCleanup(Supplier<ExecutorService> executorServiceSupplier) {
        return new ExecutorLifecycle(executorServiceSupplier, ExecutorLifecycle.noCleanup());
    }

    public static ExecutorLifecycle withNormalCleanupBehavior(Supplier<ExecutorService> executorServiceSupplier) {
        return new ExecutorLifecycle(executorServiceSupplier, ExecutorLifecycle.normalCleanupBehavior());
    }

    public ExecutorService supplyExecutorService() {
        return this.executorServiceSupplier.get();
    }

    void executeNormalCleanupBehavior(ExecutorService executorService) {
        this.evaluationCleanup.executeNormalCleanupBehavior(executorService);
    }

    void executeUnexpectedCleanupBehavior(ExecutorService executorService) {
        this.evaluationCleanup.executeUnexpectedCleanupBehavior(executorService);
    }

    private static EvaluationCleanup noCleanup() {
        Consumer<ExecutorService> noop = new Consumer<ExecutorService>(){

            @Override
            public void accept(ExecutorService executorService) {
            }
        };
        return new EvaluationCleanup(noop, noop);
    }

    private static EvaluationCleanup normalCleanupBehavior() {
        return new EvaluationCleanup(new Consumer<ExecutorService>(){

            @Override
            public void accept(ExecutorService executor) {
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        executor.shutdownNow();
                        executor.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException e) {
                    CheckedExceptionRethrower.safeRethrow(e);
                }
            }
        }, new Consumer<ExecutorService>(){

            @Override
            public void accept(ExecutorService executorService) {
                executorService.shutdownNow();
            }
        });
    }
}

