/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.image;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.ImageIcon;

public class Images {
    private Images() {
    }

    public static Image createImage(Class baseClass, String location) {
        URL resource = baseClass.getResource(location);
        if (resource == null) {
            System.err.println("Warning: Images.createImage no resource found for " + baseClass + " " + location);
            return null;
        }
        return Images.createImage(resource);
    }

    public static Image createImage(URL resource) {
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        return image;
    }

    public static BufferedImage toBufferedImage(RenderedImage rImg) {
        BufferedImage image;
        if (rImg instanceof BufferedImage) {
            image = (BufferedImage)rImg;
        } else {
            Raster r = rImg.getData();
            WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
            rImg.copyData(wr);
            image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }

    public static BufferedImage cloneImage(RenderedImage rImg) {
        Raster r = rImg.getData();
        WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
        rImg.copyData(wr);
        BufferedImage image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean hasAlpha;
            try {
                hasAlpha = Images.hasAlpha(image);
            }
            catch (IllegalAccessError e) {
                hasAlpha = true;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int transparency = 1;
                if (hasAlpha) {
                    transparency = 3;
                }
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bimage == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int count, boolean isHorizontal) {
        BufferedImage src = Images.toBufferedImage(image);
        if (count == 1) {
            return new BufferedImage[]{src};
        }
        BufferedImage[] parts = new BufferedImage[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = isHorizontal ? src.getSubimage(src.getWidth() / count * i, 0, src.getWidth() / count, src.getHeight()) : src.getSubimage(0, src.getHeight() / count * i, src.getWidth(), src.getHeight() / count);
        }
        return parts;
    }

    public static BufferedImage toIntImage(BufferedImage img) {
        if (img.getRaster().getDataBuffer() instanceof DataBufferInt) {
            return img;
        }
        BufferedImage intImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g = intImg.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return intImg;
    }

    public static int[] toPixels(BufferedImage img) {
        return ((DataBufferInt)Images.toIntImage(img).getRaster().getDataBuffer()).getData();
    }

    public static BufferedImage toImage(int[] pixels, int width, int height) {
        return new BufferedImage(DirectColorModel.getRGBdefault(), Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF00000, 65280, 255}), new DataBufferInt(pixels, width * height), new Point(0, 0)), false, null);
    }
}

