/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.converter;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;

public class ScaleImageCodec
extends AbstractVideoCodec {
    public ScaleImageCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})});
        this.name = "Scale Image";
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (!f.containsKey(VideoFormatKeys.WidthKey) || !f.containsKey(VideoFormatKeys.HeightKey)) {
            throw new IllegalArgumentException("Output format must specify width and height.");
        }
        Format fNew = super.setOutputFormat(f.prepend(VideoFormatKeys.DepthKey, 24));
        return fNew;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        BufferedImage imgIn = (BufferedImage)in.data;
        if (imgIn == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        BufferedImage imgOut = null;
        if (out.data instanceof BufferedImage && ((imgOut = (BufferedImage)out.data).getWidth() != this.outputFormat.get(VideoFormatKeys.WidthKey).intValue() || imgOut.getHeight() != this.outputFormat.get(VideoFormatKeys.HeightKey).intValue() || imgOut.getType() != imgIn.getType())) {
            imgOut = null;
        }
        if (imgOut == null) {
            imgOut = imgIn.getColorModel() instanceof IndexColorModel ? new BufferedImage(this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), imgIn.getType(), (IndexColorModel)imgIn.getColorModel()) : new BufferedImage(this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), imgIn.getType());
        }
        Graphics2D g = imgOut.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(imgIn, 0, 0, imgOut.getWidth() - 1, imgOut.getHeight() - 1, 0, 0, imgIn.getWidth() - 1, imgIn.getHeight() - 1, null);
        g.dispose();
        out.data = imgOut;
        return 0;
    }
}

