/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder.monte;

import com.automation.remarks.video.exception.RecordingException;
import com.automation.remarks.video.recorder.VideoConfiguration;
import com.automation.remarks.video.recorder.VideoRecorder;
import com.automation.remarks.video.recorder.monte.MonteScreenRecorder;
import com.automation.remarks.video.recorder.monte.MonteScreenRecorderBuilder;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import org.apache.log4j.Logger;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;

public class MonteRecorder
extends VideoRecorder {
    private static final Logger log = Logger.getLogger(MonteRecorder.class);
    private MonteScreenRecorder screenRecorder;
    private VideoConfiguration videoConfiguration = MonteRecorder.conf();

    public MonteRecorder() {
        this.screenRecorder = this.getScreenRecorder();
    }

    @Override
    public void start() {
        this.screenRecorder.start();
        log.info((Object)"Recording started");
    }

    @Override
    public File stopAndSave(String filename) {
        File video = this.writeVideo(filename);
        this.setLastVideo(video);
        log.info((Object)("Recording finished to " + video.getAbsolutePath()));
        return video;
    }

    private File writeVideo(String filename) {
        try {
            return this.screenRecorder.saveAs(filename);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RecordingException("Video recording wasn't started");
        }
    }

    private GraphicsConfiguration getGraphicConfig() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private MonteScreenRecorder getScreenRecorder() {
        int frameRate = this.videoConfiguration.frameRate();
        Format fileFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi"});
        Format screenFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "tscc", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf(frameRate), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900});
        Format mouseFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf(frameRate)});
        Dimension screenSize = this.videoConfiguration.screenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        Rectangle captureSize = new Rectangle(0, 0, width, height);
        return MonteScreenRecorderBuilder.builder().setGraphicConfig(this.getGraphicConfig()).setRectangle(captureSize).setFileFormat(fileFormat).setScreenFormat(screenFormat).setFolder(new File(this.videoConfiguration.folder())).setMouseFormat(mouseFormat).build();
    }
}

