/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.util;

import java.lang.reflect.Method;
import org.aeonbits.owner.util.Reflection;

public class Base64 {
    private static Method decoderMethod;
    private static Method encoderMethod;
    private static Object decoderObject;
    private static Object encoderObject;

    private static void reset() {
        encoderObject = null;
        encoderMethod = null;
        decoderMethod = null;
        decoderObject = null;
    }

    public static byte[] decode(String data) {
        if (decoderMethod == null) {
            throw new UnsupportedOperationException("Cannot find Base64 decoder.");
        }
        try {
            return (byte[])decoderMethod.invoke(decoderObject, data);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String encode(byte[] data) {
        if (encoderMethod == null) {
            throw new UnsupportedOperationException("Cannot find Base64 encoder.");
        }
        try {
            return (String)encoderMethod.invoke(encoderObject, new Object[]{data});
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Class[] decodeParameterTypes = new Class[]{String.class};
        Class[] encodeParameterTypes = new Class[]{byte[].class};
        Class<?> javaUtilBase64Class = Reflection.forName("java.util.Base64");
        if (javaUtilBase64Class != null) {
            try {
                decoderObject = javaUtilBase64Class.getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
                decoderMethod = decoderObject.getClass().getMethod("decode", decodeParameterTypes);
                encoderObject = javaUtilBase64Class.getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
                encoderMethod = encoderObject.getClass().getMethod("encodeToString", encodeParameterTypes);
            }
            catch (Exception e) {
                Base64.reset();
            }
        }
        if (decoderMethod == null) {
            decoderObject = null;
            encoderObject = null;
            Class<?> javaxXmlBindDatatypeConverterClass = Reflection.forName("javax.xml.bind.DatatypeConverter");
            if (javaxXmlBindDatatypeConverterClass != null) {
                try {
                    decoderMethod = javaxXmlBindDatatypeConverterClass.getMethod("parseBase64Binary", decodeParameterTypes);
                    encoderMethod = javaxXmlBindDatatypeConverterClass.getMethod("printBase64Binary", encodeParameterTypes);
                }
                catch (NoSuchMethodException e) {
                    Base64.reset();
                }
            }
        }
    }
}

