/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video;

import com.automation.remarks.video.enums.OsType;
import com.automation.remarks.video.exception.RecordingException;
import com.automation.remarks.video.recorder.ffmpeg.FFMpegRecorder;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.zeroturnaround.exec.ProcessExecutor;

public class SystemUtils {
    private static final Logger log = Logger.getLogger(FFMpegRecorder.class);

    public static String runCommand(List<String> args) {
        log.info((Object)("Trying to execute the following command: " + args));
        try {
            return new ProcessExecutor().command(args).readOutput(true).execute().outputUTF8();
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            log.warn((Object)("Unable to execute command: " + e));
            throw new RecordingException(e);
        }
    }

    public static String runCommand(String ... args) {
        log.info((Object)("Trying to execute the following command: " + Arrays.asList(args)));
        try {
            return new ProcessExecutor().command(args).readOutput(true).execute().outputUTF8();
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            log.warn((Object)("Unable to execute command: " + e));
            throw new RecordingException(e);
        }
    }

    public static String getPidOf(String processName) {
        return SystemUtils.runCommand("cmd", "/c", "for /f \"tokens=2\" %i in ('tasklist ^| findstr \"" + processName + "\"') do @echo %i").trim();
    }

    public static Dimension getSystemScreenDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static String getOsType() {
        if (org.apache.commons.lang3.SystemUtils.IS_OS_WINDOWS) {
            return OsType.windows.name();
        }
        if (org.apache.commons.lang3.SystemUtils.IS_OS_MAC) {
            return OsType.mac.name();
        }
        return OsType.linux.name();
    }
}

