/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.ImportantNonMergeableGutterMark;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.JBImageIcon;
import com.remco.software.ncrunch.editor.CoverageMarkerMouseEventHandler;
import com.remco.software.ncrunch.editor.EditorReference;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B1\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010'\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lcom/remco/software/ncrunch/editor/CoverageMarkerIcon;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "Lcom/intellij/openapi/editor/ImportantNonMergeableGutterMark;", "Lcom/intellij/openapi/project/DumbAware;", "line", "", "path", "", "lineHeight", "", "markerClickHandler", "Lcom/remco/software/ncrunch/editor/CoverageMarkerMouseEventHandler;", "editorReference", "Lcom/remco/software/ncrunch/editor/EditorReference;", "<init>", "(ILjava/lang/String;DLcom/remco/software/ncrunch/editor/CoverageMarkerMouseEventHandler;Lcom/remco/software/ncrunch/editor/EditorReference;)V", "getPath", "()Ljava/lang/String;", "_bufferedImage", "Ljavax/swing/ImageIcon;", "_line", "value", "getLine", "()I", "setLine", "(I)V", "_lineHeight", "getLineHeight", "()D", "setLineHeight", "(D)V", "equals", "", "other", "", "hashCode", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getRightButtonClickAction", "emptyImageIcon", "bufferedImage", "getBufferedImage", "()Ljavax/swing/ImageIcon;", "getIcon", "Ljavax/swing/Icon;", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "ncrunchforrider"})
public final class CoverageMarkerIcon
extends GutterIconRenderer
implements ImportantNonMergeableGutterMark,
DumbAware {
    @NotNull
    private final String path;
    @NotNull
    private final CoverageMarkerMouseEventHandler markerClickHandler;
    @NotNull
    private final EditorReference editorReference;
    @Nullable
    private ImageIcon _bufferedImage;
    private int _line;
    private double _lineHeight;
    @NotNull
    private final ImageIcon emptyImageIcon;

    public CoverageMarkerIcon(int line, @NotNull String path, double lineHeight, @NotNull CoverageMarkerMouseEventHandler markerClickHandler, @NotNull EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)markerClickHandler), (String)"markerClickHandler");
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        this.path = path;
        this.markerClickHandler = markerClickHandler;
        this.editorReference = editorReference;
        this._line = line;
        this._lineHeight = lineHeight;
        this.emptyImageIcon = new ImageIcon();
    }

    public /* synthetic */ CoverageMarkerIcon(int n, String string, double d, CoverageMarkerMouseEventHandler coverageMarkerMouseEventHandler, EditorReference editorReference, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, string, d, coverageMarkerMouseEventHandler, editorReference);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getLine() {
        return this._line;
    }

    public final void setLine(int value) {
        this._line = value;
        this._bufferedImage = null;
    }

    public final double getLineHeight() {
        return this._lineHeight;
    }

    public final void setLineHeight(double value) {
        this._lineHeight = value;
        this._bufferedImage = null;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof CoverageMarkerIcon) {
            return ((CoverageMarkerIcon)((Object)other)).getLine() == this.getLine() && Intrinsics.areEqual((Object)((CoverageMarkerIcon)((Object)other)).path, (Object)this.path);
        }
        return false;
    }

    public int hashCode() {
        return (this.getLine() + this.path).hashCode();
    }

    @NotNull
    public AnAction getClickAction() {
        this.markerClickHandler.beforeActionPerformed(this);
        return this.markerClickHandler;
    }

    @NotNull
    public AnAction getRightButtonClickAction() {
        this.markerClickHandler.beforeActionPerformed(this);
        return this.markerClickHandler;
    }

    private final ImageIcon getBufferedImage() {
        if (this.editorReference.getMarkerOverlayImage() == null) {
            return this.emptyImageIcon;
        }
        if (this._bufferedImage == null) {
            ImageIcon imageIcon;
            CoverageMarkerIcon coverageMarkerIcon;
            double scaleFactor = this.editorReference.getScaleFactor();
            BufferedImage bufferedImage = this.editorReference.getMarkerOverlayImage();
            Intrinsics.checkNotNull((Object)bufferedImage);
            BufferedImage image = bufferedImage;
            double top = (double)this.getLine() * this.getLineHeight();
            double bottom = top + this.getLineHeight();
            int width = this.editorReference.getMarkerOverlayWidth();
            CoverageMarkerIcon coverageMarkerIcon2 = this;
            try {
                ImageIcon imageIcon2;
                coverageMarkerIcon = coverageMarkerIcon2;
                if (top >= 0.0 && bottom <= (double)image.getHeight() && width >= 0 && width <= image.getWidth()) {
                    BufferedImage bufferedImage2 = image.getSubimage(0, MathKt.roundToInt((double)top), width, MathKt.roundToInt((double)this.getLineHeight()));
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"getSubimage(...)");
                    imageIcon2 = (ImageIcon)new JBImageIcon((Image)new JBHiDPIScaledImage((Image)bufferedImage2, scaleFactor));
                } else {
                    imageIcon2 = this.emptyImageIcon;
                }
                imageIcon = imageIcon2;
            }
            catch (Exception exception) {
                coverageMarkerIcon = coverageMarkerIcon2;
                imageIcon = this.emptyImageIcon;
            }
            coverageMarkerIcon._bufferedImage = imageIcon;
        }
        return this._bufferedImage;
    }

    @NotNull
    public Icon getIcon() {
        ImageIcon imageIcon = this.getBufferedImage();
        return imageIcon != null ? (Icon)imageIcon : (Icon)this.emptyImageIcon;
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.RIGHT;
    }
}

