/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch;

import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.model.IntelliJGlobalError;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/remco/software/ncrunch/ErrorService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logUnified", "", "message", "", "errorEventUpdate", "error", "Lcom/remco/software/ncrunch/model/IntelliJGlobalError;", "dispose", "Companion", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nErrorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorService.kt\ncom/remco/software/ncrunch/ErrorService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n13#2:62\n*S KotlinDebug\n*F\n+ 1 ErrorService.kt\ncom/remco/software/ncrunch/ErrorService\n*L\n14#1:62\n*E\n"})
public final class ErrorService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public ErrorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ErrorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getErrorEvent().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (Function1)new Function1<IntelliJGlobalError, Unit>((Object)this){

            public final void invoke(IntelliJGlobalError p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ErrorService)this.receiver).errorEventUpdate(p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getLogUnified().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ErrorService)this.receiver).logUnified(p0);
            }
        });
    }

    private final void logUnified(String message) {
        this.logger.info("[" + this.project.getName() + "] Unified NCrunch: " + message);
    }

    private final void errorEventUpdate(IntelliJGlobalError error) {
        Companion.notifyUserOfError(error.getMessage(), error.getDetails(), this.project);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Lcom/remco/software/ncrunch/ErrorService$Companion;", "", "<init>", "()V", "notifyUserOfError", "", "errorMessage", "", "errorDetails", "project", "Lcom/intellij/openapi/project/Project;", "doWithErrorHandling", "function", "Lkotlin/Function0;", "logUnified", "message", "ncrunchforrider"})
    @SourceDebugExtension(value={"SMAP\nErrorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorService.kt\ncom/remco/software/ncrunch/ErrorService$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n13#2:62\n13#2:63\n*S KotlinDebug\n*F\n+ 1 ErrorService.kt\ncom/remco/software/ncrunch/ErrorService$Companion\n*L\n36#1:62\n56#1:63\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void notifyUserOfError(@NotNull String errorMessage, @NotNull String errorDetails, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkNotNullParameter((Object)errorDetails, (String)"errorDetails");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ErrorService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            String[] stringArray = new String[]{errorDetails};
            logger.error(errorMessage, stringArray);
            NotificationGroupManager.getInstance().getNotificationGroup("NCrunch Notifications").createNotification(errorMessage, errorDetails, NotificationType.ERROR).notify(project);
        }

        public final void doWithErrorHandling(@NotNull Project project, @NotNull Function0<Unit> function) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            try {
                function.invoke();
            }
            catch (Exception e) {
                this.notifyUserOfError(String.valueOf(e.getMessage()), ExceptionsKt.stackTraceToString((Throwable)e), project);
            }
        }

        public final void logUnified(@NotNull String message, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ErrorService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("[" + project.getName() + "] Unified IntelliJ: " + message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

