/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder.ffmpeg;

import com.automation.remarks.video.DateUtils;
import com.automation.remarks.video.SystemUtils;
import com.automation.remarks.video.recorder.VideoRecorder;
import com.automation.remarks.video.recorder.ffmpeg.FFMpegRecorder;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;

public class FFmpegWrapper {
    private static final Logger log = Logger.getLogger(FFMpegRecorder.class);
    public static final String RECORDING_TOOL = "ffmpeg";
    private static final String TEM_FILE_NAME = "temporary";
    private static final String EXTENSION = ".mp4";
    private CompletableFuture<String> future;
    private File temporaryFile;

    public void startFFmpeg(String ... args) {
        File videoFolder = new File(VideoRecorder.conf().folder());
        if (!videoFolder.exists()) {
            videoFolder.mkdirs();
        }
        this.temporaryFile = this.getTemporaryFile();
        String[] commandsSequence = new String[]{RECORDING_TOOL, "-y", "-video_size", this.getScreenSize(), "-f", VideoRecorder.conf().ffmpegFormat(), "-i", VideoRecorder.conf().ffmpegDisplay(), "-an", "-framerate", String.valueOf(VideoRecorder.conf().frameRate()), "-pix_fmt", VideoRecorder.conf().ffmpegPixelFormat(), this.temporaryFile.getAbsolutePath()};
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(commandsSequence));
        command.addAll(Arrays.asList(args));
        this.future = CompletableFuture.supplyAsync(() -> SystemUtils.runCommand(command));
    }

    public File stopFFmpegAndSave(String filename) {
        String killLog = this.killFFmpeg();
        log.info((Object)("Process kill output: " + killLog));
        File destFile = this.getResultFile(filename);
        this.future.whenCompleteAsync((out, errors) -> {
            this.temporaryFile.renameTo(destFile);
            log.debug((Object)("Recording output log: " + out + (errors != null ? "; ex: " + errors : "")));
            log.info((Object)("Recording finished to: " + destFile.getAbsolutePath()));
        });
        return destFile;
    }

    private String killFFmpeg() {
        String SEND_CTRL_C_TOOL_NAME = "SendSignalCtrlC.exe";
        return org.apache.commons.lang3.SystemUtils.IS_OS_WINDOWS ? SystemUtils.runCommand("SendSignalCtrlC.exe", SystemUtils.getPidOf(RECORDING_TOOL)) : SystemUtils.runCommand("pkill", "-INT", RECORDING_TOOL);
    }

    public File getTemporaryFile() {
        return this.getFile(TEM_FILE_NAME);
    }

    public File getResultFile(String name) {
        return this.getFile(name);
    }

    private File getFile(String filename) {
        File movieFolder = new File(VideoRecorder.conf().folder());
        String name = filename + "_recording_" + DateUtils.formatDate(new Date(), "yyyy_dd_MM_HH_mm_ss");
        return new File(movieFolder + File.separator + name + EXTENSION);
    }

    private String getScreenSize() {
        Dimension dimension = VideoRecorder.conf().screenSize();
        return dimension.width + "x" + dimension.height;
    }
}

