/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder.ffmpeg;

import com.automation.remarks.video.exception.RecordingException;
import com.automation.remarks.video.recorder.VideoRecorder;
import com.automation.remarks.video.recorder.ffmpeg.FFmpegWrapper;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public abstract class FFMpegRecorder
extends VideoRecorder {
    private FFmpegWrapper ffmpegWrapper = new FFmpegWrapper();

    public FFmpegWrapper getFfmpegWrapper() {
        return this.ffmpegWrapper;
    }

    @Override
    public File stopAndSave(String filename) {
        File file = this.getFfmpegWrapper().stopFFmpegAndSave(filename);
        this.waitForVideoCompleted(file);
        this.setLastVideo(file);
        return file;
    }

    private void waitForVideoCompleted(File video) {
        try {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).ignoreExceptions().until(video::exists);
        }
        catch (ConditionTimeoutException ex) {
            throw new RecordingException(ex.getMessage());
        }
    }
}

