/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.RiderSolutionLifecycle_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.ErrorService;
import com.remco.software.ncrunch.NCrunchLookAndFeelListener;
import com.remco.software.ncrunch.editor.EditorIntegrationService;
import com.remco.software.ncrunch.files.FileRenameEventListener;
import com.remco.software.ncrunch.menu.NCrunchAction;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/remco/software/ncrunch/NCrunchStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getRiderVersion", "", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateMenuActionsRecursively", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPlugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nNCrunchStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NCrunchStartupActivity.kt\ncom/remco/software/ncrunch/NCrunchStartupActivity\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n15#2:150\n31#3,2:151\n13402#4,2:153\n*S KotlinDebug\n*F\n+ 1 NCrunchStartupActivity.kt\ncom/remco/software/ncrunch/NCrunchStartupActivity\n*L\n28#1:150\n113#1:151,2\n129#1:153,2\n*E\n"})
public final class NCrunchStartupActivity
implements ProjectActivity {
    @NotNull
    private final Logger logger;

    public NCrunchStartupActivity() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NCrunchStartupActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final String getRiderVersion() {
        String string = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        return StringsKt.substringAfterLast$default((String)string, (char)' ', null, (int)2, null);
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        IdeaPluginDescriptor ideaPluginDescriptor = this.getPlugin();
        this.logger.info("NCrunch is starting up, version: " + (ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null) + ", Rider version: " + this.getRiderVersion());
        FileRenameEventListener fileRenameEventListener = new FileRenameEventListener(project);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)fileRenameEventListener, (Disposable)project);
        new ErrorService(project);
        this.logger.info("Project opened sending theme to NCrunch");
        NCrunchLookAndFeelListener.Companion.sendRiderThemeToNCrunch(project);
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getRequestRiderTheme().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> NCrunchStartupActivity.execute$lambda$0(this, project, arg_0));
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getRequestSolutionIsLoaded().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> NCrunchStartupActivity.execute$lambda$1(this, project, arg_0));
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getNCrunchVersion().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> NCrunchStartupActivity.execute$lambda$2(this, project, arg_0));
        this.logger.info("Checking if solution is loaded and notifying NCrunch when it is.");
        this.checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs(project);
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getShowToolWindow().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Function1)new Function1<String, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1, Intrinsics.Kotlin.class, "showToolWindow", "execute$showToolWindow(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", 0);
            }

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NCrunchStartupActivity.access$execute$showToolWindow(this.$project, p0);
            }
        });
        this.logger.info("Menu item: Updating menu item status and text from NCrunch during startup");
        ActionManager actionManager = ActionManager.getInstance();
        AnAction crunchMenu2 = actionManager.getAction("crunchMenu");
        if (crunchMenu2 != null) {
            DataContext dataContext = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.PROJECT, (Object)project, (DataContext)DataContext.EMPTY_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getSimpleContext(...)");
            DataContext dataContext2 = dataContext;
            AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, null, (String)"MainMenu", (ActionUiKind)ActionUiKind.NONE, null);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
            AnActionEvent menuEvent = anActionEvent;
            this.updateMenuActionsRecursively(crunchMenu2, menuEvent);
        }
        this.logger.info("Initialising editor integration service");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<EditorIntegrationService> serviceClass$iv = EditorIntegrationService.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.logger.info("NCrunch startup is complete");
        return Unit.INSTANCE;
    }

    private final void updateMenuActionsRecursively(AnAction action, AnActionEvent event) {
        if (action == null) {
            return;
        }
        if (action instanceof NCrunchAction) {
            this.logger.info("Menu item: (" + ((NCrunchAction)action).getId() + "): Updating menu item recurse: " + ((NCrunchAction)action).getTemplatePresentation().getText());
        } else {
            this.logger.info("Menu item: Updating menu item: " + action.getTemplatePresentation().getText());
        }
        action.update(event);
        if (action instanceof ActionGroup) {
            AnAction[] anActionArray = ((ActionGroup)action).getChildren(event);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            Object[] $this$forEach$iv = anActionArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction child = (AnAction)element$iv;
                boolean bl = false;
                this.updateMenuActionsRecursively(child, event);
            }
        }
    }

    private final IdeaPluginDescriptor getPlugin() {
        return PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.remco.software.ncrunch"));
    }

    private final void checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> NCrunchStartupActivity.checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs$lambda$5(project, this));
    }

    private static final Unit execute$lambda$0(NCrunchStartupActivity this$0, Project $project, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.info("Theme requested sending theme to NCrunch");
        NCrunchLookAndFeelListener.Companion.sendRiderThemeToNCrunch($project);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$1(NCrunchStartupActivity this$0, Project $project, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs($project);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$2(NCrunchStartupActivity this$0, Project $project, String it) {
        IdeaPluginDescriptor plugin;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IdeaPluginDescriptor ideaPluginDescriptor = plugin = this$0.getPlugin();
        if (!Intrinsics.areEqual((Object)(ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null), (Object)it)) {
            IdeaPluginDescriptor ideaPluginDescriptor2 = plugin;
            ErrorService.Companion.notifyUserOfError("NCrunch deployment is not correct", "NCrunch .net binary version: " + it + " Rider/IntelliJ plugin version: " + (ideaPluginDescriptor2 != null ? ideaPluginDescriptor2.getVersion() : null) + ". Please reinstall the plugin.", $project);
        }
        IdeaPluginDescriptor ideaPluginDescriptor3 = plugin;
        this$0.logger.info("NCrunch .net binary version: " + it + " Rider/IntelliJ plugin version: " + (ideaPluginDescriptor3 != null ? ideaPluginDescriptor3.getVersion() : null) + ".");
        return Unit.INSTANCE;
    }

    private static final void execute$showToolWindow(Project $project, String toolwindowName) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow(toolwindowName);
        if (toolWindow != null) {
            if (toolWindow.isVisible()) {
                toolWindow.activate(null);
            } else {
                toolWindow.show();
            }
        }
    }

    private static final boolean checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs$lambda$5$lambda$4(NCrunchStartupActivity this$0, Project $project, boolean isReady) {
        if (!isReady) {
            return false;
        }
        this$0.logger.info("Solution is loaded, notifying NCrunch");
        InterfacesKt.fire((ISignal)((ISignal)NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)$project)).getSolutionIsLoaded()));
        return true;
    }

    private static final void checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs$lambda$5(Project $project, NCrunchStartupActivity this$0) {
        SourceExKt.adviseUntil((ISource)((ISource)RiderSolutionLifecycle_PregeneratedKt.getRiderSolutionLifecycle((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).isProjectModelReady()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$project)), arg_0 -> NCrunchStartupActivity.checkIfSolutionIsLoadedAndNotifyNCrunchWhenItIs$lambda$5$lambda$4(this$0, $project, arg_0));
    }

    public static final /* synthetic */ void access$execute$showToolWindow(Project $project, String toolwindowName) {
        NCrunchStartupActivity.execute$showToolWindow($project, toolwindowName);
    }
}

