/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rd.framework.base.IRdBindableKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.editor.CoverageMarkerIcon;
import com.remco.software.ncrunch.editor.CoverageMarkerMouseEventHandler;
import com.remco.software.ncrunch.editor.EditorIntegrationService;
import com.remco.software.ncrunch.editor.MemoryMapImageReceiver;
import com.remco.software.ncrunch.editor.rdi.FixedSizeQueue;
import com.remco.software.ncrunch.editor.rdi.RdiCaretListener;
import com.remco.software.ncrunch.editor.rdi.RdiHighlightRenderer;
import com.remco.software.ncrunch.editor.rdi.RdiMouseEventPoint;
import com.remco.software.ncrunch.editor.rdi.RdiMouseListener;
import com.remco.software.ncrunch.editor.rdi.RdiUIElementInfo;
import com.remco.software.ncrunch.model.EditorInformationProvided;
import com.remco.software.ncrunch.model.EditorLineHeightChangedEvent;
import com.remco.software.ncrunch.model.EditorOpenedEvent;
import com.remco.software.ncrunch.model.InlayCoordinate;
import com.remco.software.ncrunch.model.NCrunchForRiderModel;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.win32.Win32;
import com.sun.jna.Pointer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u00af\u00012\u00020\u0001:\u0002\u00af\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u00102\u001a\u00020\u0019J\u0006\u00103\u001a\u000204J\b\u00105\u001a\u000204H\u0002J0\u0010C\u001a\u0002042\u0006\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020=H\u0002J\b\u0010J\u001a\u000204H\u0002J\u0010\u0010R\u001a\u0002042\u0006\u0010S\u001a\u000207H\u0002J0\u0010T\u001a\u0002042\u0006\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020=H\u0002J\b\u0010U\u001a\u000204H\u0002J\u000e\u0010V\u001a\u0002042\u0006\u0010W\u001a\u00020+J\b\u0010X\u001a\u000204H\u0002J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0ZH\u0002JF\u0010[\u001a\u0002042<\u0010\\\u001a8\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b^\u0012\b\b_\u0012\u0004\b\b(`\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020a0Z\u00a2\u0006\f\b^\u0012\b\b_\u0012\u0004\b\b(b\u0012\u0004\u0012\u0002040]H\u0002J\u0006\u0010c\u001a\u000204J\u0010\u0010d\u001a\u0002042\u0006\u0010e\u001a\u00020 H\u0002J\u0018\u0010f\u001a\u0002042\u0006\u0010e\u001a\u00020 2\u0006\u0010g\u001a\u00020\"H\u0002J\b\u0010h\u001a\u00020iH\u0002J\u0006\u0010j\u001a\u000204J\b\u0010k\u001a\u000204H\u0002J\u0010\u0010l\u001a\u00020\"2\u0006\u0010`\u001a\u00020mH\u0002J\u0010\u0010n\u001a\u00020=2\u0006\u0010`\u001a\u00020mH\u0002J\t\u0010\u0083\u0001\u001a\u00020wH\u0002J\u0011\u0010\u0084\u0001\u001a\u0002042\u0006\u0010`\u001a\u00020mH\u0002J\u001d\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020z0y2\u0006\u0010`\u001a\u00020mH\u0002\u00a2\u0006\u0003\u0010\u0086\u0001J\u0010\u0010~\u001a\u00020=2\u0006\u0010`\u001a\u00020mH\u0002J\u0012\u0010\u0087\u0001\u001a\u00030\u0080\u00012\u0006\u0010`\u001a\u00020mH\u0002J\u0007\u0010\u0088\u0001\u001a\u000204J\u0011\u0010\u0089\u0001\u001a\u00020=2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008a\u0001\u001a\u00020\"2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008b\u0001\u001a\u00020\"2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008c\u0001\u001a\u00020\"2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008d\u0001\u001a\u00020\"2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008e\u0001\u001a\u00020p2\u0006\u0010`\u001a\u00020mH\u0002J\u0011\u0010\u008f\u0001\u001a\u0002042\u0006\u0010`\u001a\u00020 H\u0002J\u0019\u0010\u0090\u0001\u001a\n\u0018\u00010a\u00a2\u0006\u0003\b\u0091\u00012\u0006\u0010`\u001a\u00020 H\u0002J\u0007\u0010\u00aa\u0001\u001a\u000204J\u0007\u0010\u00ab\u0001\u001a\u000204J\u0007\u0010\u00ac\u0001\u001a\u00020\"J\u0007\u0010\u00ad\u0001\u001a\u000204J\u0007\u0010\u00ae\u0001\u001a\u000204R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020=0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010K\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u00109\"\u0004\bM\u0010;R\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020pX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020wX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020z0yX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010{R\u000e\u0010|\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010}\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u007f\u001a\u00030\u0080\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0081\u0001\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0082\u0001\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0092\u0001\u001a\u00030\u0093\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0094\u0001\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0095\u0001\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0096\u0001\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001\"\u0006\b\u0099\u0001\u0010\u009a\u0001R&\u0010\u009b\u0001\u001a\t\u0012\u0005\u0012\u00030\u009c\u00010\u001fX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001\"\u0006\b\u009f\u0001\u0010\u00a0\u0001R\u001f\u0010\u00a1\u0001\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a2\u0001\u0010\u0098\u0001\"\u0006\b\u00a3\u0001\u0010\u009a\u0001R\u001f\u0010\u00a4\u0001\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a5\u0001\u0010\u00a6\u0001\"\u0006\b\u00a7\u0001\u0010\u00a8\u0001R\u000f\u0010\u00a9\u0001\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b0\u0001"}, d2={"Lcom/remco/software/ncrunch/editor/EditorReference;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "integrationService", "Lcom/remco/software/ncrunch/editor/EditorIntegrationService;", "project", "Lcom/intellij/openapi/project/Project;", "sharedMemoryDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/remco/software/ncrunch/editor/EditorIntegrationService;Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/intellij/openapi/editor/Document;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "editorGuid", "Ljava/util/UUID;", "getEditorGuid", "()Ljava/util/UUID;", "drawDiagnostics", "", "isForeGround", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logger$1", "editors", "", "Lcom/intellij/openapi/fileEditor/TextEditor;", "lineHeight", "", "editorPropertiesChangeDetectorTimer", "Ljavax/swing/Timer;", "resetRdiHighlightRenderer", "rdiMemoryMapImageReceiver", "Lcom/remco/software/ncrunch/editor/MemoryMapImageReceiver;", "markersMemoryMapImageReceiver", "rdiMouseEventList", "Lcom/remco/software/ncrunch/editor/rdi/FixedSizeQueue;", "Lcom/remco/software/ncrunch/editor/rdi/RdiMouseEventPoint;", "rdiMouseListener", "Lcom/remco/software/ncrunch/editor/rdi/RdiMouseListener;", "rdiCaretListener", "Lcom/remco/software/ncrunch/editor/rdi/RdiCaretListener;", "coverageMarkerMouseEventHandler", "Lcom/remco/software/ncrunch/editor/CoverageMarkerMouseEventHandler;", "hasOpenEditors", "registerTextEditor", "", "noMarkerImageAvailable", "markerOverlayImage", "Ljava/awt/image/BufferedImage;", "getMarkerOverlayImage", "()Ljava/awt/image/BufferedImage;", "setMarkerOverlayImage", "(Ljava/awt/image/BufferedImage;)V", "markerOverlayWidth", "", "getMarkerOverlayWidth", "()I", "setMarkerOverlayWidth", "(I)V", "markerCurrentList", "markerImageReceived", "bufferedImage", "width", "height", "secondaryPayload", "", "secondaryPayloadSize", "noRdiImageAvailable", "rdiOverlayImage", "getRdiOverlayImage", "setRdiOverlayImage", "rdiImageWriteCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "rdiImageWriteDirectory", "Ljava/io/File;", "writeRdiImageToFile", "image", "rdiImageReceived", "drawElementInfoOnImage", "addRdiMouseEvent", "mouseEvent", "drawLastMouseEvents", "getOpenEditorsForFile", "", "runOnOpenEditors", "functionToRun", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "editor", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "highlighters", "clearMarkers", "checkLineHeightChanged", "textEditor", "sendEditorOpened", "currentLineHeight", "getRiderModel", "Lcom/remco/software/ncrunch/model/NCrunchForRiderModel;", "unregisterTextEditor", "redrawEditorGutter", "getEditorLineHeight", "Lcom/intellij/openapi/editor/Editor;", "getTabSize", "currentFont", "", "currentBackGroundColor", "currentViewPortWidth", "currentViewPortHeight", "currentCharWidth", "currentFontSize", "currentYCoordinates", "", "currentInlayCoordinates", "", "Lcom/remco/software/ncrunch/model/InlayCoordinate;", "[Lcom/remco/software/ncrunch/model/InlayCoordinate;", "currentXOffSet", "currentYOffSet", "currentScrollPosition", "currentWindowHandle", "", "currentTabSize", "currentScalingFactor", "generateTextCoordinates", "checkEditorPropertiesHaveChanged", "generateInlayCoordinates", "(Lcom/intellij/openapi/editor/Editor;)[Lcom/remco/software/ncrunch/model/InlayCoordinate;", "getEditorWindowHandle", "sendCurrentEditorStateToNCrunch", "getEditorBackGroundColor", "getEditorViewPortWidth", "getEditorViewPortHeight", "getEditorCharWidth", "getEditorFontSize", "getEditorFont", "setupOrInvalidateRdiHighlighter", "getRdiHighlighterForEditor", "Lorg/jetbrains/annotations/NotNull;", "rdiHighlightRenderer", "Lcom/remco/software/ncrunch/editor/rdi/RdiHighlightRenderer;", "rdiOverlayWidth", "rdiOverlayHeight", "rdiOverlayActive", "getRdiOverlayActive", "()Z", "setRdiOverlayActive", "(Z)V", "rdiElementInfoList", "Lcom/remco/software/ncrunch/editor/rdi/RdiUIElementInfo;", "getRdiElementInfoList", "()Ljava/util/List;", "setRdiElementInfoList", "(Ljava/util/List;)V", "rdiSplitRendering", "getRdiSplitRendering", "setRdiSplitRendering", "rdiSplitRenderingStart", "getRdiSplitRenderingStart", "()D", "setRdiSplitRenderingStart", "(D)V", "rdiSplitRenderingEnd", "closeRdiOverlay", "openRdiOverlay", "getScaleFactor", "markAsForeground", "markAsBackground", "Companion", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nEditorReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorReference.kt\ncom/remco/software/ncrunch/editor/EditorReference\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,793:1\n15#2:794\n15#2:845\n774#3:795\n865#3,2:796\n1863#3,2:798\n1863#3:813\n1864#3:827\n774#3:828\n865#3,2:829\n1863#3,2:831\n1863#3,2:833\n1863#3,2:841\n1863#3,2:843\n11476#4,9:800\n13402#4:809\n13403#4:811\n11485#4:812\n11476#4,9:814\n13402#4:823\n13403#4:825\n11485#4:826\n1310#4,2:839\n1#5:810\n1#5:824\n37#6:835\n36#6,3:836\n*S KotlinDebug\n*F\n+ 1 EditorReference.kt\ncom/remco/software/ncrunch/editor/EditorReference\n*L\n55#1:794\n784#1:845\n115#1:795\n115#1:796,2\n115#1:798,2\n368#1:813\n368#1:827\n420#1:828\n420#1:829,2\n420#1:831,2\n577#1:833,2\n201#1:841,2\n376#1:843,2\n360#1:800,9\n360#1:809\n360#1:811\n360#1:812\n369#1:814,9\n369#1:823\n369#1:825\n369#1:826\n721#1:839,2\n360#1:810\n369#1:824\n585#1:835\n585#1:836,3\n*E\n"})
public final class EditorReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VirtualFile file;
    @NotNull
    private final EditorIntegrationService integrationService;
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final UUID editorGuid;
    private final boolean drawDiagnostics;
    private boolean isForeGround;
    @NotNull
    private final Logger logger$1;
    @NotNull
    private List<TextEditor> editors;
    private double lineHeight;
    @NotNull
    private Timer editorPropertiesChangeDetectorTimer;
    private boolean resetRdiHighlightRenderer;
    @Nullable
    private MemoryMapImageReceiver rdiMemoryMapImageReceiver;
    @Nullable
    private MemoryMapImageReceiver markersMemoryMapImageReceiver;
    @NotNull
    private FixedSizeQueue<RdiMouseEventPoint> rdiMouseEventList;
    @NotNull
    private final RdiMouseListener rdiMouseListener;
    @NotNull
    private final RdiCaretListener rdiCaretListener;
    @NotNull
    private final CoverageMarkerMouseEventHandler coverageMarkerMouseEventHandler;
    @Nullable
    private BufferedImage markerOverlayImage;
    private int markerOverlayWidth;
    @NotNull
    private final List<Integer> markerCurrentList;
    @Nullable
    private BufferedImage rdiOverlayImage;
    @NotNull
    private final AtomicInteger rdiImageWriteCounter;
    @NotNull
    private final File rdiImageWriteDirectory;
    @NotNull
    private String currentFont;
    private int currentBackGroundColor;
    private double currentViewPortWidth;
    private double currentViewPortHeight;
    private double currentCharWidth;
    private double currentFontSize;
    private double currentLineHeight;
    @NotNull
    private double[] currentYCoordinates;
    @NotNull
    private InlayCoordinate[] currentInlayCoordinates;
    private int currentXOffSet;
    private int currentYOffSet;
    private int currentScrollPosition;
    private long currentWindowHandle;
    private int currentTabSize;
    private double currentScalingFactor;
    @NotNull
    private final RdiHighlightRenderer rdiHighlightRenderer;
    private int rdiOverlayWidth;
    private int rdiOverlayHeight;
    private boolean rdiOverlayActive;
    @NotNull
    private List<RdiUIElementInfo> rdiElementInfoList;
    private boolean rdiSplitRendering;
    private double rdiSplitRenderingStart;
    private double rdiSplitRenderingEnd;
    @NotNull
    private static final Logger logger;

    public EditorReference(@NotNull VirtualFile file, @NotNull EditorIntegrationService integrationService, @NotNull Project project, @NotNull CoroutineDispatcher sharedMemoryDispatcher, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)integrationService, (String)"integrationService");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sharedMemoryDispatcher, (String)"sharedMemoryDispatcher");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.file = file;
        this.integrationService = integrationService;
        this.project = project;
        this.document = document;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.editorGuid = uUID;
        this.isForeGround = true;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorReference.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger$1 = logger;
        this.editors = new ArrayList();
        this.lineHeight = (double)17 * this.getScaleFactor();
        this.resetRdiHighlightRenderer = true;
        this.rdiMouseEventList = new FixedSizeQueue(20);
        this.rdiMouseListener = new RdiMouseListener(this);
        this.rdiCaretListener = new RdiCaretListener(this);
        this.coverageMarkerMouseEventHandler = new CoverageMarkerMouseEventHandler(this.getRiderModel());
        this.logger$1.debug("Creating an editor reference for file: " + this.file.getPath());
        MemoryMapImageReceiver memoryMapImageReceiver = this.rdiMemoryMapImageReceiver = new MemoryMapImageReceiver(this.editorGuid + "-rdi-", 200000);
        if (memoryMapImageReceiver != null) {
            memoryMapImageReceiver.listenForNewImages((Function5<? super BufferedImage, ? super Integer, ? super Integer, ? super byte[], ? super Integer, Unit>)((Function5)new Function5<BufferedImage, Integer, Integer, byte[], Integer, Unit>((Object)this){

                public final void invoke(BufferedImage p0, int p1, int p2, byte[] p3, int p4) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                    ((EditorReference)this.receiver).rdiImageReceived(p0, p1, p2, p3, p4);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((EditorReference)this.receiver).noRdiImageAvailable();
                }
            }), sharedMemoryDispatcher);
        }
        MemoryMapImageReceiver memoryMapImageReceiver2 = this.markersMemoryMapImageReceiver = new MemoryMapImageReceiver(this.editorGuid + "-marker-", 10000);
        if (memoryMapImageReceiver2 != null) {
            memoryMapImageReceiver2.listenForNewImages((Function5<? super BufferedImage, ? super Integer, ? super Integer, ? super byte[], ? super Integer, Unit>)((Function5)new Function5<BufferedImage, Integer, Integer, byte[], Integer, Unit>((Object)this){

                public final void invoke(BufferedImage p0, int p1, int p2, byte[] p3, int p4) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                    ((EditorReference)this.receiver).markerImageReceived(p0, p1, p2, p3, p4);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((EditorReference)this.receiver).noMarkerImageAvailable();
                }
            }), sharedMemoryDispatcher);
        }
        Timer $this$_init__u24lambda_u242 = this.editorPropertiesChangeDetectorTimer = new Timer(500, arg_0 -> EditorReference._init_$lambda$1(this, arg_0));
        boolean bl = false;
        $this$_init__u24lambda_u242.setRepeats(true);
        $this$_init__u24lambda_u242.start();
        this.markerCurrentList = new ArrayList();
        this.rdiImageWriteCounter = new AtomicInteger(0);
        this.rdiImageWriteDirectory = new File("C:\\temp\\rdi");
        this.currentFont = "";
        this.currentYCoordinates = new double[0];
        this.currentInlayCoordinates = new InlayCoordinate[0];
        this.rdiHighlightRenderer = new RdiHighlightRenderer(this);
        this.rdiElementInfoList = new ArrayList();
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public final void setFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.file = virtualFile;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final UUID getEditorGuid() {
        return this.editorGuid;
    }

    public final boolean hasOpenEditors() {
        return this.getOpenEditorsForFile().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void registerTextEditor() {
        void $this$filterTo$iv$iv;
        this.logger$1.debug("Registering text editor for file: " + this.file.getPath());
        Iterable $this$filter$iv = this.getOpenEditorsForFile();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextEditor it = (TextEditor)element$iv$iv;
            boolean bl = false;
            if (!(!this.editors.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double currentLineHeight;
            TextEditor textEditor = (TextEditor)element$iv;
            boolean bl = false;
            Caret caret = textEditor.getEditor().getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Editor editor = textEditor.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            RdiCaretListener.Companion.sendCaretToNcrunch(caret, editor, this.editorGuid, this.getRiderModel());
            this.editors.add(textEditor);
            textEditor.getEditor().addEditorMouseMotionListener((EditorMouseMotionListener)this.coverageMarkerMouseEventHandler);
            textEditor.getEditor().addEditorMouseMotionListener((EditorMouseMotionListener)this.rdiMouseListener);
            textEditor.getEditor().addEditorMouseListener((EditorMouseListener)this.rdiMouseListener);
            textEditor.getEditor().getCaretModel().addCaretListener((CaretListener)this.rdiCaretListener);
            Editor editor2 = textEditor.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            this.lineHeight = currentLineHeight = this.getEditorLineHeight(editor2);
            this.sendEditorOpened(textEditor, currentLineHeight);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, textEditor, null){
                int label;
                final /* synthetic */ EditorReference this$0;
                final /* synthetic */ TextEditor $textEditor;
                {
                    this.this$0 = $receiver;
                    this.$textEditor = $textEditor;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)50L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = this.$textEditor.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getEditor(...)");
                            EditorReference.access$checkEditorPropertiesHaveChanged(this.this$0, v1);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this.logger$1.debug("Text editor registered for file: " + this.file.getPath());
        }
    }

    private final void noMarkerImageAvailable() {
        this.logger$1.warn("No RDI image available for file: " + this.file.getPath());
        this.closeRdiOverlay();
    }

    @Nullable
    public final BufferedImage getMarkerOverlayImage() {
        return this.markerOverlayImage;
    }

    public final void setMarkerOverlayImage(@Nullable BufferedImage bufferedImage) {
        this.markerOverlayImage = bufferedImage;
    }

    public final int getMarkerOverlayWidth() {
        return this.markerOverlayWidth;
    }

    public final void setMarkerOverlayWidth(int n) {
        this.markerOverlayWidth = n;
    }

    private final void markerImageReceived(BufferedImage bufferedImage, int width, int height, byte[] secondaryPayload, int secondaryPayloadSize) {
        this.markerOverlayImage = bufferedImage;
        this.markerOverlayWidth = width;
        this.markerCurrentList.clear();
        ByteBuffer bb = ByteBuffer.wrap(secondaryPayload);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        while (bb.position() < secondaryPayloadSize) {
            this.markerCurrentList.add(bb.getInt());
        }
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)(arg_0, arg_1) -> EditorReference.markerImageReceived$lambda$6(this, arg_0, arg_1)));
        this.redrawEditorGutter();
    }

    private final void noRdiImageAvailable() {
        this.closeRdiOverlay();
    }

    @Nullable
    public final BufferedImage getRdiOverlayImage() {
        return this.rdiOverlayImage;
    }

    public final void setRdiOverlayImage(@Nullable BufferedImage bufferedImage) {
        this.rdiOverlayImage = bufferedImage;
    }

    private final void writeRdiImageToFile(BufferedImage image) {
        this.rdiImageWriteDirectory.mkdirs();
        int counter = this.rdiImageWriteCounter.getAndIncrement();
        File outputFile = new File(this.rdiImageWriteDirectory, this.editorGuid + "_" + counter + ".png");
        ImageIO.write((RenderedImage)image, "png", outputFile);
    }

    private final void rdiImageReceived(BufferedImage bufferedImage, int width, int height, byte[] secondaryPayload, int secondaryPayloadSize) {
        this.rdiOverlayImage = bufferedImage;
        this.rdiOverlayWidth = width;
        this.rdiOverlayHeight = height;
        this.rdiElementInfoList.clear();
        ByteBuffer bb = ByteBuffer.wrap(secondaryPayload);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.rdiSplitRendering = bb.getInt() == 1;
        this.rdiSplitRenderingStart = bb.getDouble();
        this.rdiSplitRenderingEnd = bb.getDouble();
        while (bb.position() < secondaryPayloadSize) {
            double x = bb.getDouble();
            double y = bb.getDouble();
            double elementWidth = bb.getDouble();
            double elementHeight = bb.getDouble();
            boolean isHand = bb.getInt() == 1;
            boolean isCanvas = bb.getInt() == 1;
            int zIndex = bb.getInt();
            this.rdiElementInfoList.add(new RdiUIElementInfo(x, y, elementWidth, elementHeight, isHand, isCanvas, zIndex));
        }
        if (this.drawDiagnostics) {
            this.drawElementInfoOnImage();
            this.drawLastMouseEvents();
        }
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)(arg_0, arg_1) -> EditorReference.rdiImageReceived$lambda$7(this, arg_0, arg_1)));
    }

    private final void drawElementInfoOnImage() {
        BufferedImage bufferedImage = this.rdiOverlayImage;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setFont(new Font("Arial", 1, 12));
        for (RdiUIElementInfo element : this.rdiElementInfoList) {
            if (element.isHand()) {
                graphics.setColor(Color.BLUE);
            } else if (element.isCanvas()) {
                graphics.setColor(Color.YELLOW);
            } else {
                graphics.setColor(Color.WHITE);
            }
            graphics.drawRect((int)element.getX(), (int)element.getY(), (int)element.getWidth(), (int)element.getHeight());
            graphics.drawString(String.valueOf(element.getZIndex()), (int)element.getX(), (int)element.getY() + graphics.getFontMetrics().getAscent());
        }
        graphics.dispose();
    }

    public final void addRdiMouseEvent(@NotNull RdiMouseEventPoint mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        if (!this.drawDiagnostics) {
            return;
        }
        this.rdiMouseEventList.add(mouseEvent);
        this.drawLastMouseEvents();
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)(arg_0, arg_1) -> EditorReference.addRdiMouseEvent$lambda$8(this, arg_0, arg_1)));
    }

    private final void drawLastMouseEvents() {
        if (this.rdiOverlayImage == null) {
            return;
        }
        BufferedImage bufferedImage = this.rdiOverlayImage;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setColor(Color.RED);
        RdiMouseEventPoint previousEvent = null;
        int textYPosition = 15;
        Iterator iterator = this.rdiMouseEventList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            RdiMouseEventPoint currentEvent = (RdiMouseEventPoint)e;
            if (currentEvent.getSpecialCursor()) {
                graphics.setColor(Color.GREEN);
            } else if (currentEvent.getTransferredToNcrunch()) {
                graphics.setColor(Color.BLUE);
            } else {
                graphics.setColor(Color.RED);
            }
            graphics.fillOval(currentEvent.getX() - 5, currentEvent.getY() - 5, 10, 10);
            if (previousEvent != null) {
                graphics.drawLine(previousEvent.getX(), previousEvent.getY(), currentEvent.getX(), currentEvent.getY());
            }
            graphics.drawString("(" + currentEvent.getX() + "," + currentEvent.getY() + ")", 5, textYPosition);
            textYPosition += 15;
            previousEvent = currentEvent;
        }
        graphics.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextEditor> getOpenEditorsForFile() {
        void $this$mapNotNullTo$iv$iv;
        Project it = this.project;
        boolean bl = false;
        VirtualFile it2 = this.file;
        boolean bl2 = false;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors(it2);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            TextEditor it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl3 = false;
            FileEditor fileEditor = (FileEditor)element$iv$iv;
            boolean bl4 = false;
            if ((fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void runOnOpenEditors(Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit> functionToRun) {
        Iterable $this$forEach$iv = this.getOpenEditorsForFile();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            TextEditor it = (TextEditor)element$iv;
            boolean bl = false;
            RangeHighlighter[] rangeHighlighterArray = it.getEditor().getMarkupModel().getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
            Object[] $this$mapNotNull$iv = rangeHighlighterArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                RangeHighlighter it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                RangeHighlighter rangeHighlighter = (RangeHighlighter)element$iv$iv;
                boolean bl3 = false;
                if ((rangeHighlighter.getGutterIconRenderer() instanceof CoverageMarkerIcon ? rangeHighlighter : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List highlighters = (List)destination$iv$iv;
            functionToRun.invoke((Object)it, (Object)highlighters);
        }
    }

    public final void clearMarkers() {
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)EditorReference::clearMarkers$lambda$15));
    }

    private final void checkLineHeightChanged(TextEditor textEditor) {
        boolean lineHeightChanged;
        double currentLineHeight = (double)textEditor.getEditor().getLineHeight() * this.getScaleFactor();
        boolean bl = lineHeightChanged = !(this.lineHeight == currentLineHeight);
        if (lineHeightChanged) {
            this.lineHeight = currentLineHeight;
            IAsyncSignal<EditorLineHeightChangedEvent> iAsyncSignal = this.getRiderModel().getEditorLineHeightChanged();
            String string = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            iAsyncSignal.fire((Object)new EditorLineHeightChangedEvent(string, currentLineHeight));
        }
    }

    private final void sendEditorOpened(TextEditor textEditor, double currentLineHeight) {
        String newText = null;
        String string = textEditor.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        newText = string;
        String string2 = CodeStyle.getSettings((Project)this.project).getLineSeparator();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"\r\n")) {
                newText = StringsKt.replace$default((String)newText, (String)"\n", (String)"\r\n", (boolean)false, (int)4, null);
            }
        }
        IAsyncSignal<EditorOpenedEvent> iAsyncSignal = this.getRiderModel().getEditorOpened();
        String string3 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        iAsyncSignal.fire((Object)new EditorOpenedEvent(string3, newText, currentLineHeight, this.editorGuid));
    }

    private final NCrunchForRiderModel getRiderModel() {
        return NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterTextEditor() {
        void $this$filterTo$iv$iv;
        this.logger$1.debug("Unregistering text editor for file: " + this.file.getPath());
        Iterable $this$filter$iv = this.editors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextEditor it = (TextEditor)element$iv$iv;
            boolean bl = false;
            if (!this.getOpenEditorsForFile().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextEditor editorToUnregister = (TextEditor)element$iv;
            boolean bl = false;
            this.editors.remove(editorToUnregister);
        }
        if (this.hasOpenEditors()) {
            MemoryMapImageReceiver memoryMapImageReceiver = this.rdiMemoryMapImageReceiver;
            if (memoryMapImageReceiver != null) {
                memoryMapImageReceiver.close();
            }
            MemoryMapImageReceiver memoryMapImageReceiver2 = this.markersMemoryMapImageReceiver;
            if (memoryMapImageReceiver2 != null) {
                memoryMapImageReceiver2.close();
            }
            this.editorPropertiesChangeDetectorTimer.stop();
        }
    }

    private final void redrawEditorGutter() {
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)EditorReference::redrawEditorGutter$lambda$19));
    }

    private final double getEditorLineHeight(Editor editor) {
        return (double)editor.getLineHeight() * this.getScaleFactor();
    }

    private final int getTabSize(Editor editor) {
        return editor.getSettings().getTabSize(editor.getProject());
    }

    private final double[] generateTextCoordinates() {
        TextEditor textEditor = (TextEditor)CollectionsKt.firstOrNull(this.getOpenEditorsForFile());
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
            return new double[0];
        }
        TextEditor firstEditor = textEditor;
        Document document = firstEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int batchSize = 10;
        int currentLineHeight = firstEditor.getLineHeight();
        double[] result = new double[document2.getLineCount()];
        int lineNumber = 1;
        while (lineNumber < document2.getLineCount()) {
            double actualY;
            int lastLineIndexInBatch;
            int batchEnd;
            Number expectedY = lineNumber > 0 ? (Number)(result[lineNumber - 1] + (double)((batchEnd - lineNumber) * currentLineHeight)) : (Number)(lastLineIndexInBatch * currentLineHeight);
            if (Intrinsics.areEqual((Object)expectedY, (Object)(actualY = firstEditor.offsetToXY(document2.getLineStartOffset(lastLineIndexInBatch = (batchEnd = Math.min(lineNumber + batchSize, document2.getLineCount())) - 1)).getY()))) {
                for (batchLineNumber = lineNumber; batchLineNumber < batchEnd; ++batchLineNumber) {
                    result[batchLineNumber] = batchLineNumber == 0 ? 0.0 : result[batchLineNumber - 1] + (double)currentLineHeight;
                }
            } else {
                for (batchLineNumber = lineNumber; batchLineNumber < batchEnd; ++batchLineNumber) {
                    result[batchLineNumber] = firstEditor.offsetToXY(document2.getLineStartOffset(batchLineNumber)).getY();
                }
            }
            lineNumber = batchEnd;
        }
        return result;
    }

    private final void checkEditorPropertiesHaveChanged(Editor editor) {
        String font = this.getEditorFont(editor);
        int backGroundColor = this.getEditorBackGroundColor(editor);
        double viewPortWidth = this.getEditorViewPortWidth(editor);
        double viewPortHeight = this.getEditorViewPortHeight(editor);
        int scrollPosition = this.currentScrollPosition(editor);
        double charWidth = this.getEditorCharWidth(editor);
        double fontSize = this.getEditorFontSize(editor);
        double lineHeight = this.getEditorLineHeight(editor);
        double[] yCoordinates = this.generateTextCoordinates();
        Object[] inlayCoordinates = this.generateInlayCoordinates(editor);
        int xOffSet = 0;
        int yOffSet = 0;
        int tabSize = this.getTabSize(editor);
        long windowHandle = this.currentWindowHandle;
        if (windowHandle == 0L) {
            windowHandle = this.getEditorWindowHandle(editor);
        }
        double scaleFactor = this.getScaleFactor();
        if (editor.getComponent().isShowing()) {
            try {
                int n = editor.getComponent().getLocationOnScreen().x;
                EditorGutter editorGutter = editor.getGutter();
                Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                xOffSet = n + ((JComponent)editorGutter).getWidth() - editor.getScrollingModel().getHorizontalScrollOffset();
                yOffSet = editor.getComponent().getLocationOnScreen().y - editor.getScrollingModel().getVerticalScrollOffset();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (!(Intrinsics.areEqual((Object)font, (Object)this.currentFont) && backGroundColor == this.currentBackGroundColor && viewPortWidth == this.currentViewPortWidth && viewPortHeight == this.currentViewPortHeight && scrollPosition == this.currentScrollPosition && charWidth == this.currentCharWidth && lineHeight == this.currentLineHeight && fontSize == this.currentFontSize && Arrays.equals(yCoordinates, this.currentYCoordinates) && Arrays.equals(inlayCoordinates, this.currentInlayCoordinates) && xOffSet == this.currentXOffSet && yOffSet == this.currentYOffSet && tabSize == this.currentTabSize && windowHandle == this.currentWindowHandle && scaleFactor == this.currentScalingFactor)) {
            this.currentFont = font;
            this.currentBackGroundColor = backGroundColor;
            this.currentViewPortWidth = viewPortWidth;
            this.currentViewPortHeight = viewPortHeight;
            this.currentCharWidth = charWidth;
            this.currentFontSize = fontSize;
            this.currentLineHeight = lineHeight;
            this.currentYCoordinates = yCoordinates;
            this.currentInlayCoordinates = inlayCoordinates;
            this.currentXOffSet = xOffSet;
            this.currentYOffSet = yOffSet;
            this.currentTabSize = tabSize;
            this.currentWindowHandle = windowHandle;
            this.currentScrollPosition = scrollPosition;
            this.currentScalingFactor = scaleFactor;
            this.resetRdiHighlightRenderer = true;
            this.sendCurrentEditorStateToNCrunch();
        }
    }

    private final InlayCoordinate[] generateInlayCoordinates(Editor editor) {
        List list = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
        List inlays = list;
        List result = new ArrayList();
        Iterable $this$forEach$iv = inlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogicalPosition offsetToLogicalPosition;
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(it.getOffset()), (String)"offsetToLogicalPosition(...)");
            int line = offsetToLogicalPosition.line;
            int column = offsetToLogicalPosition.column;
            int widthInPixels = it.getWidthInPixels();
            result.add(new InlayCoordinate(line, column, widthInPixels));
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new InlayCoordinate[0]);
    }

    private final int currentScrollPosition(Editor editor) {
        return editor.getScrollingModel().getVerticalScrollOffset();
    }

    private final long getEditorWindowHandle(Editor editor) {
        Window window = SwingUtilities.getWindowAncestor(editor.getComponent());
        if (editor.getComponent().isShowing()) {
            try {
                if (window != null && window instanceof JFrame && !Intrinsics.areEqual((Object)((JFrame)window).getTitle(), (Object)"")) {
                    Pointer pointer = Win32.INSTANCE.getUser32().FindWindow(null, ((JFrame)window).getTitle()).getPointer();
                    Pointer.nativeValue((Pointer)pointer);
                    Intrinsics.checkNotNull((Object)pointer);
                    this.integrationService.registerWindowHandle(pointer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return Pointer.nativeValue((Pointer)Win32.INSTANCE.getUser32().FindWindow(null, "").getPointer());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public final void sendCurrentEditorStateToNCrunch() {
        if (Intrinsics.areEqual((Object)this.currentFont, (Object)"") || this.currentFontSize == 0.0 || this.currentCharWidth == 0.0 || this.currentLineHeight == 0.0) {
            return;
        }
        this.logger$1.info("Sending current editor state to NCrunch");
        EditorInformationProvided editorInfo = new EditorInformationProvided(this.editorGuid, this.currentFont, this.currentFontSize, this.currentCharWidth, this.currentLineHeight, this.currentViewPortWidth, this.currentViewPortHeight, this.currentBackGroundColor, this.currentYCoordinates, this.currentXOffSet, this.currentYOffSet, this.currentTabSize, this.currentWindowHandle, this.currentScalingFactor, this.currentScrollPosition, this.currentInlayCoordinates);
        this.getRiderModel().getSendEditorInformation().fire((Object)editorInfo);
    }

    private final int getEditorBackGroundColor(Editor editor) {
        Color color = editor.getComponent().getBackground();
        return color != null ? color.getRGB() : editor.getColorsScheme().getDefaultBackground().getRGB();
    }

    private final double getEditorViewPortWidth(Editor editor) {
        return (double)editor.getScrollingModel().getVisibleArea().width + (double)editor.getScrollingModel().getHorizontalScrollOffset();
    }

    private final double getEditorViewPortHeight(Editor editor) {
        return editor.getScrollingModel().getVisibleArea().height;
    }

    private final double getEditorCharWidth(Editor editor) {
        return editor.getComponent().getFontMetrics(editor.getColorsScheme().getFont(EditorFontType.PLAIN)).charWidth('m');
    }

    private final double getEditorFontSize(Editor editor) {
        return editor.getColorsScheme().getEditorFontSize();
    }

    private final String getEditorFont(Editor editor) {
        String string = editor.getColorsScheme().getEditorFontName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEditorFontName(...)");
        return string;
    }

    private final void setupOrInvalidateRdiHighlighter(TextEditor editor) {
        RangeHighlighter rdiHighlighterForEditor = this.getRdiHighlighterForEditor(editor);
        if (rdiHighlighterForEditor == null || this.resetRdiHighlightRenderer) {
            if (rdiHighlighterForEditor != null) {
                editor.getEditor().getMarkupModel().removeHighlighter(rdiHighlighterForEditor);
            }
            this.resetRdiHighlightRenderer = false;
            int lineStartOffset = editor.getEditor().getDocument().getLineStartOffset(0);
            int lineEndOffset = editor.getEditor().getDocument().getLineEndOffset(editor.getEditor().getDocument().getLineCount() - 1);
            rdiHighlighterForEditor = editor.getEditor().getMarkupModel().addRangeHighlighter(lineStartOffset, lineEndOffset, 7001, null, HighlighterTargetArea.LINES_IN_RANGE);
            rdiHighlighterForEditor.setCustomRenderer((CustomHighlighterRenderer)this.rdiHighlightRenderer);
        }
        editor.getComponent().invalidate();
        editor.getComponent().repaint();
    }

    private final RangeHighlighter getRdiHighlighterForEditor(TextEditor editor) {
        Object object;
        block1: {
            RangeHighlighter[] rangeHighlighterArray = editor.getEditor().getMarkupModel().getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
            Object[] $this$firstOrNull$iv = rangeHighlighterArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!(it.getCustomRenderer() != null && Intrinsics.areEqual((Object)it.getCustomRenderer(), (Object)this.rdiHighlightRenderer))) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (RangeHighlighter)object;
    }

    public final boolean getRdiOverlayActive() {
        return this.rdiOverlayActive;
    }

    public final void setRdiOverlayActive(boolean bl) {
        this.rdiOverlayActive = bl;
    }

    @NotNull
    public final List<RdiUIElementInfo> getRdiElementInfoList() {
        return this.rdiElementInfoList;
    }

    public final void setRdiElementInfoList(@NotNull List<RdiUIElementInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.rdiElementInfoList = list;
    }

    public final boolean getRdiSplitRendering() {
        return this.rdiSplitRendering;
    }

    public final void setRdiSplitRendering(boolean bl) {
        this.rdiSplitRendering = bl;
    }

    public final double getRdiSplitRenderingStart() {
        return this.rdiSplitRenderingStart;
    }

    public final void setRdiSplitRenderingStart(double d) {
        this.rdiSplitRenderingStart = d;
    }

    public final void closeRdiOverlay() {
        this.rdiOverlayActive = false;
        this.rdiElementInfoList.clear();
        this.runOnOpenEditors((Function2<? super TextEditor, ? super List<? extends RangeHighlighter>, Unit>)((Function2)(arg_0, arg_1) -> EditorReference.closeRdiOverlay$lambda$23(this, arg_0, arg_1)));
    }

    public final void openRdiOverlay() {
        this.rdiOverlayActive = true;
        this.sendCurrentEditorStateToNCrunch();
    }

    public final double getScaleFactor() {
        Object object = (TextEditor)CollectionsKt.firstOrNull(this.getOpenEditorsForFile());
        if (object == null || (object = object.getEditor()) == null || (object = object.getComponent()) == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            return 1.0;
        }
        Object graphicsConfiguration = object;
        return JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration);
    }

    public final void markAsForeground() {
        block2: {
            if (this.isForeGround) {
                return;
            }
            this.isForeGround = true;
            this.logger$1.debug("EditorReference: " + this.file + " has been marked as foreground");
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getEditorIsForeground().fire((Object)this.editorGuid);
            MemoryMapImageReceiver memoryMapImageReceiver = this.rdiMemoryMapImageReceiver;
            if (memoryMapImageReceiver != null) {
                memoryMapImageReceiver.startReceivingImages();
            }
            MemoryMapImageReceiver memoryMapImageReceiver2 = this.markersMemoryMapImageReceiver;
            if (memoryMapImageReceiver2 == null) break block2;
            memoryMapImageReceiver2.startReceivingImages();
        }
    }

    public final void markAsBackground() {
        block2: {
            if (!this.isForeGround) {
                return;
            }
            this.isForeGround = false;
            this.logger$1.debug("EditorReference: " + this.file + " has been marked as background");
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getEditorIsBackground().fire((Object)this.editorGuid);
            MemoryMapImageReceiver memoryMapImageReceiver = this.rdiMemoryMapImageReceiver;
            if (memoryMapImageReceiver != null) {
                memoryMapImageReceiver.stopReceivingImages();
            }
            MemoryMapImageReceiver memoryMapImageReceiver2 = this.markersMemoryMapImageReceiver;
            if (memoryMapImageReceiver2 == null) break block2;
            memoryMapImageReceiver2.stopReceivingImages();
        }
    }

    private static final void _init_$lambda$1(EditorReference this$0, ActionEvent it) {
        if (!this$0.isForeGround) {
            return;
        }
        try {
            TextEditor textEditor = (TextEditor)CollectionsKt.firstOrNull(this$0.getOpenEditorsForFile());
            if (textEditor != null) {
                TextEditor textEditor2 = textEditor;
                boolean bl = false;
                this$0.checkLineHeightChanged(textEditor2);
                Editor editor = textEditor2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                this$0.checkEditorPropertiesHaveChanged(editor);
            }
        }
        catch (Exception e) {
            this$0.logger$1.error("Exception during checking if editor properties have changed: " + e);
        }
    }

    private static final Unit markerImageReceived$lambda$6(EditorReference this$0, TextEditor editor, List highlighters) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighters, (String)"highlighters");
        List markerCurrentListForEditor = (List)IRdBindableKt.deepClonePolymorphic(this$0.markerCurrentList);
        MarkupModel markupModel = editor.getEditor().getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        String string = this$0.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return Unit.INSTANCE;
        }
        for (RangeHighlighter highlighter : highlighters) {
            if (!(highlighter.getGutterIconRenderer() instanceof CoverageMarkerIcon) || this$0.document.getTextLength() < highlighter.getStartOffset()) continue;
            int lineNumber = this$0.document.getLineNumber(highlighter.getStartOffset());
            int lineKey = lineNumber + 1;
            if (markerCurrentListForEditor.contains(lineKey)) {
                GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
                if (renderer instanceof CoverageMarkerIcon) {
                    ((CoverageMarkerIcon)renderer).setLine(lineKey);
                    ((CoverageMarkerIcon)renderer).setLineHeight(this$0.lineHeight);
                }
                markerCurrentListForEditor.remove((Object)lineKey);
                continue;
            }
            markupModel2.removeHighlighter(highlighter);
        }
        Iterable $this$forEach$iv = markerCurrentListForEditor;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter highlighter;
            int lineKey = ((Number)element$iv).intValue();
            boolean bl = false;
            int maxLine = this$0.document.getLineCount();
            boolean bl2 = 1 <= lineKey ? lineKey <= maxLine : false;
            if (!bl2) continue;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getEditor().getMarkupModel().addLineHighlighter(lineKey - 1, 6000, null), (String)"addLineHighlighter(...)");
            Object object = editor.getFile();
            if (object == null || (object = object.getPath()) == null) {
                object = "";
            }
            Editor editor2 = editor.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            highlighter.setGutterIconRenderer((GutterIconRenderer)new CoverageMarkerIcon(lineKey, (String)object, this$0.getEditorLineHeight(editor2), this$0.coverageMarkerMouseEventHandler, this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit rdiImageReceived$lambda$7(EditorReference this$0, TextEditor editor, List list) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        this$0.setupOrInvalidateRdiHighlighter(editor);
        return Unit.INSTANCE;
    }

    private static final Unit addRdiMouseEvent$lambda$8(EditorReference this$0, TextEditor editor, List list) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        this$0.setupOrInvalidateRdiHighlighter(editor);
        return Unit.INSTANCE;
    }

    private static final Unit clearMarkers$lambda$15(TextEditor editor, List highlighters) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighters, (String)"highlighters");
        Iterable $this$forEach$iv = highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            editor.getEditor().getMarkupModel().removeHighlighter(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit redrawEditorGutter$lambda$19(TextEditor editor, List list) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        EditorGutter editorGutter = editor.getEditor().getGutter();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutter, (String)"getGutter(...)");
        EditorGutter gutter = editorGutter;
        if (gutter instanceof EditorGutterComponentEx) {
            ((EditorGutterComponentEx)gutter).invalidate();
            ((EditorGutterComponentEx)gutter).repaint();
        }
        return Unit.INSTANCE;
    }

    private static final Unit closeRdiOverlay$lambda$23(EditorReference this$0, TextEditor editor, List list) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
            RangeHighlighter rangeHighlighter = this$0.getRdiHighlighterForEditor(editor);
            if (rangeHighlighter == null) break block0;
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            editor.getEditor().getMarkupModel().removeHighlighter(it);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$checkEditorPropertiesHaveChanged(EditorReference $this, Editor editor) {
        $this.checkEditorPropertiesHaveChanged(editor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorReference.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EditorReference.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/remco/software/ncrunch/editor/EditorReference$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "jumpInEditor", "", "line", "", "column", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "ncrunchforrider"})
    public static final class Companion {
        private Companion() {
        }

        public final void jumpInEditor(int line, int column, @Nullable TextEditor textEditor) {
            block0: {
                TextEditor textEditor2 = textEditor;
                if (textEditor2 == null) break block0;
                TextEditor $this$jumpInEditor_u24lambda_u240 = textEditor2;
                boolean bl = false;
                $this$jumpInEditor_u24lambda_u240.getEditor().getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
                $this$jumpInEditor_u24lambda_u240.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                logger.info("RDI: jumpInEditor");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

