/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.model.ToolWindowScalingChanged;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\b\u0010\u0013\u001a\u00020\fH\u0016J.\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J.\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "entries", "", "Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentEntry;", "addComponentToCheck", "", "componentToMonitor", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "dispose", "handleGraphicsConfigurationChanged", "component", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "applyNewScaling", "ComponentEntry", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nComponentScalingMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n15#2:137\n1#3:138\n1863#4,2:139\n295#4,2:141\n*S KotlinDebug\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n*L\n18#1:137\n77#1:139,2\n91#1:141,2\n*E\n"})
public final class ComponentScalingMonitor
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<ComponentEntry> entries;

    public ComponentScalingMonitor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentScalingMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.entries = new ArrayList();
    }

    public final void addComponentToCheck(@NotNull Component componentToMonitor, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange) {
        double d;
        GraphicsConfiguration initialGc;
        Intrinsics.checkNotNullParameter((Object)componentToMonitor, (String)"componentToMonitor");
        Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
        Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
        PropertyChangeListener listener = arg_0 -> ComponentScalingMonitor.addComponentToCheck$lambda$0(componentToMonitor, this, windowName, postScalingChange, arg_0);
        componentToMonitor.addPropertyChangeListener("graphicsConfiguration", listener);
        GraphicsConfiguration graphicsConfiguration = initialGc = componentToMonitor.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            GraphicsConfiguration it = graphicsConfiguration;
            boolean bl = false;
            d = JBUIScale.pixScale((GraphicsConfiguration)it);
        } else {
            d = Double.NaN;
        }
        double initialScale = d;
        GraphicsConfiguration graphicsConfiguration2 = initialGc;
        GraphicsDevice initialDevice = graphicsConfiguration2 != null ? graphicsConfiguration2.getDevice() : null;
        ComponentEntry entry = new ComponentEntry(componentToMonitor, windowName, postScalingChange, initialDevice, initialScale, listener);
        ((Collection)this.entries).add(entry);
        if (initialGc != null && !Double.isNaN(initialScale)) {
            this.applyNewScaling(windowName, initialGc, componentToMonitor, postScalingChange);
            GraphicsDevice graphicsDevice = initialDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") initial scaling applied: " + initialScale + " on " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null));
        }
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ComponentEntry entry = (ComponentEntry)element$iv;
            boolean bl = false;
            try {
                boolean bl2 = false;
                entry.getComponent().removePropertyChangeListener("graphicsConfiguration", entry.getGcListener());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this.entries.clear();
    }

    private final void handleGraphicsConfigurationChanged(Component component, String windowName, GraphicsConfiguration graphicsConfiguration, Function0<Unit> postScalingChange) {
        boolean scaleChanged;
        Object v0;
        block7: {
            Iterable $this$firstOrNull$iv = this.entries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ComponentEntry it = (ComponentEntry)element$iv;
                boolean bl = false;
                if (!(it.getComponent() == component)) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        ComponentEntry componentEntry = v0;
        if (componentEntry == null) {
            return;
        }
        ComponentEntry entry = componentEntry;
        GraphicsDevice currentDevice = graphicsConfiguration.getDevice();
        double currentScale = JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration);
        boolean deviceChanged = entry.getLastDevice() != currentDevice;
        boolean bl = scaleChanged = !(currentScale == entry.getLastScale());
        if (!deviceChanged && !scaleChanged) {
            return;
        }
        entry.setLastDevice(currentDevice);
        entry.setLastScale(currentScale);
        this.applyNewScaling(windowName, graphicsConfiguration, component, postScalingChange);
        if (deviceChanged && scaleChanged) {
            GraphicsDevice graphicsDevice = currentDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") moved to " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + " and scaling changed to " + currentScale);
        } else if (deviceChanged) {
            GraphicsDevice graphicsDevice = currentDevice;
            this.logger.info("NCrunch tool window (" + windowName + ") moved to " + (graphicsDevice != null ? graphicsDevice.getIDstring() : null) + " (scale " + currentScale + ")");
        } else {
            this.logger.info("NCrunch tool window (" + windowName + ") scaling changed to " + currentScale);
        }
    }

    private final void applyNewScaling(String windowName, GraphicsConfiguration graphicsConfiguration, Component component, Function0<Unit> postScalingChange) {
        double scale = JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration);
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getScalingChangedForToolWindow().fire((Object)new ToolWindowScalingChanged(windowName, scale, component.getWidth(), component.getHeight()));
        postScalingChange.invoke();
    }

    private static final void addComponentToCheck$lambda$0(Component $componentToMonitor, ComponentScalingMonitor this$0, String $windowName, Function0 $postScalingChange, PropertyChangeEvent evt) {
        if (!Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"graphicsConfiguration")) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = $componentToMonitor.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        GraphicsConfiguration newGc = graphicsConfiguration;
        this$0.handleGraphicsConfigurationChanged($componentToMonitor, $windowName, newGc, (Function0<Unit>)$postScalingChange);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003JM\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentEntry;", "", "component", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "", "lastDevice", "Ljava/awt/GraphicsDevice;", "lastScale", "", "gcListener", "Ljava/beans/PropertyChangeListener;", "<init>", "(Ljava/awt/Component;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/awt/GraphicsDevice;DLjava/beans/PropertyChangeListener;)V", "getComponent", "()Ljava/awt/Component;", "getWindowName", "()Ljava/lang/String;", "getPostScalingChange", "()Lkotlin/jvm/functions/Function0;", "getLastDevice", "()Ljava/awt/GraphicsDevice;", "setLastDevice", "(Ljava/awt/GraphicsDevice;)V", "getLastScale", "()D", "setLastScale", "(D)V", "getGcListener", "()Ljava/beans/PropertyChangeListener;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "ncrunchforrider"})
    private static final class ComponentEntry {
        @NotNull
        private final Component component;
        @NotNull
        private final String windowName;
        @NotNull
        private final Function0<Unit> postScalingChange;
        @Nullable
        private GraphicsDevice lastDevice;
        private double lastScale;
        @NotNull
        private final PropertyChangeListener gcListener;

        public ComponentEntry(@NotNull Component component, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice lastDevice, double lastScale, @NotNull PropertyChangeListener gcListener) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            Intrinsics.checkNotNullParameter((Object)gcListener, (String)"gcListener");
            this.component = component;
            this.windowName = windowName;
            this.postScalingChange = postScalingChange;
            this.lastDevice = lastDevice;
            this.lastScale = lastScale;
            this.gcListener = gcListener;
        }

        public /* synthetic */ ComponentEntry(Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, PropertyChangeListener propertyChangeListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                graphicsDevice = null;
            }
            if ((n & 0x10) != 0) {
                d = Double.NaN;
            }
            this(component, string, (Function0<Unit>)function0, graphicsDevice, d, propertyChangeListener);
        }

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @NotNull
        public final String getWindowName() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> getPostScalingChange() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice getLastDevice() {
            return this.lastDevice;
        }

        public final void setLastDevice(@Nullable GraphicsDevice graphicsDevice) {
            this.lastDevice = graphicsDevice;
        }

        public final double getLastScale() {
            return this.lastScale;
        }

        public final void setLastScale(double d) {
            this.lastScale = d;
        }

        @NotNull
        public final PropertyChangeListener getGcListener() {
            return this.gcListener;
        }

        @NotNull
        public final Component component1() {
            return this.component;
        }

        @NotNull
        public final String component2() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> component3() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice component4() {
            return this.lastDevice;
        }

        public final double component5() {
            return this.lastScale;
        }

        @NotNull
        public final PropertyChangeListener component6() {
            return this.gcListener;
        }

        @NotNull
        public final ComponentEntry copy(@NotNull Component component, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice lastDevice, double lastScale, @NotNull PropertyChangeListener gcListener) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            Intrinsics.checkNotNullParameter((Object)gcListener, (String)"gcListener");
            return new ComponentEntry(component, windowName, postScalingChange, lastDevice, lastScale, gcListener);
        }

        public static /* synthetic */ ComponentEntry copy$default(ComponentEntry componentEntry, Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, PropertyChangeListener propertyChangeListener, int n, Object object) {
            if ((n & 1) != 0) {
                component = componentEntry.component;
            }
            if ((n & 2) != 0) {
                string = componentEntry.windowName;
            }
            if ((n & 4) != 0) {
                function0 = componentEntry.postScalingChange;
            }
            if ((n & 8) != 0) {
                graphicsDevice = componentEntry.lastDevice;
            }
            if ((n & 0x10) != 0) {
                d = componentEntry.lastScale;
            }
            if ((n & 0x20) != 0) {
                propertyChangeListener = componentEntry.gcListener;
            }
            return componentEntry.copy(component, string, function0, graphicsDevice, d, propertyChangeListener);
        }

        @NotNull
        public String toString() {
            return "ComponentEntry(component=" + this.component + ", windowName=" + this.windowName + ", postScalingChange=" + this.postScalingChange + ", lastDevice=" + this.lastDevice + ", lastScale=" + this.lastScale + ", gcListener=" + this.gcListener + ")";
        }

        public int hashCode() {
            int result = this.component.hashCode();
            result = result * 31 + this.windowName.hashCode();
            result = result * 31 + this.postScalingChange.hashCode();
            result = result * 31 + (this.lastDevice == null ? 0 : this.lastDevice.hashCode());
            result = result * 31 + Double.hashCode(this.lastScale);
            result = result * 31 + this.gcListener.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentEntry)) {
                return false;
            }
            ComponentEntry componentEntry = (ComponentEntry)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)componentEntry.component)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.windowName, (Object)componentEntry.windowName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.postScalingChange, componentEntry.postScalingChange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastDevice, (Object)componentEntry.lastDevice)) {
                return false;
            }
            if (Double.compare(this.lastScale, componentEntry.lastScale) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.gcListener, (Object)componentEntry.gcListener);
        }
    }
}

