/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.model.ToolWindowScalingChanged;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J6\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "checkMonitorTimer", "Ljavax/swing/Timer;", "dispose", "", "componentsToMonitor", "", "Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentData;", "addComponentToCheck", "componentToMonitor", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "doCheck", "componentData", "applyNewScaling", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "ComponentData", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nComponentScalingMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n15#2:92\n1863#3,2:93\n*S KotlinDebug\n*F\n+ 1 ComponentScalingMonitor.kt\ncom/remco/software/ncrunch/ComponentScalingMonitor\n*L\n18#1:92\n29#1:93,2\n*E\n"})
public final class ComponentScalingMonitor
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private Timer checkMonitorTimer;
    @NotNull
    private final List<ComponentData> componentsToMonitor;

    public ComponentScalingMonitor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentScalingMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.checkMonitorTimer = new Timer(1000, arg_0 -> ComponentScalingMonitor.checkMonitorTimer$lambda$1(this, arg_0));
        this.componentsToMonitor = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
        this.checkMonitorTimer.stop();
    }

    public final void addComponentToCheck(@NotNull Component componentToMonitor, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange) {
        Intrinsics.checkNotNullParameter((Object)componentToMonitor, (String)"componentToMonitor");
        Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
        Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
        if (this.componentsToMonitor.isEmpty()) {
            this.checkMonitorTimer.start();
        }
        this.componentsToMonitor.add(new ComponentData(componentToMonitor, windowName, postScalingChange, null, 0.0, 24, null));
    }

    private final void doCheck(ComponentData componentData) {
        GraphicsConfiguration graphicsConfiguration = componentData.getComponentToMonitor().getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        GraphicsConfiguration componentGraphicsConfig = graphicsConfiguration;
        GraphicsDevice currentDevice = componentGraphicsConfig.getDevice();
        double currentScaling = JBUIScale.pixScale((GraphicsConfiguration)componentGraphicsConfig);
        if (!(currentScaling == componentData.getPreviousScaling())) {
            componentData.setPreviousScaling(currentScaling);
            this.applyNewScaling(this.project, componentData.getWindowName(), componentGraphicsConfig, componentData.getComponentToMonitor(), componentData.getPostScalingChange());
            this.logger.info("NCrunch tool window (" + componentData.getWindowName() + ") scaling was changed scaling is " + currentScaling);
        } else if (componentData.getPreviousGraphicsDevice() == null) {
            componentData.setPreviousGraphicsDevice(currentDevice);
        } else if (!Intrinsics.areEqual((Object)componentData.getPreviousGraphicsDevice(), (Object)currentDevice)) {
            componentData.setPreviousGraphicsDevice(currentDevice);
            if (currentDevice != null) {
                componentData.setPreviousScaling(currentScaling);
                this.applyNewScaling(this.project, componentData.getWindowName(), componentGraphicsConfig, componentData.getComponentToMonitor(), componentData.getPostScalingChange());
                this.logger.info("NCrunch tool window (" + componentData.getWindowName() + ") was moved to " + currentDevice.getIDstring() + " scaling is " + currentScaling);
            }
        }
    }

    private final void applyNewScaling(Project project, String windowName, GraphicsConfiguration graphicsConfiguration, Component componentToMonitor, Function0<Unit> postScalingChange) {
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getScalingChangedForToolWindow().fire((Object)new ToolWindowScalingChanged(windowName, JBUIScale.pixScale((GraphicsConfiguration)graphicsConfiguration), componentToMonitor.getWidth(), componentToMonitor.getHeight()));
        postScalingChange.invoke();
    }

    private static final void checkMonitorTimer$lambda$1(ComponentScalingMonitor this$0, ActionEvent it) {
        Iterable $this$forEach$iv = this$0.componentsToMonitor;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentData it2 = (ComponentData)element$iv;
            boolean bl = false;
            this$0.doCheck(it2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/remco/software/ncrunch/ComponentScalingMonitor$ComponentData;", "", "componentToMonitor", "Ljava/awt/Component;", "windowName", "", "postScalingChange", "Lkotlin/Function0;", "", "previousGraphicsDevice", "Ljava/awt/GraphicsDevice;", "previousScaling", "", "<init>", "(Ljava/awt/Component;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/awt/GraphicsDevice;D)V", "getComponentToMonitor", "()Ljava/awt/Component;", "getWindowName", "()Ljava/lang/String;", "getPostScalingChange", "()Lkotlin/jvm/functions/Function0;", "getPreviousGraphicsDevice", "()Ljava/awt/GraphicsDevice;", "setPreviousGraphicsDevice", "(Ljava/awt/GraphicsDevice;)V", "getPreviousScaling", "()D", "setPreviousScaling", "(D)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "ncrunchforrider"})
    public static final class ComponentData {
        @NotNull
        private final Component componentToMonitor;
        @NotNull
        private final String windowName;
        @NotNull
        private final Function0<Unit> postScalingChange;
        @Nullable
        private GraphicsDevice previousGraphicsDevice;
        private double previousScaling;

        public ComponentData(@NotNull Component componentToMonitor, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice previousGraphicsDevice, double previousScaling) {
            Intrinsics.checkNotNullParameter((Object)componentToMonitor, (String)"componentToMonitor");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            this.componentToMonitor = componentToMonitor;
            this.windowName = windowName;
            this.postScalingChange = postScalingChange;
            this.previousGraphicsDevice = previousGraphicsDevice;
            this.previousScaling = previousScaling;
        }

        public /* synthetic */ ComponentData(Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                graphicsDevice = null;
            }
            if ((n & 0x10) != 0) {
                d = 0.0;
            }
            this(component, string, (Function0<Unit>)function0, graphicsDevice, d);
        }

        @NotNull
        public final Component getComponentToMonitor() {
            return this.componentToMonitor;
        }

        @NotNull
        public final String getWindowName() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> getPostScalingChange() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice getPreviousGraphicsDevice() {
            return this.previousGraphicsDevice;
        }

        public final void setPreviousGraphicsDevice(@Nullable GraphicsDevice graphicsDevice) {
            this.previousGraphicsDevice = graphicsDevice;
        }

        public final double getPreviousScaling() {
            return this.previousScaling;
        }

        public final void setPreviousScaling(double d) {
            this.previousScaling = d;
        }

        @NotNull
        public final Component component1() {
            return this.componentToMonitor;
        }

        @NotNull
        public final String component2() {
            return this.windowName;
        }

        @NotNull
        public final Function0<Unit> component3() {
            return this.postScalingChange;
        }

        @Nullable
        public final GraphicsDevice component4() {
            return this.previousGraphicsDevice;
        }

        public final double component5() {
            return this.previousScaling;
        }

        @NotNull
        public final ComponentData copy(@NotNull Component componentToMonitor, @NotNull String windowName, @NotNull Function0<Unit> postScalingChange, @Nullable GraphicsDevice previousGraphicsDevice, double previousScaling) {
            Intrinsics.checkNotNullParameter((Object)componentToMonitor, (String)"componentToMonitor");
            Intrinsics.checkNotNullParameter((Object)windowName, (String)"windowName");
            Intrinsics.checkNotNullParameter(postScalingChange, (String)"postScalingChange");
            return new ComponentData(componentToMonitor, windowName, postScalingChange, previousGraphicsDevice, previousScaling);
        }

        public static /* synthetic */ ComponentData copy$default(ComponentData componentData, Component component, String string, Function0 function0, GraphicsDevice graphicsDevice, double d, int n, Object object) {
            if ((n & 1) != 0) {
                component = componentData.componentToMonitor;
            }
            if ((n & 2) != 0) {
                string = componentData.windowName;
            }
            if ((n & 4) != 0) {
                function0 = componentData.postScalingChange;
            }
            if ((n & 8) != 0) {
                graphicsDevice = componentData.previousGraphicsDevice;
            }
            if ((n & 0x10) != 0) {
                d = componentData.previousScaling;
            }
            return componentData.copy(component, string, function0, graphicsDevice, d);
        }

        @NotNull
        public String toString() {
            return "ComponentData(componentToMonitor=" + this.componentToMonitor + ", windowName=" + this.windowName + ", postScalingChange=" + this.postScalingChange + ", previousGraphicsDevice=" + this.previousGraphicsDevice + ", previousScaling=" + this.previousScaling + ")";
        }

        public int hashCode() {
            int result = this.componentToMonitor.hashCode();
            result = result * 31 + this.windowName.hashCode();
            result = result * 31 + this.postScalingChange.hashCode();
            result = result * 31 + (this.previousGraphicsDevice == null ? 0 : this.previousGraphicsDevice.hashCode());
            result = result * 31 + Double.hashCode(this.previousScaling);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentData)) {
                return false;
            }
            ComponentData componentData = (ComponentData)other;
            if (!Intrinsics.areEqual((Object)this.componentToMonitor, (Object)componentData.componentToMonitor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.windowName, (Object)componentData.windowName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.postScalingChange, componentData.postScalingChange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previousGraphicsDevice, (Object)componentData.previousGraphicsDevice)) {
                return false;
            }
            return Double.compare(this.previousScaling, componentData.previousScaling) == 0;
        }
    }
}

