/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class AbstractVideoCodecCore {
    private byte[] byteBuf = new byte[4];

    protected void writeInt24(ImageOutputStream out, int v) throws IOException {
        this.byteBuf[0] = (byte)(v >>> 16);
        this.byteBuf[1] = (byte)(v >>> 8);
        this.byteBuf[2] = (byte)(v >>> 0);
        out.write(this.byteBuf, 0, 3);
    }

    protected void writeInt24LE(ImageOutputStream out, int v) throws IOException {
        this.byteBuf[2] = (byte)(v >>> 16);
        this.byteBuf[1] = (byte)(v >>> 8);
        this.byteBuf[0] = (byte)(v >>> 0);
        out.write(this.byteBuf, 0, 3);
    }

    protected void writeInts24(ImageOutputStream out, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = this.byteBuf;
        for (int j = 0; j < len; ++j) {
            int v = i[off + j];
            b[0] = (byte)(v >>> 16);
            b[1] = (byte)(v >>> 8);
            b[2] = (byte)(v >>> 0);
            out.write(b, 0, 3);
        }
    }

    protected void writeInts24LE(ImageOutputStream out, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = this.byteBuf;
        for (int j = 0; j < len; ++j) {
            int v = i[off + j];
            b[0] = (byte)(v >>> 0);
            b[1] = (byte)(v >>> 8);
            b[2] = (byte)(v >>> 16);
            out.write(b, 0, 3);
        }
    }

    protected void readInts24LE(ImageInputStream in, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!, off=" + off + ", len=" + len);
        }
        byte[] b = this.byteBuf;
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v;
            in.readFully(b, 0, 3);
            i[j] = v = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16;
        }
    }

    protected int readInt24LE(ImageInputStream in) throws IOException {
        in.readFully(this.byteBuf, 0, 3);
        return (this.byteBuf[2] & 0xFF) << 16 | (this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0;
    }

    protected void readRGBs565to24(ImageInputStream in, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!, off=" + off + ", len=" + len);
        }
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v = in.readUnsignedShort();
            i[j] = (v & 0xF800) << 8 | (v & 0x3800) << 5 | (v & 0x7E0) << 5 | (v & 0x60) << 3 | (v & 0x1F) << 3 | v & 7;
        }
    }

    protected int readRGB565to24(ImageInputStream in) throws IOException {
        int v = in.readUnsignedShort();
        return (v & 0xF800) << 8 | (v & 0x3800) << 5 | (v & 0x7E0) << 5 | (v & 0x60) << 3 | (v & 0x1F) << 3 | v & 7;
    }

    protected void readRGBs555to24(ImageInputStream in, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!, off=" + off + ", len=" + len);
        }
        byte[] b = this.byteBuf;
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v = in.readUnsignedShort();
            i[j] = (v & 0x7C00) << 9 | (v & 0x7000) << 4 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x1F) << 3 | (v & 0x1C) >> 2;
        }
    }

    protected int readRGB555to24(ImageInputStream in) throws IOException {
        int v = in.readUnsignedShort();
        return (v & 0x7C00) << 9 | (v & 0x7000) << 4 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x1F) << 3 | (v & 0x1C) >> 2;
    }

    protected void readRGBs555to24LE(ImageInputStream in, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!, off=" + off + ", len=" + len);
        }
        byte[] b = this.byteBuf;
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v = in.readUnsignedShort();
            i[j] = (v & 0x1F) << 19 | (v & 0x1C) << 14 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x7C00) >>> 7 | (v & 0x7000) >>> 12;
        }
    }

    protected int readRGB555to24LE(ImageInputStream in) throws IOException {
        int v = in.readUnsignedShort();
        return (v & 0x1F) << 19 | (v & 0x1C) << 14 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x7C00) >>> 7 | (v & 0x7000) >>> 12;
    }
}

