/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Preprocessor;
import org.aeonbits.owner.Util;

final class PreprocessorResolver {
    private PreprocessorResolver() {
    }

    public static List<Preprocessor> resolvePreprocessors(Method method) {
        ArrayList<Preprocessor> result = new ArrayList<Preprocessor>();
        List<Preprocessor> preprocessorsOnMethod = PreprocessorResolver.getPreprocessor(method.getAnnotation(Config.PreprocessorClasses.class));
        result.addAll(preprocessorsOnMethod);
        List<Preprocessor> preprocessorsOnClass = PreprocessorResolver.getPreprocessor(method.getDeclaringClass().getAnnotation(Config.PreprocessorClasses.class));
        result.addAll(preprocessorsOnClass);
        return result;
    }

    private static List<Preprocessor> getPreprocessor(Config.PreprocessorClasses preprocessorClassesAnnotation) {
        if (preprocessorClassesAnnotation == null) {
            return Collections.emptyList();
        }
        Class<? extends Preprocessor>[] preprocessorClasses = preprocessorClassesAnnotation.value();
        if (preprocessorClasses == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        return Util.newInstance(preprocessorClassesAnnotation.value(), result);
    }
}

