/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.aeonbits.owner.Delegate;
import org.aeonbits.owner.PropertiesManager;

class JMXSupport
implements Serializable {
    private final Class<?> clazz;
    private final PropertiesManager manager;

    public JMXSupport(Class<?> clazz, PropertiesManager manager) {
        this.clazz = clazz;
        this.manager = manager;
    }

    @Delegate
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.manager.getProperty(attribute);
    }

    @Delegate
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.manager.setProperty(attribute.getName(), (String)attribute.getValue());
    }

    @Delegate
    public AttributeList getAttributes(String[] attributes) {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        for (String propertyName : attributes) {
            attrList.add(new Attribute(propertyName, this.manager.getProperty(propertyName)));
        }
        return new AttributeList((List<Attribute>)attrList);
    }

    @Delegate
    public AttributeList setAttributes(AttributeList attributes) {
        for (Attribute attr : attributes.asList()) {
            this.manager.setProperty(attr.getName(), (String)attr.getValue());
        }
        return attributes;
    }

    @Delegate
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("getProperty") && params != null && params.length == 1) {
            return this.manager.getProperty((String)params[0]);
        }
        if (actionName.equals("setProperty") && params != null && params.length == 2) {
            this.manager.setProperty((String)params[0], (String)params[1]);
            return null;
        }
        if (actionName.equals("reload") && (params == null || params.length == 0)) {
            this.manager.reload();
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(actionName));
    }

    @Delegate
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributesInfo = new ArrayList<MBeanAttributeInfo>();
        Set<String> propertyNames = this.manager.propertyNames();
        for (String name : propertyNames) {
            attributesInfo.add(new MBeanAttributeInfo(name, "java.lang.String", name, true, true, false));
        }
        MBeanAttributeInfo[] attributes = attributesInfo.toArray(new MBeanAttributeInfo[propertyNames.size()]);
        MBeanParameterInfo key = new MBeanParameterInfo("key", "java.lang.String", "Key of the property");
        MBeanParameterInfo value = new MBeanParameterInfo("value", "java.lang.String", "Value of the property");
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("getProperty", "Gets value for a property", new MBeanParameterInfo[]{key}, "java.lang.String", 0), new MBeanOperationInfo("setProperty", "Sets the value for a property", new MBeanParameterInfo[]{key, value}, "void", 1), new MBeanOperationInfo("reload", "Reload properties", null, "void", 1)};
        return new MBeanInfo(this.clazz.getName(), this.clazz.getSimpleName() + " OWNER MBean", attributes, null, operations, null);
    }
}

