/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder;

import com.automation.remarks.video.SystemUtils;
import com.automation.remarks.video.enums.RecorderType;
import com.automation.remarks.video.enums.RecordingMode;
import com.automation.remarks.video.enums.VideoSaveMode;
import java.awt.Dimension;
import java.io.File;
import org.aeonbits.owner.Config;

@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.Sources(value={"classpath:video.properties", "classpath:ffmpeg-${os.type}.properties"})
public interface VideoConfiguration
extends Config {
    @Config.Key(value="video.folder")
    default public String folder() {
        String defaultFolder = System.getProperty("user.dir") + File.separator + "video";
        return System.getProperty("video.folder", defaultFolder);
    }

    @Config.Key(value="video.enabled")
    @Config.DefaultValue(value="true")
    public Boolean videoEnabled();

    @Config.Key(value="video.mode")
    @Config.DefaultValue(value="ANNOTATED")
    public RecordingMode mode();

    @Config.DefaultValue(value="http://localhost:4444")
    @Config.Key(value="remote.video.hub")
    public String remoteUrl();

    @Config.DefaultValue(value="false")
    @Config.Key(value="video.remote")
    public Boolean isRemote();

    @Config.Key(value="video.name")
    public String fileName();

    @Config.Key(value="recorder.type")
    @Config.DefaultValue(value="MONTE")
    public RecorderType recorderType();

    @Config.Key(value="video.save.mode")
    @Config.DefaultValue(value="FAILED_ONLY")
    public VideoSaveMode saveMode();

    @Config.DefaultValue(value="24")
    @Config.Key(value="video.frame.rate")
    public int frameRate();

    @Config.Key(value="video.screen.size")
    default public Dimension screenSize() {
        return SystemUtils.getSystemScreenDimension();
    }

    @Config.Key(value="ffmpeg.format")
    public String ffmpegFormat();

    @Config.Key(value="ffmpeg.display")
    public String ffmpegDisplay();

    @Config.DefaultValue(value="yuv420p")
    @Config.Key(value="ffmpeg.pixelFormat")
    public String ffmpegPixelFormat();
}

