/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor.rdi;

import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.remco.software.ncrunch.editor.EditorReference;
import com.remco.software.ncrunch.editor.rdi.RdiMouseEventPoint;
import com.remco.software.ncrunch.editor.rdi.RdiUIElementInfo;
import com.remco.software.ncrunch.model.RdiMouseButtonState;
import com.remco.software.ncrunch.sharedMemory.SharedMemory;
import com.remco.software.ncrunch.sharedMemory.Win32API;
import com.sun.jna.platform.win32.WinNT;
import java.awt.Cursor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\"\u0010(\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020 2\b\b\u0002\u0010*\u001a\u00020 H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010.\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u0014H\u0002J\b\u00103\u001a\u00020\u001bH\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001eH\u0016J\u0010\u00107\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00108\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00109\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/remco/software/ncrunch/editor/rdi/RdiMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Ljava/io/Closeable;", "editorReference", "Lcom/remco/software/ncrunch/editor/EditorReference;", "<init>", "(Lcom/remco/software/ncrunch/editor/EditorReference;)V", "memoryMapWriteIndexPosition", "", "memoryMapX", "memoryMapY", "memoryMapButton", "memoryMapButtonState", "memoryMapIsLeave", "memoryMapIsMove", "memoryMapRecordSize", "memoryMapNumberOfRecords", "memoryMapStart", "memoryMapSize", "", "currentWriteIndex", "sharedMemory", "Lcom/remco/software/ncrunch/sharedMemory/SharedMemory;", "waitHandle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "close", "", "mouseMoved", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "checkHandElement", "", "elementsUnderCursor", "", "Lcom/remco/software/ncrunch/editor/rdi/RdiUIElementInfo;", "handCursor", "Ljava/awt/Cursor;", "textCursor", "defaultCursor", "setCursorStyle", "isHand", "isOverRDIElement", "mouseLocationWithRespectToZIndex", "mouseDragged", "mousePressed", "sendRdiMouseEvent", "rdiMouseButtonState", "Lcom/remco/software/ncrunch/model/RdiMouseButtonState;", "isMove", "mouseButton", "finalizeShareMemoryRecord", "mouseReleased", "mouseExited", "event", "mouseIsOverRdiElement", "mouseIsOverRdiCanvas", "isNotOverEditor", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nRdiMouseListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdiMouseListener.kt\ncom/remco/software/ncrunch/editor/rdi/RdiMouseListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1971#2,14:198\n774#2:212\n865#2,2:213\n1755#2,3:215\n1755#2,3:218\n*S KotlinDebug\n*F\n+ 1 RdiMouseListener.kt\ncom/remco/software/ncrunch/editor/rdi/RdiMouseListener\n*L\n70#1:198,14\n87#1:212\n87#1:213,2\n177#1:215,3\n186#1:218,3\n*E\n"})
public final class RdiMouseListener
implements EditorMouseMotionListener,
EditorMouseListener,
Closeable {
    @NotNull
    private final EditorReference editorReference;
    private final long memoryMapWriteIndexPosition;
    private final long memoryMapX;
    private final long memoryMapY;
    private final long memoryMapButton;
    private final long memoryMapButtonState;
    private final long memoryMapIsLeave;
    private final long memoryMapIsMove;
    private final long memoryMapRecordSize;
    private final long memoryMapNumberOfRecords;
    private final long memoryMapStart;
    private final int memoryMapSize;
    private long currentWriteIndex;
    @NotNull
    private final SharedMemory sharedMemory;
    @NotNull
    private final WinNT.HANDLE waitHandle;
    @NotNull
    private final Cursor handCursor;
    @NotNull
    private Cursor textCursor;
    @NotNull
    private final Cursor defaultCursor;

    public RdiMouseListener(@NotNull EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        this.editorReference = editorReference;
        this.memoryMapY = 4L;
        this.memoryMapButton = 8L;
        this.memoryMapButtonState = 20L;
        this.memoryMapIsLeave = 24L;
        this.memoryMapIsMove = 28L;
        this.memoryMapRecordSize = this.memoryMapIsMove + (long)4;
        this.memoryMapNumberOfRecords = 10000L;
        this.memoryMapStart = 4L;
        this.memoryMapSize = (int)(this.memoryMapStart + this.memoryMapRecordSize * this.memoryMapNumberOfRecords);
        this.currentWriteIndex = this.memoryMapStart;
        this.sharedMemory = new SharedMemory(this.editorReference.getEditorGuid() + "-mouse-events", this.memoryMapSize);
        this.waitHandle = Win32API.INSTANCE.getInstance().CreateEvent(null, false, false, this.editorReference.getEditorGuid() + "-mouse-events-EventWaitHandle");
        this.handCursor = new Cursor(12);
        this.textCursor = new Cursor(2);
        this.defaultCursor = new Cursor(0);
    }

    @Override
    public void close() {
        this.sharedMemory.close();
        Win32API.INSTANCE.getInstance().CloseHandle(this.waitHandle);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotOverEditor(e) || !this.editorReference.getRdiOverlayActive()) {
            RdiMouseListener.setCursorStyle$default(this, e, false, false, 4, null);
            this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), false, false, 12, null));
            super.mouseMoved(e);
            return;
        }
        this.sendRdiMouseEvent(e, e.getMouseEvent().getButton() == 0 ? RdiMouseButtonState.None : RdiMouseButtonState.Pressed, true, e.getMouseEvent().getButton());
        List<RdiUIElementInfo> elementsUnderCursor = this.mouseLocationWithRespectToZIndex(e);
        if (elementsUnderCursor.isEmpty()) {
            RdiMouseListener.setCursorStyle$default(this, e, false, false, 4, null);
            this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), true, false, 8, null));
            super.mouseMoved(e);
            return;
        }
        this.setCursorStyle(e, this.checkHandElement(elementsUnderCursor), true);
        this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), true, !Intrinsics.areEqual((Object)e.getEditor().getContentComponent().getCursor(), (Object)this.textCursor)));
        super.mouseMoved(e);
    }

    private final boolean checkHandElement(List<RdiUIElementInfo> elementsUnderCursor) {
        RdiUIElementInfo topElement;
        Object v0;
        Iterable $this$maxByOrNull$iv = elementsUnderCursor;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                RdiUIElementInfo it = (RdiUIElementInfo)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getZIndex();
                do {
                    Object e$iv = iterator$iv.next();
                    RdiUIElementInfo it2 = (RdiUIElementInfo)e$iv;
                    $i$a$-maxByOrNull-RdiMouseListener$checkHandElement$topElement$1 = false;
                    int v$iv = it2.getZIndex();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        RdiUIElementInfo rdiUIElementInfo = topElement = (RdiUIElementInfo)v0;
        return rdiUIElementInfo != null ? rdiUIElementInfo.isHand() : false;
    }

    private final void setCursorStyle(EditorMouseEvent e, boolean isHand, boolean isOverRDIElement) {
        if (isOverRDIElement && !isHand) {
            e.getEditor().getContentComponent().setCursor(this.defaultCursor);
        } else {
            e.getEditor().getContentComponent().setCursor(isHand ? this.handCursor : this.textCursor);
        }
    }

    static /* synthetic */ void setCursorStyle$default(RdiMouseListener rdiMouseListener, EditorMouseEvent editorMouseEvent, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        rdiMouseListener.setCursorStyle(editorMouseEvent, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RdiUIElementInfo> mouseLocationWithRespectToZIndex(EditorMouseEvent e) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.editorReference.getRdiElementInfoList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RdiUIElementInfo it = (RdiUIElementInfo)element$iv$iv;
            boolean bl = false;
            if (!((double)e.getMouseEvent().getX() >= it.getX() && (double)e.getMouseEvent().getX() <= it.getX() + it.getWidth() && (double)e.getMouseEvent().getY() >= it.getY() && (double)e.getMouseEvent().getY() <= it.getY() + it.getHeight() && !it.isCanvas())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotOverEditor(e) || !this.mouseIsOverRdiCanvas(e)) {
            super.mouseClicked(e);
            return;
        }
        this.sendRdiMouseEvent(e, RdiMouseButtonState.Pressed, true, 1);
        this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), true, !Intrinsics.areEqual((Object)e.getEditor().getContentComponent().getCursor(), (Object)this.textCursor)));
        if (this.mouseIsOverRdiElement(e)) {
            e.consume();
        }
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotOverEditor(e) || !this.mouseIsOverRdiCanvas(e)) {
            super.mouseClicked(e);
            return;
        }
        this.sendRdiMouseEvent(e, RdiMouseButtonState.Pressed, false, e.getMouseEvent().getButton());
        this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), true, !Intrinsics.areEqual((Object)e.getEditor().getContentComponent().getCursor(), (Object)this.textCursor)));
        if (this.mouseIsOverRdiElement(e)) {
            e.consume();
        }
    }

    private final void sendRdiMouseEvent(EditorMouseEvent e, RdiMouseButtonState rdiMouseButtonState, boolean isMove, int mouseButton) {
        this.sharedMemory.writeInt(e.getMouseEvent().getX(), this.memoryMapX + this.currentWriteIndex);
        this.sharedMemory.writeInt(e.getMouseEvent().getY(), this.memoryMapY + this.currentWriteIndex);
        this.sharedMemory.writeInt(mouseButton, this.memoryMapButton + this.currentWriteIndex);
        this.sharedMemory.writeInt(rdiMouseButtonState.ordinal(), this.memoryMapButtonState + this.currentWriteIndex);
        this.sharedMemory.writeInt(0, this.memoryMapIsLeave + this.currentWriteIndex);
        this.sharedMemory.writeInt(isMove ? 1 : 0, this.memoryMapIsMove + this.currentWriteIndex);
        this.finalizeShareMemoryRecord();
    }

    private final void finalizeShareMemoryRecord() {
        this.sharedMemory.writeInt((int)this.currentWriteIndex, this.memoryMapWriteIndexPosition);
        this.currentWriteIndex += this.memoryMapRecordSize;
        if (this.currentWriteIndex >= (long)this.memoryMapSize) {
            this.currentWriteIndex = this.memoryMapStart;
        }
        Win32API.INSTANCE.getInstance().SetEvent(this.waitHandle);
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotOverEditor(e) || !this.mouseIsOverRdiCanvas(e)) {
            this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), false, false, 12, null));
            super.mouseReleased(e);
            return;
        }
        this.sendRdiMouseEvent(e, RdiMouseButtonState.Released, false, e.getMouseEvent().getButton());
        this.editorReference.addRdiMouseEvent(new RdiMouseEventPoint(e.getMouseEvent().getX(), e.getMouseEvent().getY(), true, false, 8, null));
        if (this.mouseIsOverRdiElement(e)) {
            e.consume();
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sharedMemory.writeInt(0, this.memoryMapX + this.currentWriteIndex);
        this.sharedMemory.writeInt(0, this.memoryMapY + this.currentWriteIndex);
        this.sharedMemory.writeInt(0, this.memoryMapButton + this.currentWriteIndex);
        this.sharedMemory.writeInt(0, this.memoryMapButtonState + this.currentWriteIndex);
        this.sharedMemory.writeInt(1, this.memoryMapIsLeave + this.currentWriteIndex);
        this.sharedMemory.writeInt(0, this.memoryMapIsMove + this.currentWriteIndex);
        this.finalizeShareMemoryRecord();
        super.mouseExited(event);
    }

    private final boolean mouseIsOverRdiElement(EditorMouseEvent e) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.editorReference.getRdiElementInfoList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RdiUIElementInfo it = (RdiUIElementInfo)element$iv;
                    boolean bl2 = false;
                    if (!(this.editorReference.getRdiOverlayActive() && !it.isCanvas() && (double)e.getMouseEvent().getX() >= it.getX() && (double)e.getMouseEvent().getX() <= it.getX() + it.getWidth() && (double)e.getMouseEvent().getY() >= it.getY() && (double)e.getMouseEvent().getY() <= it.getY() + it.getHeight())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean mouseIsOverRdiCanvas(EditorMouseEvent e) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.editorReference.getRdiElementInfoList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RdiUIElementInfo it = (RdiUIElementInfo)element$iv;
                    boolean bl2 = false;
                    if (!(this.editorReference.getRdiOverlayActive() && it.isCanvas() && (double)e.getMouseEvent().getX() >= it.getX() && (double)e.getMouseEvent().getX() <= it.getX() + it.getWidth() && (double)e.getMouseEvent().getY() >= it.getY() && (double)e.getMouseEvent().getY() <= it.getY() + it.getHeight())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNotOverEditor(EditorMouseEvent e) {
        return e.getMouseEvent().getComponent() == null || !(e.getMouseEvent().getComponent() instanceof EditorComponentImpl);
    }
}

