/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.ErrorService;
import com.remco.software.ncrunch.editor.EditorReference;
import com.remco.software.ncrunch.model.BreakPoint;
import com.remco.software.ncrunch.model.DocumentChangedEvent;
import com.remco.software.ncrunch.model.FileRenamedEvent;
import com.remco.software.ncrunch.model.JumpToDocumentLineEvent;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import com.remco.software.ncrunch.model.NCrunchSystemDisabledEvent;
import com.remco.software.ncrunch.model.ProcessId;
import com.sun.jna.Pointer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J3\u0010,\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2!\u0010-\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u00170.H\u0002J$\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b052\u0006\u00106\u001a\u00020\u001dH\u0002J\u000e\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020:J\u0016\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=J\u001e\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010<\u001a\u00020=J\u0006\u0010D\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u00107\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/remco/software/ncrunch/editor/EditorIntegrationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "filesWithOpenEditors", "Ljava/util/HashMap;", "", "Lcom/remco/software/ncrunch/editor/EditorReference;", "getFilesWithOpenEditors", "()Ljava/util/HashMap;", "setFilesWithOpenEditors", "(Ljava/util/HashMap;)V", "syncLock", "Ljava/lang/Object;", "sharedMemoryDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getSharedMemoryDispatcher$annotations", "()V", "dispose", "", "systemDisabled", "e", "Lcom/remco/software/ncrunch/model/NCrunchSystemDisabledEvent;", "closeRdiOverlay", "editorGuid", "Ljava/util/UUID;", "openRdiOverlay", "editorInformationRequested", "detachFromProcess", "ignoredProcessId", "Lcom/remco/software/ncrunch/model/ProcessId;", "attachToProcess", "Lkotlinx/coroutines/Job;", "processId", "setBreakPoint", "breakPoint", "Lcom/remco/software/ncrunch/model/BreakPoint;", "jumpToDocument", "jumpToDocumentLineEvent", "Lcom/remco/software/ncrunch/model/JumpToDocumentLineEvent;", "runOnEditorIdentifiedBy", "functionToRun", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "editorReference", "isEditorForIdentifier", "", "editor", "", "id", "windowHandleSend", "registerWindowHandle", "windowHandle", "Lcom/sun/jna/Pointer;", "registerOpenedEditor", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "openedEditorClosed", "registerNameChange", "oldPath", "newPath", "refreshCurrentlyOpenEditors", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nEditorIntegrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorIntegrationService.kt\ncom/remco/software/ncrunch/editor/EditorIntegrationService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,339:1\n15#2:340\n12567#3,2:341\n*S KotlinDebug\n*F\n+ 1 EditorIntegrationService.kt\ncom/remco/software/ncrunch/editor/EditorIntegrationService\n*L\n39#1:340\n329#1:341,2\n*E\n"})
public final class EditorIntegrationService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private HashMap<String, EditorReference> filesWithOpenEditors;
    @NotNull
    private final Object syncLock;
    @NotNull
    private final CoroutineDispatcher sharedMemoryDispatcher;
    private boolean windowHandleSend;

    public EditorIntegrationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorIntegrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.filesWithOpenEditors = new HashMap();
        this.syncLock = new Object();
        this.sharedMemoryDispatcher = Dispatchers.getIO().limitedParallelism(100);
        this.logger.info("EditorIntegrationService is starting up and listening for NCrunch events.");
        SwingUtilities.invokeLater(() -> EditorIntegrationService._init_$lambda$0(this));
    }

    @NotNull
    public final HashMap<String, EditorReference> getFilesWithOpenEditors() {
        return this.filesWithOpenEditors;
    }

    public final void setFilesWithOpenEditors(@NotNull HashMap<String, EditorReference> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.filesWithOpenEditors = hashMap;
    }

    private static /* synthetic */ void getSharedMemoryDispatcher$annotations() {
    }

    public void dispose() {
    }

    private final void systemDisabled(NCrunchSystemDisabledEvent e) {
        SwingUtilities.invokeLater(() -> EditorIntegrationService.systemDisabled$lambda$3(this));
    }

    private final void closeRdiOverlay(UUID editorGuid) {
        SwingUtilities.invokeLater(() -> EditorIntegrationService.closeRdiOverlay$lambda$5(this, editorGuid));
    }

    private final void openRdiOverlay(UUID editorGuid) {
        SwingUtilities.invokeLater(() -> EditorIntegrationService.openRdiOverlay$lambda$7(this, editorGuid));
    }

    private final void editorInformationRequested(UUID editorGuid) {
        SwingUtilities.invokeLater(() -> EditorIntegrationService.editorInformationRequested$lambda$9(this, editorGuid));
    }

    private final void detachFromProcess(ProcessId ignoredProcessId) {
        SwingUtilities.invokeLater(() -> EditorIntegrationService.detachFromProcess$lambda$11(this));
    }

    private final Job attachToProcess(ProcessId processId) {
        return (Job)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, processId, null){
            int label;
            final /* synthetic */ EditorIntegrationService this$0;
            final /* synthetic */ ProcessId $processId;
            {
                this.this$0 = $receiver;
                this.$processId = $processId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$processId, null){
                            int label;
                            final /* synthetic */ EditorIntegrationService this$0;
                            final /* synthetic */ ProcessId $processId;
                            {
                                this.this$0 = $receiver;
                                this.$processId = $processId;
                                super(2, $completion);
                            }

                            /*
                             * Exception decompiling
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[WHILELOOP]
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCase.dump(StructuredCase.java:94)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredSwitch.dump(StructuredSwitch.java:59)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void setBreakPoint(BreakPoint breakPoint) {
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.setBreakPoint$lambda$12(breakPoint, this)));
    }

    private final void jumpToDocument(JumpToDocumentLineEvent jumpToDocumentLineEvent) {
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.jumpToDocument$lambda$13(jumpToDocumentLineEvent, this)));
    }

    private final void runOnEditorIdentifiedBy(UUID editorGuid, Function1<? super EditorReference, Unit> functionToRun) {
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.runOnEditorIdentifiedBy$lambda$15(this, editorGuid, functionToRun)));
    }

    private final boolean isEditorForIdentifier(Map.Entry<String, EditorReference> editor, UUID id) {
        return Intrinsics.areEqual((Object)editor.getValue().getEditorGuid(), (Object)id);
    }

    public final void registerWindowHandle(@NotNull Pointer windowHandle) {
        Intrinsics.checkNotNullParameter((Object)windowHandle, (String)"windowHandle");
        if (this.windowHandleSend) {
            return;
        }
        this.windowHandleSend = true;
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getSendMainWindowHandle().fire((Object)Pointer.nativeValue((Pointer)windowHandle));
    }

    public final void registerOpenedEditor(@NotNull VirtualFile file, @NotNull FileEditorManager manager) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.registerOpenedEditor$lambda$17(file, manager, this)));
    }

    public final void openedEditorClosed(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.openedEditorClosed$lambda$19(this, file)));
    }

    public final void registerNameChange(@NotNull String oldPath, @NotNull String newPath, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.registerNameChange$lambda$20(this, oldPath, file, newPath)));
    }

    public final void refreshCurrentlyOpenEditors() {
        ErrorService.Companion.doWithErrorHandling(this.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.refreshCurrentlyOpenEditors$lambda$23(this)));
    }

    private static final void _init_$lambda$0(EditorIntegrationService this$0) {
        this$0.logger.info("EditorIntegrationService has switched to the UI thread to listen to editor events.");
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getJumpToDocument().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<JumpToDocumentLineEvent, Unit>((Object)this$0){

            public final void invoke(JumpToDocumentLineEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$jumpToDocument((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getSetBreakPoint().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<BreakPoint, Unit>((Object)this$0){

            public final void invoke(BreakPoint p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$setBreakPoint((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getAttachToProcess().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<ProcessId, Unit>((Object)this$0){

            public final void invoke(ProcessId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$attachToProcess((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getDetachFromProcess().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<ProcessId, Unit>((Object)this$0){

            public final void invoke(ProcessId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$detachFromProcess((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getRequestEditorInformation().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<UUID, Unit>((Object)this$0){

            public final void invoke(UUID p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$editorInformationRequested((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getCloseRdiOverlay().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<UUID, Unit>((Object)this$0){

            public final void invoke(UUID p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$closeRdiOverlay((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getOpenRdiOverlay().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<UUID, Unit>((Object)this$0){

            public final void invoke(UUID p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$openRdiOverlay((EditorIntegrationService)this.receiver, p0);
            }
        });
        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getSystemDisabled().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)new Function1<NCrunchSystemDisabledEvent, Unit>((Object)this$0){

            public final void invoke(NCrunchSystemDisabledEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EditorIntegrationService.access$systemDisabled((EditorIntegrationService)this.receiver, p0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit systemDisabled$lambda$3$lambda$2(EditorIntegrationService this$0) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            for (Map.Entry editorReference : ((Map)this$0.filesWithOpenEditors).entrySet()) {
                ((EditorReference)editorReference.getValue()).clearMarkers();
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void systemDisabled$lambda$3(EditorIntegrationService this$0) {
        ErrorService.Companion.doWithErrorHandling(this$0.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.systemDisabled$lambda$3$lambda$2(this$0)));
    }

    private static final Unit closeRdiOverlay$lambda$5$lambda$4(EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        editorReference.closeRdiOverlay();
        return Unit.INSTANCE;
    }

    private static final void closeRdiOverlay$lambda$5(EditorIntegrationService this$0, UUID $editorGuid) {
        this$0.runOnEditorIdentifiedBy($editorGuid, (Function1<? super EditorReference, Unit>)((Function1)EditorIntegrationService::closeRdiOverlay$lambda$5$lambda$4));
    }

    private static final Unit openRdiOverlay$lambda$7$lambda$6(EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        editorReference.openRdiOverlay();
        return Unit.INSTANCE;
    }

    private static final void openRdiOverlay$lambda$7(EditorIntegrationService this$0, UUID $editorGuid) {
        this$0.runOnEditorIdentifiedBy($editorGuid, (Function1<? super EditorReference, Unit>)((Function1)EditorIntegrationService::openRdiOverlay$lambda$7$lambda$6));
    }

    private static final Unit editorInformationRequested$lambda$9$lambda$8(EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        editorReference.sendCurrentEditorStateToNCrunch();
        return Unit.INSTANCE;
    }

    private static final void editorInformationRequested$lambda$9(EditorIntegrationService this$0, UUID $editorGuid) {
        this$0.runOnEditorIdentifiedBy($editorGuid, (Function1<? super EditorReference, Unit>)((Function1)EditorIntegrationService::editorInformationRequested$lambda$9$lambda$8));
    }

    private static final Unit detachFromProcess$lambda$11$lambda$10(EditorIntegrationService this$0) {
        block0: {
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this$0.project).getCurrentSession();
            if (xDebugSession == null || (xDebugSession = xDebugSession.getDebugProcess()) == null || (xDebugSession = xDebugSession.getProcessHandler()) == null) break block0;
            xDebugSession.detachProcess();
        }
        return Unit.INSTANCE;
    }

    private static final void detachFromProcess$lambda$11(EditorIntegrationService this$0) {
        ErrorService.Companion.doWithErrorHandling(this$0.project, (Function0<Unit>)((Function0)() -> EditorIntegrationService.detachFromProcess$lambda$11$lambda$10(this$0)));
    }

    private static final Unit setBreakPoint$lambda$12(BreakPoint $breakPoint, EditorIntegrationService this$0) {
        VirtualFile foundFile = VirtualFileManager.getInstance().findFileByNioPath(Path.of($breakPoint.getDocumentFilePath(), new String[0]));
        if (foundFile != null) {
            XSourcePositionImpl position = XSourcePositionImpl.create((VirtualFile)foundFile, (int)($breakPoint.getLine() - 1));
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this$0.project).openFile(foundFile, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            FileEditor[] editor = fileEditorArray;
            if (!(editor.length == 0) && editor[0] instanceof TextEditor) {
                Project project = this$0.project;
                Intrinsics.checkNotNull((Object)position);
                XSourcePosition xSourcePosition = (XSourcePosition)position;
                FileEditor fileEditor = editor[0];
                Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
                Promise setBreakPoint = XBreakpointUtil.toggleLineBreakpoint((Project)project, (XSourcePosition)xSourcePosition, (boolean)false, (Editor)((TextEditor)fileEditor).getEditor(), (boolean)true, (boolean)false, (boolean)false);
                if (setBreakPoint.isSucceeded()) {
                    this$0.logger.info("Breakpoint is set (" + $breakPoint.getLine() + ", " + $breakPoint.getDocumentFilePath() + ")");
                }
            }
        } else {
            this$0.logger.debug("Document not found, can't jump to (" + $breakPoint.getLine() + ", " + $breakPoint.getDocumentFilePath() + ")");
        }
        return Unit.INSTANCE;
    }

    private static final Unit jumpToDocument$lambda$13(JumpToDocumentLineEvent $jumpToDocumentLineEvent, EditorIntegrationService this$0) {
        VirtualFile foundFile = VirtualFileManager.getInstance().findFileByNioPath(Path.of($jumpToDocumentLineEvent.getDocumentFilePath(), new String[0]));
        if (foundFile != null) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this$0.project).openFile(foundFile, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            FileEditor[] editor = fileEditorArray;
            if (!(editor.length == 0) && editor[0] instanceof TextEditor) {
                this$0.logger.debug("Jumping to opened document location (" + $jumpToDocumentLineEvent.getLine() + ", " + $jumpToDocumentLineEvent.getColumn() + ") " + $jumpToDocumentLineEvent.getDocumentFilePath());
                int n = $jumpToDocumentLineEvent.getLine();
                int n2 = $jumpToDocumentLineEvent.getColumn();
                FileEditor fileEditor = editor[0];
                Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
                EditorReference.Companion.jumpInEditor(n, n2, (TextEditor)fileEditor);
            }
        } else {
            this$0.logger.debug("Document not found, can't jump to (" + $jumpToDocumentLineEvent.getLine() + ", " + $jumpToDocumentLineEvent.getColumn() + ") " + $jumpToDocumentLineEvent.getDocumentFilePath());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit runOnEditorIdentifiedBy$lambda$15(EditorIntegrationService this$0, UUID $editorGuid, Function1 $functionToRun) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            for (Map.Entry<String, EditorReference> entry : ((Map)this$0.filesWithOpenEditors).entrySet()) {
                if (!this$0.isEditorForIdentifier(entry, $editorGuid)) continue;
                $functionToRun.invoke((Object)entry.getValue());
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit registerOpenedEditor$lambda$17(VirtualFile $file, FileEditorManager $manager, EditorIntegrationService this$0) {
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String key = string;
        FileEditor fileEditor = $manager.getSelectedEditor($file);
        Document document = FileDocumentManager.getInstance().getDocument($file);
        if (fileEditor == null || document == null) {
            return Unit.INSTANCE;
        }
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            if (!this$0.filesWithOpenEditors.containsKey(key)) {
                ((Map)this$0.filesWithOpenEditors).put(key, new EditorReference($file, this$0, this$0.project, this$0.sharedMemoryDispatcher, document));
                document.addDocumentListener(new DocumentListener(this$0){
                    final /* synthetic */ EditorIntegrationService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void documentChanged(DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
                        if (virtualFile == null) {
                            return;
                        }
                        VirtualFile updatedFile = virtualFile;
                        String string = updatedFile.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String currentEditorPath = string;
                        String newText = null;
                        String string2 = event.getDocument().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                        newText = string2;
                        String string3 = CodeStyle.getSettings((Project)EditorIntegrationService.access$getProject$p(this.this$0)).getLineSeparator();
                        if (string3 != null) {
                            String it = string3;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it, (Object)"\r\n")) {
                                newText = StringsKt.replace$default((String)newText, (String)"\n", (String)"\r\n", (boolean)false, (int)4, null);
                            }
                        }
                        EditorReference editorReference = this.this$0.getFilesWithOpenEditors().get(currentEditorPath);
                        if (editorReference != null) {
                            editorReference.setFile(updatedFile);
                        }
                        NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)EditorIntegrationService.access$getProject$p(this.this$0))).getDocumentChanged().fire((Object)new DocumentChangedEvent(currentEditorPath, event.getMoveOffset(), event.getOffset(), event.isWholeTextReplaced(), ((Object)event.getNewFragment()).toString(), ((Object)event.getOldFragment()).toString(), newText));
                    }
                }, (Disposable)fileEditor);
            }
            EditorReference editorReference = this$0.filesWithOpenEditors.get(key);
            if (editorReference != null) {
                editorReference.registerTextEditor();
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit openedEditorClosed$lambda$19(EditorIntegrationService this$0, VirtualFile $file) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.filesWithOpenEditors.containsKey($file.getPath())) {
                EditorReference editorReference = this$0.filesWithOpenEditors.get($file.getPath());
                if (editorReference != null) {
                    editorReference.unregisterTextEditor();
                }
                EditorReference editorReference2 = this$0.filesWithOpenEditors.get($file.getPath());
                Boolean bl2 = editorReference2 != null ? Boolean.valueOf(editorReference2.hasOpenEditors()) : null;
                Intrinsics.checkNotNull((Object)bl2);
                if (bl2.booleanValue()) {
                    this$0.filesWithOpenEditors.remove($file.getPath());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        IAsyncSignal<String> iAsyncSignal = NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getEditorClosed();
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        iAsyncSignal.fire((Object)string);
        return Unit.INSTANCE;
    }

    private static final Unit registerNameChange$lambda$20(EditorIntegrationService this$0, String $oldPath, VirtualFile $file, String $newPath) {
        if (this$0.filesWithOpenEditors.containsKey($oldPath)) {
            EditorReference editorRef = this$0.filesWithOpenEditors.get($oldPath);
            this$0.filesWithOpenEditors.remove($oldPath);
            EditorReference editorReference = editorRef;
            Intrinsics.checkNotNull((Object)editorReference);
            editorReference.setFile($file);
            ((Map)this$0.filesWithOpenEditors).put($newPath, editorRef);
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getEditorFileNameRenamed().fire((Object)new FileRenamedEvent(StringsKt.replace$default((String)$oldPath, (char)'/', (char)'\\', (boolean)false, (int)4, null), StringsKt.replace$default((String)$newPath, (char)'/', (char)'\\', (boolean)false, (int)4, null)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit refreshCurrentlyOpenEditors$lambda$23(EditorIntegrationService this$0) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
            for (Map.Entry editorReference : ((Map)this$0.filesWithOpenEditors).entrySet()) {
                boolean bl2;
                block6: {
                    VirtualFile file = ((EditorReference)editorReference.getValue()).getFile();
                    FileEditor[] fileEditorArray = fileEditorManager.getSelectedEditors();
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
                    Object[] $this$any$iv = fileEditorArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        FileEditor it = (FileEditor)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    ((EditorReference)editorReference.getValue()).markAsForeground();
                    continue;
                }
                ((EditorReference)editorReference.getValue()).markAsBackground();
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(EditorIntegrationService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$jumpToDocument(EditorIntegrationService $this, JumpToDocumentLineEvent jumpToDocumentLineEvent) {
        $this.jumpToDocument(jumpToDocumentLineEvent);
    }

    public static final /* synthetic */ void access$setBreakPoint(EditorIntegrationService $this, BreakPoint breakPoint) {
        $this.setBreakPoint(breakPoint);
    }

    public static final /* synthetic */ Job access$attachToProcess(EditorIntegrationService $this, ProcessId processId) {
        return $this.attachToProcess(processId);
    }

    public static final /* synthetic */ void access$detachFromProcess(EditorIntegrationService $this, ProcessId ignoredProcessId) {
        $this.detachFromProcess(ignoredProcessId);
    }

    public static final /* synthetic */ void access$editorInformationRequested(EditorIntegrationService $this, UUID editorGuid) {
        $this.editorInformationRequested(editorGuid);
    }

    public static final /* synthetic */ void access$closeRdiOverlay(EditorIntegrationService $this, UUID editorGuid) {
        $this.closeRdiOverlay(editorGuid);
    }

    public static final /* synthetic */ void access$openRdiOverlay(EditorIntegrationService $this, UUID editorGuid) {
        $this.openRdiOverlay(editorGuid);
    }

    public static final /* synthetic */ void access$systemDisabled(EditorIntegrationService $this, NCrunchSystemDisabledEvent e) {
        $this.systemDisabled(e);
    }
}

