/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.menu;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.model.MenuItemId;
import com.remco.software.ncrunch.model.MenuStatus;
import com.remco.software.ncrunch.model.MenuText;
import com.remco.software.ncrunch.model.NCrunchForRiderModel;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/remco/software/ncrunch/menu/NCrunchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "guid", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "id", "", "text", "", "enabled", "", "visible", "<init>", "(Ljava/util/UUID;ILjava/lang/String;ZZ)V", "getId", "()I", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "boundToProject", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nNCrunchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NCrunchAction.kt\ncom/remco/software/ncrunch/menu/NCrunchAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n15#2:62\n*S KotlinDebug\n*F\n+ 1 NCrunchAction.kt\ncom/remco/software/ncrunch/menu/NCrunchAction\n*L\n15#1:62\n*E\n"})
public class NCrunchAction
extends AnAction {
    @NotNull
    private final UUID guid;
    private final int id;
    @NotNull
    private String text;
    private boolean enabled;
    private boolean visible;
    @NotNull
    private final Logger logger;
    @Nullable
    private Project boundToProject;

    public NCrunchAction(@NotNull UUID guid, int id, @NotNull String text, boolean enabled, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.guid = guid;
        this.id = id;
        this.text = text;
        this.enabled = enabled;
        this.visible = visible;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NCrunchAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final int getId() {
        return this.id;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getProject();
            if (object == null || (object = SolutionHostExtensionsKt.getSolution((Project)object)) == null || (object = NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel((Solution)object)) == null || (object = ((NCrunchForRiderModel)((Object)object)).getMenuClicked()) == null) break block0;
            object.fire((Object)new MenuItemId(this.guid, this.id));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)this.text, (Object)"") && e.getPresentation().getText() != null) {
            this.text = e.getPresentation().getText();
        }
        if ((project = e.getProject()) != null && !Intrinsics.areEqual((Object)project, (Object)this.boundToProject)) {
            this.boundToProject = project;
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getGetMenuStatus().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> NCrunchAction.update$lambda$0(this, arg_0));
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getGetMenuText().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> NCrunchAction.update$lambda$1(this, arg_0));
            this.logger.info("Menu item: (" + this.id + "): Requesting an update -> " + this.text);
            NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel(SolutionHostExtensionsKt.getSolution((Project)project)).getRequestMenuStatus().fire((Object)this.id);
        }
        e.getPresentation().setText(this.text);
        e.getPresentation().setEnabled(this.enabled);
        e.getPresentation().setVisible(this.visible);
        this.logger.info("Menu item: (" + this.id + "): End of update -> " + this.text + " is visible: " + this.visible + ", enabled: " + this.enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit update$lambda$0(NCrunchAction this$0, MenuStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getId() == this$0.id) {
            this$0.visible = it.getVisible();
            this$0.enabled = it.getEnabled();
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(NCrunchAction this$0, MenuText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getId() == this$0.id) {
            this$0.logger.info("Menu item: (" + this$0.id + "): Received menu text update -> " + it.getText());
            this$0.text = it.getText();
        }
        return Unit.INSTANCE;
    }
}

