/*
 * Decompiled with CFR 0.152.
 */
package com.remco.software.ncrunch.editor.rdi;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.remco.software.ncrunch.editor.EditorReference;
import com.remco.software.ncrunch.editor.rdi.RdiUIElementInfo;
import com.remco.software.ncrunch.model.EditorCaretChange;
import com.remco.software.ncrunch.model.NCrunchForRiderModel;
import com.remco.software.ncrunch.model.NCrunchForRiderModel_GeneratedKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/remco/software/ncrunch/editor/rdi/RdiCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "editorReference", "Lcom/remco/software/ncrunch/editor/EditorReference;", "<init>", "(Lcom/remco/software/ncrunch/editor/EditorReference;)V", "originalCaretColor", "Ljava/awt/Color;", "getOriginalCaretColor", "()Ljava/awt/Color;", "setOriginalCaretColor", "(Ljava/awt/Color;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "isCaretUnderButton", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "elements", "", "Lcom/remco/software/ncrunch/editor/rdi/RdiUIElementInfo;", "Companion", "ncrunchforrider"})
@SourceDebugExtension(value={"SMAP\nRdiCaretListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdiCaretListener.kt\ncom/remco/software/ncrunch/editor/rdi/RdiCaretListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class RdiCaretListener
implements CaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorReference editorReference;
    @Nullable
    private Color originalCaretColor;

    public RdiCaretListener(@NotNull EditorReference editorReference) {
        Intrinsics.checkNotNullParameter((Object)editorReference, (String)"editorReference");
        this.editorReference = editorReference;
    }

    @Nullable
    public final Color getOriginalCaretColor() {
        return this.originalCaretColor;
    }

    public final void setOriginalCaretColor(@Nullable Color color) {
        this.originalCaretColor = color;
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        block5: {
            Project project;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Caret caret = event.getCaret();
            if (caret == null) break block5;
            if (this.isCaretUnderButton(caret, this.editorReference.getRdiElementInfoList())) {
                if (this.originalCaretColor == null) {
                    this.originalCaretColor = event.getEditor().getColorsScheme().getColor(EditorColors.CARET_COLOR);
                }
                event.getEditor().getColorsScheme().setColor(EditorColors.CARET_COLOR, new Color(0, 0, 0, 0));
            } else if (this.originalCaretColor != null) {
                event.getEditor().getColorsScheme().setColor(EditorColors.CARET_COLOR, this.originalCaretColor);
                this.originalCaretColor = null;
            }
            if ((project = event.getEditor().getProject()) != null && (project = SolutionHostExtensionsKt.getSolution((Project)project)) != null) {
                Project it = project;
                boolean bl = false;
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Companion.sendCaretToNcrunch(caret, editor, this.editorReference.getEditorGuid(), NCrunchForRiderModel_GeneratedKt.getNCrunchForRiderModel((Solution)it));
            }
        }
    }

    private final boolean isCaretUnderButton(Caret caret, List<RdiUIElementInfo> elements) {
        Point point = caret.getEditor().visualPositionToXY(caret.getVisualPosition());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        Point caretPos = point;
        int lineHeight = caret.getEditor().getLineHeight();
        for (RdiUIElementInfo el : elements) {
            if (!el.isHand() || !((double)caretPos.x >= el.getX()) || !((double)caretPos.x <= el.getX() + el.getWidth()) || !((double)caretPos.y >= el.getY() - (double)lineHeight) || !((double)caretPos.y <= el.getY() + el.getHeight())) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/remco/software/ncrunch/editor/rdi/RdiCaretListener$Companion;", "", "<init>", "()V", "sendCaretToNcrunch", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorGuid", "Ljava/util/UUID;", "nCrunchForRiderModel", "Lcom/remco/software/ncrunch/model/NCrunchForRiderModel;", "ncrunchforrider"})
    public static final class Companion {
        private Companion() {
        }

        public final void sendCaretToNcrunch(@NotNull Caret caret, @NotNull Editor editor, @NotNull UUID editorGuid, @NotNull NCrunchForRiderModel nCrunchForRiderModel2) {
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)editorGuid, (String)"editorGuid");
            Intrinsics.checkNotNullParameter((Object)((Object)nCrunchForRiderModel2), (String)"nCrunchForRiderModel");
            LogicalPosition logicalPosition = caret.getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition position = logicalPosition;
            Point point = new RelativePoint((Component)editor.getContentComponent(), editor.visualPositionToXY(caret.getVisualPosition())).getScreenPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getScreenPoint(...)");
            Point screenPoint = point;
            nCrunchForRiderModel2.getCaretChanged().fire((Object)new EditorCaretChange(editorGuid, position.line, position.column, screenPoint.x, screenPoint.y));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

