/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ListAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;
import org.jdesktop.swingx.autocomplete.workarounds.AquaLnFPopupLocationFix;

public class AutoCompleteDecorator {
    static Object errorFeedbackAction = new TextAction("provide-error-feedback"){

        public void actionPerformed(ActionEvent e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(e));
        }
    };

    public static void decorate(JTextComponent textComponent, List items, boolean strictMatching) {
        AutoCompleteDecorator.decorate(textComponent, items, strictMatching, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JTextComponent textComponent, List items, boolean strictMatching, ObjectToStringConverter stringConverter) {
        TextComponentAdaptor adaptor = new TextComponentAdaptor(textComponent, items);
        AutoCompleteDocument document = new AutoCompleteDocument(adaptor, strictMatching, stringConverter);
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    public static void decorate(JList list, JTextComponent textComponent) {
        AutoCompleteDecorator.decorate(list, textComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JList list, JTextComponent textComponent, ObjectToStringConverter stringConverter) {
        ListAdaptor adaptor = new ListAdaptor(list, textComponent, stringConverter);
        AutoCompleteDocument document = new AutoCompleteDocument(adaptor, true, stringConverter);
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    public static void decorate(JComboBox comboBox) {
        AutoCompleteDecorator.decorate(comboBox, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(final JComboBox comboBox, final ObjectToStringConverter stringConverter) {
        boolean strictMatching = !comboBox.isEditable();
        comboBox.setEditable(true);
        AquaLnFPopupLocationFix.install(comboBox);
        JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
        final ComboBoxAdaptor adaptor = new ComboBoxAdaptor(comboBox);
        final AutoCompleteDocument document = new AutoCompleteDocument(adaptor, strictMatching, stringConverter);
        AutoCompleteDecorator.decorate(editorComponent, document, adaptor);
        final KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block5: {
                    int keyCode;
                    block7: {
                        block6: {
                            if (keyEvent.isActionKey()) {
                                return;
                            }
                            if (!comboBox.isDisplayable() || comboBox.isPopupVisible()) break block5;
                            keyCode = keyEvent.getKeyCode();
                            if (keyCode == 16) break block6;
                            if (keyCode == 17) break block6;
                            if (keyCode != 18) break block7;
                        }
                        return;
                    }
                    if (keyCode == 27) {
                        return;
                    }
                    comboBox.setPopupVisible(true);
                }
            }
        };
        editorComponent.addKeyListener(keyListener);
        if (stringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
            comboBox.setEditor(new AutoCompleteComboBoxEditor(comboBox.getEditor(), stringConverter));
        }
        comboBox.addPropertyChangeListener("editor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ComboBoxEditor editor = (ComboBoxEditor)e.getNewValue();
                if (editor != null && editor.getEditorComponent() != null) {
                    if (!(editor instanceof AutoCompleteComboBoxEditor) && stringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
                        comboBox.setEditor(new AutoCompleteComboBoxEditor(editor, stringConverter));
                    } else {
                        AutoCompleteDecorator.decorate((JTextComponent)editor.getEditorComponent(), document, adaptor);
                        editor.getEditorComponent().addKeyListener(keyListener);
                    }
                }
            }
        });
    }

    public static void decorate(JTextComponent textComponent, AutoCompleteDocument document, final AbstractAutoCompleteAdaptor adaptor) {
        textComponent.setDocument(document);
        textComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JTextComponent textComponent = (JTextComponent)e.getSource();
                adaptor.markEntireText();
            }
        });
        InputMap editorInputMap = textComponent.getInputMap();
        if (document.isStrictMatching()) {
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            editorInputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            editorInputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap editorActionMap = textComponent.getActionMap();
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            editorActionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(editorActionMap.get("delete-previous"), editorActionMap.get("selection-backward"), adaptor));
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        Action backspace;
        Action selectionBackward;
        AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action backspace, Action selectionBackward, AbstractAutoCompleteAdaptor adaptor) {
            super("nonstrict-backspace");
            this.backspace = backspace;
            this.selectionBackward = selectionBackward;
            this.adaptor = adaptor;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(e);
            } else {
                this.backspace.actionPerformed(e);
            }
        }
    }
}

