/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.error.ErrorListener;
import org.jdesktop.swingx.error.ErrorSupport;
import org.jdesktop.swingx.util.PaintUtils;

public class JXImageView
extends JXPanel {
    private Image image;
    private ErrorSupport errorSupport = new ErrorSupport(this);
    private Point2D imageLocation;
    private Paint checkerPaint;
    private double scale = 1.0;
    private boolean editable = true;
    private MoveHandler moveHandler = new MoveHandler(this);
    private boolean dragEnabled = false;
    private String exportName = "UntitledImage";
    private String exportFormat = "png";

    public JXImageView() {
        this.checkerPaint = ColorUtil.getCheckerPaint(Color.white, new Color(250, 250, 250), 50);
        this.setEditable(true);
    }

    public Point2D getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(Point2D imageLocation) {
        this.imageLocation = imageLocation;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image old = this.getImage();
        this.image = image;
        this.setImageLocation(null);
        this.setScale(1.0);
        this.repaint();
        this.firePropertyChange("image", old, this.image);
    }

    public void setImage(URL url) throws IOException {
        this.setImage(ImageIO.read(url));
    }

    public void setImage(File file) throws IOException {
        System.out.println("reading: " + file.getAbsolutePath());
        this.setImage(ImageIO.read(file));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.firePropertyChange("scale", oldScale, scale);
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (editable) {
            this.addMouseMotionListener(this.moveHandler);
            this.addMouseListener(this.moveHandler);
            this.setCursor(Cursor.getPredefinedCursor(12));
            try {
                this.setTransferHandler(new DnDHandler());
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                this.fireError(ex);
            }
        } else {
            this.removeMouseMotionListener(this.moveHandler);
            this.removeMouseListener(this.moveHandler);
            this.setCursor(Cursor.getDefaultCursor());
            this.setTransferHandler(null);
        }
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void addErrorListener(ErrorListener el) {
        this.errorSupport.addErrorListener(el);
    }

    public void removeErrorListener(ErrorListener el) {
        this.errorSupport.removeErrorListener(el);
    }

    protected void fireError(Throwable throwable) {
        this.errorSupport.fireErrorEvent(throwable);
    }

    public Action getOpenAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser chooser = new JFileChooser();
                chooser.showOpenDialog(JXImageView.this);
                File file = chooser.getSelectedFile();
                if (file != null) {
                    try {
                        JXImageView.this.setImage(file);
                    }
                    catch (IOException ex) {
                        System.out.println(ex.getMessage());
                        ex.printStackTrace();
                        JXImageView.this.fireError(ex);
                    }
                }
            }
        };
        action.putValue("Name", "Open");
        return action;
    }

    public Action getSaveAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage dst = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                Graphics2D g = (Graphics2D)dst.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(img, 0, 0, null);
                g.dispose();
                JFileChooser chooser = new JFileChooser();
                chooser.showSaveDialog(JXImageView.this);
                File file = chooser.getSelectedFile();
                if (file != null) {
                    try {
                        ImageIO.write((RenderedImage)dst, "png", file);
                    }
                    catch (IOException ex) {
                        System.out.println(ex.getMessage());
                        ex.printStackTrace();
                        JXImageView.this.fireError(ex);
                    }
                }
            }
        };
        action.putValue("Name", "Save");
        return action;
    }

    public Action getRotateClockwiseAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                BufferedImage dst = new BufferedImage(img.getHeight(null), img.getWidth(null), 2);
                Graphics2D g = (Graphics2D)src.getGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                AffineTransform trans = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                trans.translate(0.0, -src.getHeight());
                AffineTransformOp op = new AffineTransformOp(trans, 1);
                Rectangle2D rect = op.getBounds2D(src);
                op.filter(src, dst);
                JXImageView.this.setImage(dst);
            }
        };
        action.putValue("Name", "Rotate Clockwise");
        return action;
    }

    public Action getRotateCounterClockwiseAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                BufferedImage dst = new BufferedImage(img.getHeight(null), img.getWidth(null), 2);
                Graphics2D g = (Graphics2D)src.getGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                AffineTransform trans = AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0);
                trans.translate(-src.getWidth(), 0.0);
                AffineTransformOp op = new AffineTransformOp(trans, 1);
                Rectangle2D rect = op.getBounds2D(src);
                op.filter(src, dst);
                JXImageView.this.setImage(dst);
            }
        };
        action.putValue("Name", "Rotate CounterClockwise");
        return action;
    }

    public Action getZoomOutAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 0.5);
            }
        };
        action.putValue("Name", "Zoom Out");
        return action;
    }

    public Action getZoomInAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 2.0);
            }
        };
        action.putValue("Name", "Zoom In");
        return action;
    }

    protected void paintComponent(Graphics g) {
        ((Graphics2D)g).setPaint(this.checkerPaint);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getImage() != null) {
            Point2D center = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
            if (this.getImageLocation() != null) {
                center = this.getImageLocation();
            }
            Point2D.Double loc = new Point2D.Double();
            double width = (double)this.getImage().getWidth(null) * this.getScale();
            double height = (double)this.getImage().getHeight(null) * this.getScale();
            ((Point2D)loc).setLocation(center.getX() - width / 2.0, center.getY() - height / 2.0);
            g.drawImage(this.getImage(), (int)((Point2D)loc).getX(), (int)((Point2D)loc).getY(), (int)width, (int)height, null);
        }
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(String exportFormat) {
        this.exportFormat = exportFormat;
    }

    private class ImageTransferable
    implements Transferable {
        private Image img;
        private List files;
        private String exportName;
        private String exportFormat;

        public ImageTransferable(Image img, String exportName, String exportFormat) {
            this.img = img;
            this.exportName = exportName;
            this.exportFormat = exportFormat;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.javaFileListFlavor};
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor == DataFlavor.imageFlavor) {
                return true;
            }
            return flavor == DataFlavor.javaFileListFlavor;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DataFlavor.imageFlavor) {
                return this.img;
            }
            if (flavor == DataFlavor.javaFileListFlavor) {
                if (this.files == null) {
                    this.files = new ArrayList();
                    File file = File.createTempFile(this.exportName, "." + this.exportFormat);
                    ImageIO.write((RenderedImage)PaintUtils.convertToBufferedImage(this.img), this.exportFormat, file);
                    this.files.add(file);
                }
                return this.files;
            }
            return null;
        }
    }

    private class DnDHandler
    extends TransferHandler {
        DataFlavor urlFlavor = new DataFlavor("application/x-java-url;class=java.net.URL");

        public void exportAsDrag(JComponent c, InputEvent evt, int action) {
            super.exportAsDrag(c, evt, action);
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            System.out.println("exportDone: " + source + " " + data + " " + action);
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (DataFlavor.javaFileListFlavor.equals(flavors[i])) {
                    return true;
                }
                if (DataFlavor.imageFlavor.equals(flavors[i])) {
                    return true;
                }
                if (!this.urlFlavor.match(flavors[i])) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent c) {
            System.out.println("creating a transferable");
            JXImageView view = (JXImageView)c;
            return new ImageTransferable(view.getImage(), view.getExportName(), view.getExportFormat());
        }

        public boolean importData(JComponent comp, Transferable t) {
            System.out.println("importData called");
            if (this.canImport(comp, t.getTransferDataFlavors())) {
                try {
                    Object obj;
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        System.out.println("doing file list flavor");
                        if (files.size() > 0) {
                            File file = (File)files.get(0);
                            System.out.println("readingt hte image: " + file.getCanonicalPath());
                            BufferedImage img = ImageIO.read(file);
                            JXImageView.this.setImage(img);
                            return true;
                        }
                    }
                    if ((obj = t.getTransferData(this.urlFlavor)) instanceof URL) {
                        JXImageView.this.setImage((URL)obj);
                    }
                    return true;
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                    JXImageView.this.fireError(ex);
                }
            }
            return false;
        }
    }

    private class MoveHandler
    extends MouseInputAdapter {
        private JXImageView panel;
        private Point prev = null;
        private Point start = null;

        public MoveHandler(JXImageView panel) {
            this.panel = panel;
        }

        public void mousePressed(MouseEvent evt) {
            this.start = this.prev = evt.getPoint();
        }

        public void mouseDragged(MouseEvent evt) {
            Point curr = evt.getPoint();
            if (JXImageView.this.isDragEnabled() && curr.distance(this.start) > 5.0) {
                System.out.println("starting the drag: ");
                this.panel.getTransferHandler().exportAsDrag((JComponent)evt.getSource(), evt, 1);
                return;
            }
            int offx = curr.x - this.prev.x;
            int offy = curr.y - this.prev.y;
            Point2D offset = JXImageView.this.getImageLocation();
            if (offset == null) {
                offset = JXImageView.this.image != null ? new Point2D.Double(JXImageView.this.getWidth() / 2, JXImageView.this.getHeight() / 2) : new Point2D.Double(0.0, 0.0);
            }
            offset = new Point2D.Double(offset.getX() + (double)offx, offset.getY() + (double)offy);
            JXImageView.this.setImageLocation(offset);
            this.prev = curr;
            JXImageView.this.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
        }
    }
}

