/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.DefaultHyperlinkListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.ProgressDialog;
import com.eviware.x.dialogs.XDialogs;
import com.eviware.x.dialogs.XProgressDialog;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SwingDialogs
implements XDialogs {
    private Component parent;
    private JDialog extendedInfoDialog;
    private Boolean extendedInfoResult;

    public SwingDialogs(Component parent) {
        this.parent = parent;
    }

    @Override
    public void showErrorMessage(final String message) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                JOptionPane.showMessageDialog(this.parent, message, "Error", 0);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(SwingDialogs.this.parent, message, "Error", 0);
                    }
                });
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public boolean confirm(String question, String title) {
        return JOptionPane.showConfirmDialog(this.parent, question, title, 0) == 0;
    }

    @Override
    public boolean confirm(String question, String title, Component parent) {
        return JOptionPane.showConfirmDialog(parent, question, title, 0) == 0;
    }

    @Override
    public String prompt(String question, String title, String value) {
        return (String)JOptionPane.showInputDialog(this.parent, question, title, 3, null, null, value);
    }

    @Override
    public String prompt(String question, String title) {
        return JOptionPane.showInputDialog(this.parent, question, title, 3);
    }

    @Override
    public void showInfoMessage(String message) {
        this.showInfoMessage(message, "Information");
    }

    @Override
    public void showInfoMessage(final String message, final String title) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                JOptionPane.showMessageDialog(this.parent, message, title, 1);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(SwingDialogs.this.parent, message, title, 1);
                    }
                });
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public Object prompt(String question, String title, Object[] objects) {
        return JOptionPane.showInputDialog(this.parent, question, title, 2, null, objects, null);
    }

    @Override
    public Object prompt(String question, String title, Object[] objects, String value) {
        return JOptionPane.showInputDialog(this.parent, question, title, 2, null, objects, value);
    }

    @Override
    public Boolean confirmOrCancel(String question, String title) {
        int result = JOptionPane.showConfirmDialog(this.parent, question, title, 1);
        if (result == 2 || result == -1) {
            return null;
        }
        return result == 0;
    }

    @Override
    public int yesYesToAllOrNo(String question, String title) {
        Object[] buttons = new String[]{"Yes", "Yes to all", "No"};
        return JOptionPane.showOptionDialog(this.parent, question, title, 0, 3, null, buttons, buttons[0]);
    }

    @Override
    public XProgressDialog createProgressDialog(String label, int length, String initialValue, boolean canCancel) {
        return new ProgressDialog("Progress", label, length, initialValue, canCancel);
    }

    @Override
    public void showExtendedInfo(final String title, final String description, final String content, final Dimension size) {
        try {
            final JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("OK")));
            if (SwingUtilities.isEventDispatchThread()) {
                this.showExtendedInfo(title, description, content, buttonBar, size);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingDialogs.this.showExtendedInfo(title, description, content, buttonBar, size);
                    }
                });
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private void showExtendedInfo(String title, String description, String content, JPanel buttonBar, Dimension size) {
        this.extendedInfoDialog = new JDialog(UISupport.getMainFrame(), title);
        this.extendedInfoDialog.setModal(true);
        JPanel panel = new JPanel(new BorderLayout());
        if (description != null) {
            panel.add((Component)UISupport.buildDescription(title, description, null), "North");
        }
        JEditorPane editorPane = new JEditorPane("text/html", content);
        editorPane.setCaretPosition(0);
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new DefaultHyperlinkListener(editorPane));
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        panel.add(scrollPane);
        buttonBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        panel.add((Component)buttonBar, "South");
        this.extendedInfoDialog.getRootPane().setContentPane(panel);
        if (size == null) {
            this.extendedInfoDialog.setSize(400, 300);
        } else {
            this.extendedInfoDialog.setSize(size);
        }
        this.extendedInfoResult = null;
        UISupport.showDialog(this.extendedInfoDialog);
    }

    @Override
    public boolean confirmExtendedInfo(String title, String description, String content, Dimension size) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("OK")), (JButton)new JButton(new CancelAction("Cancel")));
        this.showExtendedInfo(title, description, content, buttonBar, size);
        return this.extendedInfoResult == null ? false : this.extendedInfoResult;
    }

    @Override
    public Boolean confirmOrCancleExtendedInfo(String title, String description, String content, Dimension size) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("Yes")), (JButton)new JButton(new NoAction("No")), (JButton)new JButton(new CancelAction("Cancel")));
        this.showExtendedInfo(title, description, content, buttonBar, size);
        return this.extendedInfoResult;
    }

    @Override
    public String selectXPath(String title, String info, String xml, String xpath) {
        return this.prompt("Specify XPath expression", "Select XPath", xpath);
    }

    @Override
    public String selectJsonPath(String title, String info, String json, String jsonPath) {
        return this.prompt("Specify JsonPath expression", "Select JsonPath", jsonPath);
    }

    @Override
    public char[] promptPassword(String question, String title) {
        JPasswordField passwordField = new JPasswordField();
        passwordField.addAncestorListener(new RequestFocusListener());
        JLabel qLabel = new JLabel(question);
        JOptionPane.showConfirmDialog(this.parent, new Object[]{qLabel, passwordField}, title, 2);
        return passwordField.getPassword();
    }

    private static class RequestFocusListener
    implements AncestorListener {
        private RequestFocusListener() {
        }

        @Override
        public void ancestorAdded(final AncestorEvent e) {
            final RequestFocusListener al = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JComponent component = e.getComponent();
                    component.requestFocusInWindow();
                    component.removeAncestorListener(al);
                }
            });
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
        }
    }

    private final class CancelAction
    extends AbstractAction {
        public CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = null;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }

    private final class NoAction
    extends AbstractAction {
        public NoAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = false;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }

    private final class OkAction
    extends AbstractAction {
        public OkAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = true;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }
}

