/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui;

import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponentFactory;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class URLDesktopPanel
extends DefaultDesktopPanel {
    private WebViewBasedBrowserComponent browser;
    private boolean closed;

    public URLDesktopPanel(String title, String description, String url) throws InterruptedException, InvocationTargetException {
        super(title, description, new JPanel(new BorderLayout()));
        JPanel panel = (JPanel)this.getComponent();
        this.browser = WebViewBasedBrowserComponentFactory.createBrowserComponent(false, WebViewBasedBrowserComponent.PopupStrategy.EXTERNAL_BROWSER);
        panel.add(this.browser.getComponent(), "Center");
        if (StringUtils.hasContent(url)) {
            this.navigate(url, null, true);
        }
    }

    public void navigate(String url, String errorUrl, boolean async) {
        if (async) {
            SwingUtilities.invokeLater(new Navigator(url, errorUrl));
        } else {
            this.browser.navigate(url);
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.browser.close(true);
        this.closed = true;
        return super.onClose(canCancel);
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected WebViewBasedBrowserComponent getBrowser() {
        return this.browser;
    }

    private class Navigator
    implements Runnable {
        private final String url;
        private final String errorUrl;

        public Navigator(String url, String errorUrl) {
            this.url = url;
            this.errorUrl = errorUrl;
        }

        @Override
        public void run() {
            URLDesktopPanel.this.browser.navigate(this.url);
        }
    }
}

