/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.AnalyticsHelper;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlRunTestCaseTestStep;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.report.JUnitSecurityReportCollector;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.support.SecurityTestRunListener;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.SoapUITestCaseRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class SoapUISecurityTestRunner
extends SoapUITestCaseRunner
implements SecurityTestRunListener {
    public static final String SOAPUI_EXPORT_SEPARATOR = "soapui.export.separator";
    public static final String TITLE = "SoapUI " + SoapUI.SOAPUI_VERSION + " Security Test Runner";
    private String securityTestName;
    private int securityTestCount;
    private int securityScanCount;
    private int securityScanRequestCount;
    private int securityScanAlertCount;
    private List<SecurityTestStepResult> failedResults = new ArrayList<SecurityTestStepResult>();
    private JUnitSecurityReportCollector reportCollector = new JUnitSecurityReportCollector();

    public static void main(String[] args) throws Exception {
        System.exit(new SoapUISecurityTestRunner().runFromCommandLine(args));
    }

    @Override
    protected boolean processCommandLine(CommandLine cmd) {
        if (cmd.hasOption("n")) {
            this.setSecurityTestName(cmd.getOptionValue("n"));
        }
        return super.processCommandLine(cmd);
    }

    public void setSecurityTestName(String securityTestName) {
        this.securityTestName = securityTestName;
    }

    @Override
    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = super.initCommandLineOptions();
        options.addOption("n", true, "Sets the security test name");
        return options;
    }

    public SoapUISecurityTestRunner() {
        super(TITLE);
    }

    public SoapUISecurityTestRunner(String title) {
        super(title);
    }

    @Override
    public boolean runRunner() throws Exception {
        AnalyticsHelper.initializeAnalytics();
        Analytics.trackSessionStart();
        if (System.getenv("startedFromGUI") == null) {
            Analytics.trackAction(SoapUIActions.LAUNCH_SECURITY_TEST_RUNNER);
        } else {
            Analytics.trackAction(SoapUIActions.LAUNCH_SECURITY_TEST_RUNNER_FROM_UI);
        }
        this.initGroovyLog();
        this.getAssertions().clear();
        String projectFile = this.getProjectFile();
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile, this.getProjectPassword());
        if (project.isDisabled()) {
            throw new Exception("Failed to load SoapUI project file [" + projectFile + "]");
        }
        this.initProject(project);
        this.ensureOutputFolder(project);
        this.log.info((Object)("Running SoapUI tests in project [" + project.getName() + "]"));
        String testSuite = this.getTestSuite();
        String testCase = this.getTestCase();
        long startTime = System.nanoTime();
        ArrayList<TestCase> testCasesToRun = new ArrayList<TestCase>();
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            WsdlTestSuite suite = project.getTestSuiteAt(c);
            for (int i = 0; i < suite.getTestCaseCount(); ++i) {
                TestCase tc = suite.getTestCaseAt(i);
                if ((testSuite == null || suite.getName().equals(suite.getName())) && testCase != null && tc.getName().equals(testCase)) {
                    testCasesToRun.add(tc);
                }
                this.addListeners(tc);
            }
        }
        if (testCasesToRun.size() > 0) {
            for (TestCase tc : testCasesToRun) {
                this.runTestCase((WsdlTestCase)tc);
            }
        } else if (testSuite != null) {
            WsdlTestSuite ts = project.getTestSuiteByName(testSuite);
            if (ts == null) {
                throw new Exception("TestSuite with name [" + testSuite + "] not found in project");
            }
            this.runSuite(ts);
        } else {
            this.runProject(project);
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        if (this.isPrintReport()) {
            this.printReport(timeTaken);
        }
        this.exportReports(project);
        if (this.isSaveAfterRun() && !project.isRemote()) {
            try {
                project.save();
            }
            catch (Throwable t) {
                this.log.error((Object)"Failed to save project", t);
            }
        }
        if (this.securityScanAlertCount > 0 && !this.isIgnoreErrors()) {
            throw new Exception("SecurityTest execution failed with " + this.securityScanAlertCount + " alert" + (this.securityScanAlertCount > 1 ? "s" : ""));
        }
        return true;
    }

    @Override
    protected void runProject(WsdlProject project) {
        try {
            this.log.info((Object)("Running Project [" + project.getName() + "], runType = " + (Object)((Object)project.getRunType())));
            for (TestSuite testSuite : project.getTestSuiteList()) {
                this.runSuite((WsdlTestSuite)testSuite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initProject(WsdlProject project) throws Exception {
        this.initProjectProperties(project);
    }

    @Override
    protected void exportReports(WsdlProject project) throws Exception {
        if (this.isJUnitReport()) {
            this.exportJUnitReports(this.reportCollector, this.getAbsoluteOutputFolder(project), project);
        }
    }

    @Override
    protected void addListeners(TestCase tc) {
        tc.addTestRunListener(this);
        if (this.isJunitReport()) {
            tc.addTestRunListener(this.reportCollector);
        }
    }

    public void exportJUnitReports(JUnitSecurityReportCollector collector, String folder, WsdlProject project) throws Exception {
        collector.saveReports(folder == null ? "" : folder);
    }

    @Override
    public void printReport(long timeTaken) {
        System.out.println();
        System.out.println("SoapUI " + SoapUI.SOAPUI_VERSION + " Security TestCaseRunner Summary");
        System.out.println("-----------------------------");
        System.out.println("Time Taken: " + timeTaken + "ms");
        System.out.println("Total SecurityTests: " + this.securityTestCount);
        System.out.println("Total SecurityScans: " + this.securityScanCount);
        System.out.println("Total SecurityScan Requests: " + this.securityScanRequestCount);
        System.out.println("Total Failed SecurityScan Requests: " + this.securityScanAlertCount);
    }

    @Override
    protected void runSuite(WsdlTestSuite suite) {
        try {
            for (TestCase testCase : suite.getTestCaseList()) {
                this.runTestCase((WsdlTestCase)testCase);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void runTestCase(WsdlTestCase testCase) {
        try {
            for (SecurityTest securityTest : testCase.getSecurityTestList()) {
                securityTest.addSecurityTestRunListener(this);
                if (!StringUtils.isNullOrEmpty(this.securityTestName) && !securityTest.getName().equals(this.securityTestName)) continue;
                this.runSecurityTest(securityTest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void runSecurityTest(SecurityTest securityTest) {
        securityTest.addSecurityTestRunListener(new SecurityTestRunListenerAdapter(){
            private int requestIndex = 0;

            @Override
            public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityCheckReqResult) {
                SoapUISecurityTestRunner.this.securityScanRequestCount++;
                if (securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                    SoapUISecurityTestRunner.this.securityScanAlertCount++;
                }
                SoapUISecurityTestRunner.this.log.info((Object)(securityCheckReqResult.getSecurityScan().getName() + " - " + securityCheckReqResult.getChangedParamsInfo(++this.requestIndex)));
            }

            @Override
            public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityCheckResult) {
                SoapUISecurityTestRunner.this.securityScanCount++;
            }

            @Override
            public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityCheck) {
                this.requestIndex = 0;
            }

            @Override
            public void afterStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
                if (result.getStatus() == SecurityResult.ResultStatus.FAILED) {
                    SoapUISecurityTestRunner.this.failedResults.add(result);
                }
            }
        });
        if (this.isJUnitReport()) {
            securityTest.addSecurityTestRunListener(this.reportCollector);
        }
        this.log.info((Object)("Running SecurityTest [" + securityTest.getName() + "] in TestCase [" + securityTest.getTestCase().getName() + "] in TestSuite [" + securityTest.getTestCase().getTestSuite().getName() + "]"));
        SecurityTestRunner runner = securityTest.run(null, false);
        this.log.info((Object)("SecurityTest [" + securityTest.getName() + "] finished with status [" + (Object)((Object)runner.getStatus()) + "] in " + runner.getTimeTaken() + "ms"));
        if (this.isJUnitReport()) {
            securityTest.removeSecurityTestRunListener(this.reportCollector);
        }
    }

    @Override
    public void afterStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
        if (!this.isPrintReport()) {
            return;
        }
        TestStep currentStep = runContext.getCurrentStep();
        String securityTestName = "";
        String securityScanName = "";
        if (!result.getSecurityScanResultList().isEmpty()) {
            securityTestName = result.getSecurityScanResultList().get(0).getSecurityScan().getParent().getName();
            securityScanName = result.getSecurityScanResultList().get(0).getSecurityScanName();
        }
        String countPropertyName = currentStep.getName() + " run count";
        Long count = new Long(this.getExportCount());
        if (count == null) {
            count = new Long(0L);
        }
        runContext.setProperty(countPropertyName, new Long(count + 1L));
        if (result.getStatus() == SecurityResult.ResultStatus.FAILED || this.isExportAll()) {
            try {
                Attachment[] attachments;
                String exportSeparator = System.getProperty(SOAPUI_EXPORT_SEPARATOR, "-");
                TestCase tc = currentStep.getTestCase();
                String nameBase = StringUtils.createFileName(securityTestName, '_') + exportSeparator + StringUtils.createFileName(securityScanName, '_') + exportSeparator + StringUtils.createFileName(tc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getName(), '_') + exportSeparator + StringUtils.createFileName(currentStep.getName(), '_') + "-" + count + "-" + (Object)((Object)result.getStatus());
                WsdlTestCaseRunner callingTestCaseRunner = (WsdlTestCaseRunner)runContext.getProperty("#CallingTestCaseRunner#");
                if (callingTestCaseRunner != null) {
                    WsdlTestCase ctc = callingTestCaseRunner.getTestCase();
                    WsdlRunTestCaseTestStep runTestCaseTestStep = (WsdlRunTestCaseTestStep)runContext.getProperty("#CallingRunTestCaseStep#");
                    nameBase = StringUtils.createFileName(securityTestName, '_') + exportSeparator + StringUtils.createFileName(ctc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(ctc.getName(), '_') + exportSeparator + StringUtils.createFileName(runTestCaseTestStep.getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getTestSuite().getName(), '_') + exportSeparator + StringUtils.createFileName(tc.getName(), '_') + exportSeparator + StringUtils.createFileName(currentStep.getName(), '_') + "-" + count + "-" + (Object)((Object)result.getStatus());
                }
                String absoluteOutputFolder = this.getAbsoluteOutputFolder(ModelSupport.getModelItemProject(tc));
                String fileName = absoluteOutputFolder + File.separator + nameBase + ".txt";
                if (result.getStatus() == SecurityResult.ResultStatus.FAILED) {
                    this.log.error((Object)(currentStep.getName() + " failed, exporting to [" + fileName + "]"));
                }
                File file = new File(fileName);
                file.getParentFile().mkdirs();
                PrintWriter writer = new PrintWriter(file);
                result.writeTo(writer);
                writer.close();
                if (result instanceof MessageExchange && (attachments = ((MessageExchange)((Object)result)).getResponseAttachments()) != null && attachments.length > 0) {
                    for (int c = 0; c < attachments.length; ++c) {
                        fileName = nameBase + "-attachment-" + (c + 1) + ".";
                        Attachment attachment = attachments[c];
                        String contentType = attachment.getContentType();
                        fileName = !"application/octet-stream".equals(contentType) && contentType != null && contentType.indexOf(47) != -1 ? fileName + contentType.substring(contentType.lastIndexOf(47) + 1) : fileName + "dat";
                        fileName = absoluteOutputFolder + File.separator + fileName;
                        FileOutputStream outFile = new FileOutputStream(fileName);
                        Tools.writeAll(outFile, attachment.getInputStream());
                        outFile.close();
                    }
                }
                this.setExportCount(this.getExportCount() + 1);
            }
            catch (Exception e) {
                this.log.error((Object)("Error saving failed result: " + e), (Throwable)e);
            }
        }
        this.setTestStepCount(this.getTestStepCount() + 1);
    }

    @Override
    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    @Override
    public void afterOriginalStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
    }

    @Override
    public void afterRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
    }

    @Override
    public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityScanResult) {
    }

    @Override
    public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityScanReqResult) {
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
    }

    @Override
    public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityScan) {
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, TestStepResult testStepResult) {
    }
}

