/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.AnalyticsHelper;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportLoadTestLogAction;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportStatisticsAction;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.AbstractSoapUITestRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class SoapUILoadTestRunner
extends AbstractSoapUITestRunner
implements LoadTestRunListener {
    private String testSuite;
    private String testCase;
    private String loadTest;
    private boolean printReport;
    private List<LoadTestRunner> failedTests = new ArrayList<LoadTestRunner>();
    private int testCaseCount;
    private int loadTestCount;
    private int limit = -1;
    private long threadCount = -1L;
    private boolean saveAfterRun;
    public static String TITLE = "SoapUI " + SoapUI.SOAPUI_VERSION + " LoadTest Runner";

    public static void main(String[] args) {
        System.exit(new SoapUILoadTestRunner().runFromCommandLine(args));
    }

    @Override
    protected boolean processCommandLine(CommandLine cmd) {
        String message = "";
        if (cmd.hasOption("e")) {
            this.setEndpoint(cmd.getOptionValue("e"));
        }
        if (cmd.hasOption("s")) {
            String testSuite = this.getCommandLineOptionSubstSpace(cmd, "s");
            this.setTestSuite(testSuite);
        }
        if (cmd.hasOption("c")) {
            String testCase = cmd.getOptionValue("c");
            this.setTestCase(testCase);
        }
        if (cmd.hasOption("l")) {
            this.setLoadTest(cmd.getOptionValue("l"));
        }
        if (cmd.hasOption("u")) {
            this.setUsername(cmd.getOptionValue("u"));
        }
        if (cmd.hasOption("p")) {
            this.setPassword(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("w")) {
            this.setWssPasswordType(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("d")) {
            this.setDomain(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("h")) {
            this.setHost(cmd.getOptionValue("h"));
        }
        if (cmd.hasOption("m")) {
            this.setLimit(Integer.parseInt(cmd.getOptionValue("m")));
        }
        if (cmd.hasOption("n")) {
            this.setThreadCount(Integer.parseInt(cmd.getOptionValue("n")));
        }
        if (cmd.hasOption("f")) {
            this.setOutputFolder(this.getCommandLineOptionSubstSpace(cmd, "f"));
        }
        if (cmd.hasOption("t")) {
            this.setSettingsFile(this.getCommandLineOptionSubstSpace(cmd, "t"));
        }
        this.setPrintReport(cmd.hasOption("r"));
        this.setSaveAfterRun(cmd.hasOption("S"));
        if (cmd.hasOption("x")) {
            this.setProjectPassword(cmd.getOptionValue("x"));
        }
        if (cmd.hasOption("v")) {
            this.setSoapUISettingsPassword(cmd.getOptionValue("v"));
        }
        if (cmd.hasOption("D")) {
            this.setSystemProperties(cmd.getOptionValues("D"));
        }
        if (cmd.hasOption("G")) {
            this.setGlobalProperties(cmd.getOptionValues("G"));
        }
        if (cmd.hasOption("P")) {
            this.setProjectProperties(cmd.getOptionValues("P"));
        }
        if (message.length() > 0) {
            this.log.error((Object)message);
            return false;
        }
        return true;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setThreadCount(long threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = new AbstractSoapUIRunner.SoapUIOptions("loadtestrunner");
        options.addOption("e", true, "Sets the endpoint");
        options.addOption("s", true, "Sets the testsuite");
        options.addOption("c", true, "Sets the testcase");
        options.addOption("l", true, "Sets the loadtest");
        options.addOption("u", true, "Sets the username");
        options.addOption("p", true, "Sets the password");
        options.addOption("w", true, "Sets the WSS password type, either 'Text' or 'Digest'");
        options.addOption("d", true, "Sets the domain");
        options.addOption("h", true, "Sets the host");
        options.addOption("m", true, "Overrides the LoadTest Limit");
        options.addOption("n", true, "Overrides the LoadTest ThreadCount");
        options.addOption("r", false, "Exports statistics and testlogs for each LoadTest run");
        options.addOption("f", true, "Sets the output folder to export to");
        options.addOption("t", true, "Sets the soapui-settings.xml file to use");
        options.addOption("x", true, "Sets project password for decryption if project is encrypted");
        options.addOption("v", true, "Sets password for soapui-settings.xml file");
        options.addOption("D", true, "Sets system property with name=value");
        options.addOption("G", true, "Sets global property with name=value");
        options.addOption("P", true, "Sets or overrides project property with name=value");
        options.addOption("S", false, "Saves the project after running the tests");
        return options;
    }

    public SoapUILoadTestRunner() {
        this(TITLE);
    }

    public SoapUILoadTestRunner(String title) {
        super(title);
    }

    public void setLoadTest(String loadTest) {
        this.loadTest = loadTest;
    }

    public void setPrintReport(boolean printReport) {
        this.printReport = printReport;
    }

    public void setSaveAfterRun(boolean saveAfterRun) {
        this.saveAfterRun = saveAfterRun;
    }

    @Override
    public boolean runRunner() throws Exception {
        AnalyticsHelper.initializeAnalytics();
        Analytics.trackSessionStart();
        if (System.getenv("startedFromGUI") == null) {
            Analytics.trackAction(SoapUIActions.LAUNCH_LOAD_TEST_RUNNER);
        } else {
            Analytics.trackAction(SoapUIActions.LAUNCH_LOAD_TEST_RUNNER_FROM_UI);
        }
        if (SoapUI.getSettings().getBoolean(UISettings.DONT_DISABLE_GROOVY_LOG)) {
            this.initGroovyLog();
        }
        String projectFile = this.getProjectFile();
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile, this.getProjectPassword());
        if (project.isDisabled()) {
            throw new Exception("Failed to load SoapUI project file [" + projectFile + "]");
        }
        this.initProjectProperties(project);
        int suiteCount = 0;
        if (this.testSuite != null && project.getTestSuiteByName(this.testSuite) == null) {
            throw new Exception("Missing TestSuite named [" + this.testSuite + "]");
        }
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            if (this.testSuite != null && !project.getTestSuiteAt(c).getName().equalsIgnoreCase(this.testSuite)) continue;
            this.runSuite(project.getTestSuiteAt(c));
            ++suiteCount;
        }
        if (suiteCount == 0) {
            this.log.warn((Object)("No test-suites matched argument [" + this.testSuite + "]"));
        } else if (this.testCaseCount == 0) {
            this.log.warn((Object)("No test-cases matched argument [" + this.testCase + "]"));
        } else if (this.loadTestCount == 0) {
            this.log.warn((Object)("No load-tests matched argument [" + this.loadTest + "]"));
        } else {
            if (this.saveAfterRun && !project.isRemote()) {
                try {
                    project.save();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Failed to save project", t);
                }
            }
            if (!this.failedTests.isEmpty()) {
                this.log.info((Object)(this.failedTests.size() + " load tests failed:"));
                for (LoadTestRunner loadTestRunner : this.failedTests) {
                    this.log.info((Object)(loadTestRunner.getLoadTest().getName() + ": " + loadTestRunner.getReason()));
                }
                throw new SoapUIException("LoadTests failed");
            }
        }
        return true;
    }

    public void runSuite(TestSuite suite) {
        if (this.testCase != null && suite.getTestCaseByName(this.testCase) == null) {
            return;
        }
        long start = System.currentTimeMillis();
        for (int c = 0; c < suite.getTestCaseCount(); ++c) {
            String name = suite.getTestCaseAt(c).getName();
            if (this.testCase == null || name.equalsIgnoreCase(this.testCase)) {
                this.runTestCase(suite.getTestCaseAt(c));
                ++this.testCaseCount;
                continue;
            }
            this.log.info((Object)("Skipping testcase [" + name + "], filter is [" + this.testCase + "]"));
        }
        this.log.info((Object)("SoapUI suite [" + suite.getName() + "] finished in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private void runTestCase(TestCase testCase) {
        if (this.loadTest != null && testCase.getLoadTestByName(this.loadTest) == null) {
            return;
        }
        for (int c = 0; c < testCase.getLoadTestCount(); ++c) {
            String name = testCase.getLoadTestAt(c).getName();
            if (this.loadTest != null && !this.loadTest.equalsIgnoreCase(name)) continue;
            this.runWsdlLoadTest((WsdlLoadTest)testCase.getLoadTestAt(c));
            ++this.loadTestCount;
        }
    }

    protected void runWsdlLoadTest(WsdlLoadTest loadTest) {
        try {
            this.log.info((Object)("Running LoadTest [" + loadTest.getName() + "]"));
            if (this.limit >= 0) {
                this.log.info((Object)("Overriding limit [" + loadTest.getTestLimit() + "] with specified [" + this.limit + "]"));
                loadTest.setTestLimit(this.limit);
            }
            if (this.threadCount >= 0L) {
                this.log.info((Object)("Overriding threadCount [" + loadTest.getThreadCount() + "] with specified [" + this.threadCount + "]"));
                loadTest.setThreadCount(this.threadCount);
            }
            loadTest.addLoadTestRunListener(this);
            WsdlLoadTestRunner runner = loadTest.run();
            while (!runner.hasStopped()) {
                if (runner.getStatus() == TestRunner.Status.RUNNING) {
                    this.log.info((Object)("LoadTest [" + loadTest.getName() + "] progress: " + runner.getProgress() + ", " + runner.getRunningThreadCount()));
                }
                Thread.sleep(1000L);
            }
            this.log.info((Object)("LoadTest [" + loadTest.getName() + "] finished with status " + runner.getStatus().toString()));
            if (this.printReport) {
                this.log.info((Object)("Exporting log and statistics for LoadTest [" + loadTest.getName() + "]"));
                loadTest.getStatisticsModel().finish();
                this.exportLog(loadTest);
                this.exportStatistics(loadTest);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
            this.log.error((Object)e);
        }
    }

    private void exportStatistics(WsdlLoadTest loadTest) throws IOException {
        ExportStatisticsAction exportStatisticsAction = new ExportStatisticsAction(loadTest.getStatisticsModel());
        String statisticsFileName = StringUtils.createFileName(loadTest.getName(), '_') + "-statistics.txt";
        if (this.getOutputFolder() != null) {
            this.ensureOutputFolder(loadTest);
            statisticsFileName = this.getAbsoluteOutputFolder(loadTest) + File.separator + statisticsFileName;
        }
        int cnt = exportStatisticsAction.exportToFile(new File(statisticsFileName));
        this.log.info((Object)("Exported " + cnt + " statistics to [" + statisticsFileName + "]"));
    }

    private void exportLog(WsdlLoadTest loadTest) throws IOException {
        LoadTestLog loadTestLog = loadTest.getLoadTestLog();
        ExportLoadTestLogAction exportLoadTestLogAction = new ExportLoadTestLogAction(loadTestLog, null);
        String logFileName = StringUtils.createFileName(loadTest.getName(), '_') + "-log.txt";
        if (this.getOutputFolder() != null) {
            this.ensureOutputFolder(loadTest);
            logFileName = this.getAbsoluteOutputFolder(loadTest) + File.separator + logFileName;
        }
        int cnt = exportLoadTestLogAction.exportToFile(new File(logFileName));
        this.log.info((Object)("Exported " + cnt + " log items to [" + logFileName + "]"));
        int errorCnt = 0;
        for (int c = 0; c < loadTestLog.getSize(); ++c) {
            LoadTestLogEntry entry = (LoadTestLogEntry)loadTestLog.getElementAt(c);
            if (entry == null || !entry.isError()) continue;
            String entryFileName = StringUtils.createFileName(loadTest.getName(), '_') + "-error-" + errorCnt++ + "-entry.txt";
            if (this.getOutputFolder() != null) {
                this.ensureOutputFolder(loadTest);
                entryFileName = this.getAbsoluteOutputFolder(loadTest) + File.separator + entryFileName;
            }
            try {
                entry.exportToFile(entryFileName);
                continue;
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        this.log.info((Object)("Exported " + errorCnt + " error results"));
    }

    public void setTestCase(String testCase) {
        this.testCase = testCase;
    }

    public void setTestSuite(String testSuite) {
        this.testSuite = testSuite;
    }

    @Override
    public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        if (loadTestRunner.getStatus() == TestRunner.Status.FAILED) {
            this.failedTests.add(loadTestRunner);
        }
    }

    @Override
    public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    @Override
    public void afterTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult testStepResult) {
        super.afterStep(testRunner, runContext, testStepResult);
    }

    @Override
    public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }

    @Override
    public void beforeTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    @Override
    public void beforeTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
        super.beforeStep(testRunner, runContext, testStep);
    }

    @Override
    public void loadTestStarted(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }

    @Override
    public void loadTestStopped(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }
}

