/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import org.apache.log4j.Logger;

public class PropertyExpansionRemover {
    private static final Logger log = Logger.getLogger(PropertyExpansionRemover.class);
    public static final String EXPANSION_START = "${";

    public static String removeExpansions(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        while (PropertyExpansionRemover.containsPropertyExpansion(output)) {
            output = PropertyExpansionRemover.removeExpansionAt(output, output.indexOf(EXPANSION_START));
        }
        return output;
    }

    private static String removeExpansionAt(String input, int startIndex) {
        String output = input;
        while (PropertyExpansionRemover.containsNestedExpansion(output, startIndex)) {
            output = PropertyExpansionRemover.removeExpansionAt(output, output.indexOf(EXPANSION_START, startIndex + 1));
        }
        int endIndex = output.indexOf(125, startIndex);
        return endIndex == -1 ? output : output.substring(0, startIndex) + output.substring(endIndex + 1);
    }

    private static boolean containsNestedExpansion(String output, int startIndex) {
        String textToProcess = output.substring(startIndex + EXPANSION_START.length());
        return textToProcess.contains(EXPANSION_START) && textToProcess.indexOf(EXPANSION_START) < textToProcess.indexOf(125);
    }

    private static boolean containsPropertyExpansion(String input) {
        if (input == null || !input.contains(EXPANSION_START)) {
            return false;
        }
        int startIndex = input.indexOf(EXPANSION_START);
        return input.indexOf(125, startIndex) != -1;
    }
}

