/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.tools.JarPackager;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class MockAsWar {
    protected static final String SOAPUI_SETTINGS = "[SoapUISettings]";
    protected static final String PROJECT_FILE_NAME = "[ProjectFileName]";
    protected static final String MOCKSERVICE_ENDPOINT = "[mockServiceEndpoint]";
    private static final String SOAPUI_HOME = "soapui.home";
    private static final String SOAPUI_BIN_FOLDER = "." + File.separator + "bin";
    private static final String SOAPUI_LIB_FOLDER = ".." + File.separator + "lib";
    protected File projectFile;
    protected File settingsFile;
    protected File warDir;
    private File warFile;
    protected File webInf;
    private File warLibDir;
    protected File soapUIDir;
    protected Logger log = Logger.getLogger(MockAsWar.class);
    private boolean includeExt;
    protected boolean includeActions;
    protected boolean includeListeners;
    private File actionsDir;
    private File listenersDir;
    protected final String localEndpoint;
    protected boolean enableWebUI;
    private WsdlProject project;

    public MockAsWar(String projectPath, String settingsPath, String warDir, String warFile, boolean includeExt, boolean actions, boolean listeners, String localEndpoint, boolean enableWebUI, WsdlProject project) {
        this.project = project;
        this.localEndpoint = localEndpoint;
        this.projectFile = new File(projectPath);
        this.settingsFile = StringUtils.hasContent(settingsPath) ? new File(settingsPath) : null;
        File file = this.warDir = StringUtils.hasContent(warDir) ? new File(warDir) : new File(System.getProperty("java.io.tmpdir"), "warasmock");
        if (!this.warDir.exists()) {
            this.warDir.mkdirs();
        }
        File file2 = this.warFile = !StringUtils.hasContent(warFile) ? null : new File(warFile);
        if (!warFile.contains(File.separator)) {
            this.warFile = new File(this.warDir, warFile);
        }
        this.includeExt = includeExt;
        this.includeActions = actions;
        this.includeListeners = listeners;
        this.enableWebUI = enableWebUI;
    }

    public void createMockAsWarArchive() {
        XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Creating War File", 3, "Building war file..", false);
        Worker.WorkerAdapter warWorker = new Worker.WorkerAdapter(){

            @Override
            public Object construct(XProgressMonitor monitor) {
                if (MockAsWar.this.prepareWarFile()) {
                    MockAsWar.this.createWebXml();
                    if (MockAsWar.this.warFile != null) {
                        MockAsWar.this.warFile.getParentFile().mkdirs();
                        ArrayList files = MockAsWar.this.getAllFilesFrom(MockAsWar.this.webInf);
                        files.add(new File(MockAsWar.this.warDir, "stylesheet.css"));
                        files.add(new File(MockAsWar.this.warDir, "header_logo.png"));
                        File[] filez = files.toArray(new File[files.size()]);
                        JarPackager.createJarArchive(MockAsWar.this.warFile, MockAsWar.this.warDir, filez);
                    }
                }
                return null;
            }
        };
        try {
            progressDialog.run(warWorker);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private ArrayList<File> getAllFilesFrom(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        if (dir.isDirectory()) {
            result.addAll(Arrays.asList(dir.listFiles()));
            ArrayList<File> toAdd = new ArrayList<File>();
            for (File f : result) {
                if (!f.isDirectory()) continue;
                toAdd.addAll(this.getAllFilesFrom(f));
            }
            result.addAll(toAdd);
        }
        return result;
    }

    protected void createWebXml() {
        URL url = SoapUI.class.getResource("/com/eviware/soapui/resources/mockaswar/web.xml");
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine).append("\n");
            }
            this.createContent(content);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(this.webInf, "web.xml"))));
            out.write(content.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createContent(StringBuilder content) {
        content.replace(content.indexOf(PROJECT_FILE_NAME), content.indexOf(PROJECT_FILE_NAME) + PROJECT_FILE_NAME.length(), this.projectFile.getName());
        content.replace(content.indexOf(SOAPUI_SETTINGS), content.indexOf(SOAPUI_SETTINGS) + SOAPUI_SETTINGS.length(), this.settingsFile != null && this.settingsFile.exists() && this.settingsFile.isFile() ? "WEB-INF/soapui/" + this.settingsFile.getName() : "");
        content.replace(content.indexOf(MOCKSERVICE_ENDPOINT), content.indexOf(MOCKSERVICE_ENDPOINT) + MOCKSERVICE_ENDPOINT.length(), this.localEndpoint);
        if (!this.includeActions) {
            String actionsString = "WEB-INF/actions";
            content.delete(content.indexOf(actionsString), content.indexOf(actionsString) + actionsString.length());
        }
        if (!this.includeListeners) {
            String listenersString = "WEB-INF/listeners";
            content.delete(content.indexOf(listenersString), content.indexOf(listenersString) + listenersString.length());
        }
        if (!this.enableWebUI) {
            String webUIEnabled = "<param-value>true</param-value>";
            String webUIDisabled = "<param-value>false</param-value>";
            content.replace(content.indexOf(webUIEnabled), content.indexOf(webUIEnabled) + webUIEnabled.length(), webUIDisabled);
        }
    }

    protected boolean prepareWarFile() {
        if (this.createWarFileSystem()) {
            String homePath = System.getProperty(SOAPUI_HOME) == null ? SOAPUI_BIN_FOLDER : System.getProperty(SOAPUI_HOME);
            File fromDir = new File(homePath, SOAPUI_LIB_FOLDER);
            JarPackager.copyAllFromTo(fromDir, this.warLibDir, new CaseInsensitiveFileFilter());
            if (this.includeExt) {
                String extDirPath = System.getProperty("soapui.ext.libraries");
                fromDir = extDirPath != null ? new File(extDirPath) : new File(new File(homePath), "ext");
                JarPackager.copyAllFromTo(fromDir, this.warLibDir, null);
            }
            String[] mainJar = new File(homePath).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("soapui") && name.toLowerCase().endsWith(".jar");
                }
            });
            fromDir = new File(homePath, mainJar[0]);
            JarPackager.copyFileToDir(fromDir, this.warLibDir);
            this.copyProjectFile();
            if (this.settingsFile != null && this.settingsFile.exists() && this.settingsFile.isFile()) {
                JarPackager.copyFileToDir(this.settingsFile, this.soapUIDir);
            }
            if (this.includeActions) {
                fromDir = new File(System.getProperty("soapui.ext.actions"));
                JarPackager.copyAllFromTo(fromDir, this.actionsDir, null);
            }
            if (this.includeListeners) {
                fromDir = new File(System.getProperty("soapui.ext.listeners"));
                JarPackager.copyAllFromTo(fromDir, this.listenersDir, null);
            }
            this.copyWarResource("header_logo.png");
            this.copyWarResource("stylesheet.css");
            return true;
        }
        return false;
    }

    protected void copyProjectFile() {
        JarPackager.copyFileToDir(this.projectFile, this.soapUIDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWarResource(String resource) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.warDir, resource));
            Tools.writeAll(out, SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/mockaswar/" + resource));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean createWarFileSystem() {
        if (this.warDir.isDirectory()) {
            this.log.info((Object)("Creating WAR directory in [" + this.warDir.getAbsolutePath() + "]"));
            this.webInf = new File(this.warDir, "WEB-INF");
            if (!this.directoryIsUsable(this.webInf)) {
                return false;
            }
            this.clearDir(this.webInf);
            this.warLibDir = new File(this.webInf, "lib");
            if (!this.directoryIsUsable(this.warLibDir)) {
                return false;
            }
            this.soapUIDir = new File(this.webInf, "soapui");
            if (!this.directoryIsUsable(this.soapUIDir)) {
                return false;
            }
            this.clearDir(this.soapUIDir);
            if (this.includeActions) {
                this.actionsDir = new File(this.webInf, "actions");
                if (!this.directoryIsUsable(this.actionsDir)) {
                    return false;
                }
                this.clearDir(this.actionsDir);
            }
            if (this.includeListeners) {
                this.listenersDir = new File(this.webInf, "listeners");
                if (!this.directoryIsUsable(this.listenersDir)) {
                    return false;
                }
                this.clearDir(this.listenersDir);
            }
            return true;
        }
        UISupport.showErrorMessage(this.warDir.getName() + " needs to be a directory!");
        return false;
    }

    private boolean directoryIsUsable(File dir) {
        if (!dir.mkdir() && !dir.exists()) {
            UISupport.showErrorMessage("Could not create directory " + dir.getAbsolutePath());
            return false;
        }
        return true;
    }

    protected void clearDir(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    protected static class CaseInsensitiveFileFilter
    implements FileFilter {
        protected static final ArrayList<String> excludes = Lists.newArrayList((Object[])new String[]{"servlet", "xulrunner", "Mozilla", "l2fprod", "tuxpack", "winpack", "ActiveQueryBuilder", "jxbrowser", "protection"});

        protected CaseInsensitiveFileFilter() {
        }

        @Override
        public boolean accept(final File file) {
            boolean pathNameExcluded = FluentIterable.from(excludes).anyMatch((Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String s) {
                    if (file == null || s == null || file.getName().isEmpty()) {
                        return true;
                    }
                    return file.getName().toLowerCase().contains(s.toLowerCase());
                }
            });
            return !pathNameExcluded;
        }
    }
}

