/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.Undoable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public final class JTextComponentPopupMenu
extends JPopupMenu
implements PopupMenuListener {
    private final JTextComponent textComponent;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private ClearAction clearAction;
    private SelectAllAction selectAllAction;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static JTextComponentPopupMenu add(JTextComponent textComponent) {
        JPopupMenu componentPopupMenu;
        JPopupMenu jPopupMenu = componentPopupMenu = textComponent instanceof RSyntaxTextArea ? ((RSyntaxTextArea)textComponent).getPopupMenu() : textComponent.getComponentPopupMenu();
        if (componentPopupMenu instanceof JTextComponentPopupMenu) {
            return (JTextComponentPopupMenu)componentPopupMenu;
        }
        JTextComponentPopupMenu popupMenu = new JTextComponentPopupMenu(textComponent);
        if (componentPopupMenu != null && componentPopupMenu.getComponentCount() > 0) {
            while (componentPopupMenu.getComponentCount() > 0) {
                Component comp = componentPopupMenu.getComponent(componentPopupMenu.getComponentCount() - 1);
                if (comp instanceof AbstractButton) {
                    if ("Copy".equals(((AbstractButton)comp).getText()) || "Cut".equals(((AbstractButton)comp).getText()) || "Paste".equals(((AbstractButton)comp).getText()) || "Undo".equals(((AbstractButton)comp).getText()) || "Redo".equals(((AbstractButton)comp).getText()) || "Can't Redo".equals(((AbstractButton)comp).getText()) || "Can't Undo".equals(((AbstractButton)comp).getText()) || "Select All".equals(((AbstractButton)comp).getText())) {
                        componentPopupMenu.remove(comp);
                        continue;
                    }
                    popupMenu.insert(comp, 0);
                }
                componentPopupMenu.remove(comp);
            }
            popupMenu.insert(new JSeparator(), 0);
        }
        if (componentPopupMenu != null) {
            for (PopupMenuListener listener : componentPopupMenu.getPopupMenuListeners()) {
                popupMenu.addPopupMenuListener(listener);
            }
        }
        if (textComponent instanceof RSyntaxTextArea) {
            ((RSyntaxTextArea)textComponent).setPopupMenu((JPopupMenu)popupMenu);
        } else {
            textComponent.setComponentPopupMenu(popupMenu);
        }
        return popupMenu;
    }

    private JTextComponentPopupMenu(JTextComponent textComponent) {
        super("Edit");
        this.textComponent = textComponent;
        if (textComponent instanceof Undoable || textComponent instanceof RSyntaxTextArea) {
            this.undoAction = new UndoAction();
            this.add(this.undoAction);
            this.redoAction = new RedoAction();
            this.add(this.redoAction);
            this.addSeparator();
        }
        this.cutAction = new CutAction();
        this.add(this.cutAction);
        this.copyAction = new CopyAction();
        this.add(this.copyAction);
        this.pasteAction = new PasteAction();
        this.add(this.pasteAction);
        this.clearAction = new ClearAction();
        this.add(this.clearAction);
        this.addSeparator();
        this.selectAllAction = new SelectAllAction();
        this.add(this.selectAllAction);
        this.addPopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.textComponent instanceof Undoable) {
            this.undoAction.setEnabled(((Undoable)((Object)this.textComponent)).canUndo());
            this.redoAction.setEnabled(((Undoable)((Object)this.textComponent)).canRedo());
        }
        if (this.textComponent instanceof RSyntaxTextArea) {
            this.undoAction.setEnabled(((RSyntaxTextArea)this.textComponent).canUndo());
            this.redoAction.setEnabled(((RSyntaxTextArea)this.textComponent).canRedo());
        }
        this.cutAction.setEnabled(this.textComponent.getSelectionEnd() != this.textComponent.getSelectionStart());
        this.copyAction.setEnabled(this.cutAction.isEnabled());
        this.clearAction.setEnabled(this.cutAction.isEnabled());
        this.selectAllAction.setEnabled(this.textComponent.getText().length() > 0);
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Y"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JTextComponentPopupMenu.this.textComponent instanceof RSyntaxTextArea) {
                ((RSyntaxTextArea)JTextComponentPopupMenu.this.textComponent).redoLastAction();
            } else {
                ((Undoable)((Object)JTextComponentPopupMenu.this.textComponent)).redo();
            }
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Z"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JTextComponentPopupMenu.this.textComponent instanceof RSyntaxTextArea) {
                ((RSyntaxTextArea)JTextComponentPopupMenu.this.textComponent).undoLastAction();
            } else {
                ((Undoable)((Object)JTextComponentPopupMenu.this.textComponent)).undo();
            }
        }
    }

    private final class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select All");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.selectAll();
        }
    }

    private final class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.setText("");
        }
    }

    private final class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.paste();
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.copy();
        }
    }

    private final class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentPopupMenu.this.textComponent.cut();
        }
    }
}

