/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting.groovy;

import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import org.codehaus.groovy.control.CompilerConfiguration;

public class SoapUIGroovyScriptEngine
implements SoapUIScriptEngine {
    private GroovyClassLoader classLoader;
    private GroovyShell shell;
    private Binding binding;
    private Script script;
    private String scriptText;
    protected ScriptSaver saver = new ScriptSaver();

    public SoapUIGroovyScriptEngine(ClassLoader parentClassLoader) {
        this.classLoader = new GroovyClassLoader(parentClassLoader);
        this.binding = new Binding();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setDebug(true);
        config.setVerbose(true);
        this.shell = new GroovyShell((ClassLoader)this.classLoader, this.binding, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object run() throws Exception {
        this.saver.lockSave();
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            Object result;
            if (StringUtils.isNullOrEmpty(this.scriptText)) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.script == null) {
                this.compile();
            }
            Object object = result = this.script.run();
            return object;
        }
        finally {
            state.restore();
            this.saver.unlockSave();
        }
    }

    protected synchronized void synchronizedSetScript(String scriptText) {
        if (scriptText != null && scriptText.equals(this.scriptText)) {
            return;
        }
        if (this.script != null) {
            this.script.setBinding(null);
            this.script = null;
            if (this.shell != null) {
                this.shell.resetLoadedClasses();
            }
            this.classLoader.clearCache();
        }
        this.scriptText = scriptText;
    }

    @Override
    public synchronized void setScript(String scriptText) {
        if (scriptText != null && !scriptText.equals(this.scriptText)) {
            this.saver.save(scriptText);
        }
    }

    protected synchronized void reset() {
        this.saver.lockSave();
        this.script = null;
        this.saver.unlockSave();
    }

    @Override
    public synchronized void compile() throws Exception {
        if (this.script == null) {
            SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
            try {
                this.script = this.shell.parse(this.scriptText);
                this.script.setBinding(this.binding);
            }
            finally {
                state.restore();
            }
        }
    }

    @Override
    public synchronized void setVariable(String name, Object value) {
        this.binding.setVariable(name, value);
    }

    @Override
    public synchronized void clearVariables() {
        if (this.binding != null) {
            this.binding.getVariables().clear();
        }
    }

    @Override
    public synchronized void release() {
        this.script = null;
        if (this.binding != null) {
            this.binding.getVariables().clear();
            this.binding = null;
        }
        if (this.shell != null) {
            this.shell.resetLoadedClasses();
            this.shell = null;
        }
    }

    protected Binding getBinding() {
        return this.binding;
    }

    protected GroovyClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected Script getScript() {
        return this.script;
    }

    protected String getScriptText() {
        return this.scriptText;
    }

    protected GroovyShell getShell() {
        return this.shell;
    }

    protected class ScriptSaver {
        private String text = null;
        private boolean locked = false;

        protected ScriptSaver() {
        }

        public synchronized void save(String scriptText) {
            if (this.locked) {
                this.text = scriptText;
            } else {
                SoapUIGroovyScriptEngine.this.synchronizedSetScript(scriptText);
            }
        }

        public synchronized void lockSave() {
            this.locked = true;
        }

        public synchronized void unlockSave() {
            if (this.text != null) {
                SoapUIGroovyScriptEngine.this.synchronizedSetScript(this.text);
                this.text = null;
            }
            this.locked = false;
        }
    }
}

