/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.property;

import com.eviware.soapui.config.JMSPropertyConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.JMSUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSPropertyInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSPropertyInspectorModel;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

public class JMSPropertyInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "JMS Properties";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequest) {
            JMSPropertyInspector inspector = new JMSPropertyInspector(new WsdlRequestJMSPropertiesModel((AbstractHttpRequest)modelItem));
            inspector.setEnabled(JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        return null;
    }

    private class WsdlRequestJMSPropertiesModel
    extends JMSPropertyInspectorModel.AbstractJMSPropertyModel<AbstractHttpRequest<?>> {
        AbstractHttpRequest<?> request;
        JMSPropertyInspector inspector;

        public WsdlRequestJMSPropertiesModel(AbstractHttpRequest<?> wsdlRequest) {
            super(false, wsdlRequest, "jmsProperty");
            this.request = wsdlRequest;
            this.request.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.request.getEndpoint() != null && evt.getPropertyName().equals("endpoint")) {
                this.inspector.setEnabled(this.request.getEndpoint().startsWith("jms://"));
            }
            super.propertyChange(evt);
        }

        @Override
        public void release() {
            super.release();
            this.request.removePropertyChangeListener(this);
        }

        @Override
        public StringToStringMap getJMSProperties() {
            List<JMSPropertyConfig> propertyList = this.request.getJMSPropertiesConfig().getJMSProperties();
            StringToStringMap stringToStringMap = new StringToStringMap(propertyList.size());
            for (JMSPropertyConfig jmsProperty : propertyList) {
                stringToStringMap.put(jmsProperty.getName(), jmsProperty.getValue());
            }
            return stringToStringMap;
        }

        @Override
        public void setJMSProperties(StringToStringMap stringToStringMap) {
            String[] keyList = stringToStringMap.getKeys();
            ArrayList<JMSPropertyConfig> propertyList = new ArrayList<JMSPropertyConfig>();
            for (String key : keyList) {
                JMSPropertyConfig jmsPropertyConfig = JMSPropertyConfig.Factory.newInstance();
                jmsPropertyConfig.setName(key);
                jmsPropertyConfig.setValue((String)stringToStringMap.get(key));
                propertyList.add(jmsPropertyConfig);
            }
            List<JMSPropertyConfig> propertyList2 = this.request.getJMSPropertiesConfig().getJMSProperties();
            propertyList2.clear();
            propertyList2.addAll(propertyList);
        }

        @Override
        public void setInspector(JMSPropertyInspector inspector) {
            this.inspector = inspector;
        }
    }
}

