/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AccessTokenStatusChangeListener;
import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

final class OAuth2AccessTokenStatusChangeManager
implements PropertyChangeListener {
    OAuth2AccessTokenStatusChangeListener listener = null;

    public OAuth2AccessTokenStatusChangeManager(OAuth2AccessTokenStatusChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("accessTokenStatus")) {
            OAuth2Profile.AccessTokenStatus status = (OAuth2Profile.AccessTokenStatus)((Object)evt.getNewValue());
            this.listener.onAccessTokenStatusChanged(status);
        }
    }

    public void register() {
        Preconditions.checkNotNull((Object)this.listener.getProfile(), (Object)"Could not get OAuth 2 profile from the listener");
        this.listener.getProfile().addPropertyChangeListener(this);
    }

    public void unregister() {
        Preconditions.checkNotNull((Object)this.listener.getProfile(), (Object)"Could not get OAuth 2 profile from the listener");
        this.listener.getProfile().removePropertyChangeListener(this);
    }
}

